/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.DetectedProfileActivator;
import org.codehaus.plexus.util.StringUtils;

public class SystemPropertyProfileActivator
extends DetectedProfileActivator {
    protected boolean canDetectActivation(Profile profile) {
        return profile.getActivation() != null && profile.getActivation().getProperty() != null;
    }

    public boolean isActive(Profile profile) {
        Activation activation = profile.getActivation();
        ActivationProperty property = activation.getProperty();
        if (property != null) {
            String sysValue = System.getProperty(property.getName());
            String propValue = property.getValue();
            if (StringUtils.isNotEmpty((String)propValue)) {
                return propValue.equals(sysValue);
            }
            return StringUtils.isNotEmpty((String)sysValue);
        }
        return false;
    }
}

