/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Build;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Goal;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.ModelUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenProject {
    private Model model;
    private MavenProject parent;
    private File file;
    private Set artifacts;
    private Artifact parentArtifact;
    private Set pluginArtifacts;
    private List remoteArtifactRepositories;
    private Properties profileProperties = new Properties();
    private List collectedProjects = Collections.EMPTY_LIST;
    private List attachedArtifacts;
    private MavenProject executionProject;
    private List compileSourceRoots = new ArrayList();
    private List testCompileSourceRoots = new ArrayList();
    private List scriptSourceRoots = new ArrayList();
    private List pluginArtifactRepositories;
    private ArtifactRepository distMgmtArtifactRepository;
    private List activeProfiles = new ArrayList();
    private Set dependencyArtifacts;

    public MavenProject(Model model) {
        this.model = model;
    }

    public MavenProject(MavenProject project) {
        this.file = project.file;
        this.dependencyArtifacts = Collections.unmodifiableSet(project.dependencyArtifacts);
        if (project.artifacts != null) {
            this.artifacts = Collections.unmodifiableSet(project.artifacts);
        }
        this.pluginArtifacts = Collections.unmodifiableSet(project.pluginArtifacts);
        this.remoteArtifactRepositories = Collections.unmodifiableList(project.remoteArtifactRepositories);
        this.pluginArtifactRepositories = Collections.unmodifiableList(project.pluginArtifactRepositories);
        this.attachedArtifacts = Collections.unmodifiableList(project.getAttachedArtifacts());
        this.collectedProjects = Collections.unmodifiableList(project.collectedProjects);
        this.activeProfiles = Collections.unmodifiableList(project.activeProfiles);
        this.compileSourceRoots = new ArrayList(project.compileSourceRoots);
        this.testCompileSourceRoots = new ArrayList(project.testCompileSourceRoots);
        this.scriptSourceRoots = new ArrayList(project.scriptSourceRoots);
        this.profileProperties = new Properties(project.profileProperties);
        this.model = ModelUtils.cloneModel(project.model);
    }

    public Model getModel() {
        return this.model;
    }

    public MavenProject getParent() {
        return this.parent;
    }

    public void setParent(MavenProject parent) {
        this.parent = parent;
    }

    public void setRemoteArtifactRepositories(List remoteArtifactRepositories) {
        this.remoteArtifactRepositories = remoteArtifactRepositories;
    }

    public List getRemoteArtifactRepositories() {
        return this.remoteArtifactRepositories;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getBasedir() {
        if (this.getFile() != null) {
            return this.getFile().getParentFile();
        }
        return new File(System.getProperty("user.dir"));
    }

    public void setDependencies(List denpendencies) {
        this.model.setDependencies(denpendencies);
    }

    public List getDependencies() {
        return this.model.getDependencies();
    }

    public DependencyManagement getDependencyManagement() {
        return this.model.getDependencyManagement();
    }

    public void addCompileSourceRoot(String path) {
        if (path != null && (path = path.trim()).length() != 0 && !this.compileSourceRoots.contains(path)) {
            this.compileSourceRoots.add(path);
        }
    }

    public void addScriptSourceRoot(String path) {
        if (path != null && (path = path.trim()).length() != 0 && !this.scriptSourceRoots.contains(path)) {
            this.scriptSourceRoots.add(path);
        }
    }

    public void addTestCompileSourceRoot(String path) {
        if (path != null && (path = path.trim()).length() != 0 && !this.testCompileSourceRoots.contains(path)) {
            this.testCompileSourceRoots.add(path);
        }
    }

    public List getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    public List getScriptSourceRoots() {
        return this.scriptSourceRoots;
    }

    public List getTestCompileSourceRoots() {
        return this.testCompileSourceRoots;
    }

    public List getCompileClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size());
        Iterator i = this.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!MavenProject.isAddedToClasspath(a) || !"compile".equals(a.getScope()) && !"provided".equals(a.getScope())) continue;
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        return list;
    }

    public List getCompileArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        Iterator i = this.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!MavenProject.isAddedToClasspath(a) || !"compile".equals(a.getScope()) && !"provided".equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    public List getCompileDependencies() {
        Set artifacts = this.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts.size());
        Iterator i = this.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!"compile".equals(a.getScope()) && !"provided".equals(a.getScope())) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            list.add(dependency);
        }
        return list;
    }

    public List getTestClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size() + 1);
        list.add(this.getBuild().getOutputDirectory());
        Iterator i = this.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!MavenProject.isAddedToClasspath(a) || !"test".equals(a.getScope()) && !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        return list;
    }

    public List getTestArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        Iterator i = this.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!MavenProject.isAddedToClasspath(a) || !"test".equals(a.getScope()) && !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    public List getTestDependencies() {
        Set artifacts = this.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts.size());
        Iterator i = this.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!"test".equals(a.getScope()) && !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            list.add(dependency);
        }
        return list;
    }

    public List getRuntimeClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size() + 1);
        list.add(this.getBuild().getOutputDirectory());
        Iterator i = this.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!MavenProject.isAddedToClasspath(a) || !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        return list;
    }

    public List getRuntimeArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        Iterator i = this.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!MavenProject.isAddedToClasspath(a) || !"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    public List getRuntimeDependencies() {
        Set artifacts = this.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts.size());
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact a = (Artifact)i.next();
            if (!"compile".equals(a.getScope()) && !"runtime".equals(a.getScope())) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            list.add(dependency);
        }
        return list;
    }

    private static boolean isAddedToClasspath(Artifact artifact) {
        String type = artifact.getType();
        return "jar".equals(type) || "ejb".equals(type) || "ejb-client".equals(type);
    }

    public void setModelVersion(String pomVersion) {
        this.model.setModelVersion(pomVersion);
    }

    public String getModelVersion() {
        return this.model.getModelVersion();
    }

    public String getId() {
        return this.model.getId();
    }

    public void setGroupId(String groupId) {
        this.model.setGroupId(groupId);
    }

    public String getGroupId() {
        return this.model.getGroupId();
    }

    public void setArtifactId(String artifactId) {
        this.model.setArtifactId(artifactId);
    }

    public String getArtifactId() {
        return this.model.getArtifactId();
    }

    public void setName(String name) {
        this.model.setName(name);
    }

    public String getName() {
        if (this.model.getName() != null) {
            return this.model.getName();
        }
        return this.getId();
    }

    public void setVersion(String version) {
        this.model.setVersion(version);
    }

    public String getVersion() {
        return this.model.getVersion();
    }

    public String getPackaging() {
        return this.model.getPackaging();
    }

    public void setPackaging(String packaging) {
        this.model.setPackaging(packaging);
    }

    public void setInceptionYear(String inceptionYear) {
        this.model.setInceptionYear(inceptionYear);
    }

    public String getInceptionYear() {
        return this.model.getInceptionYear();
    }

    public void setUrl(String url) {
        this.model.setUrl(url);
    }

    public String getUrl() {
        return this.model.getUrl();
    }

    public void setIssueManagement(IssueManagement issueManagement) {
        this.model.setIssueManagement(issueManagement);
    }

    public CiManagement getCiManagement() {
        return this.model.getCiManagement();
    }

    public void setCiManagement(CiManagement ciManagement) {
        this.model.setCiManagement(ciManagement);
    }

    public IssueManagement getIssueManagement() {
        return this.model.getIssueManagement();
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        this.model.setDistributionManagement(distributionManagement);
    }

    public DistributionManagement getDistributionManagement() {
        return this.model.getDistributionManagement();
    }

    public void setDescription(String description) {
        this.model.setDescription(description);
    }

    public String getDescription() {
        return this.model.getDescription();
    }

    public void setOrganization(Organization organization) {
        this.model.setOrganization(organization);
    }

    public Organization getOrganization() {
        return this.model.getOrganization();
    }

    public void setScm(Scm scm) {
        this.model.setScm(scm);
    }

    public Scm getScm() {
        return this.model.getScm();
    }

    public void setMailingLists(List mailingLists) {
        this.model.setMailingLists(mailingLists);
    }

    public List getMailingLists() {
        return this.model.getMailingLists();
    }

    public void addMailingList(MailingList mailingList) {
        this.model.addMailingList(mailingList);
    }

    public void setDevelopers(List developers) {
        this.model.setDevelopers(developers);
    }

    public List getDevelopers() {
        return this.model.getDevelopers();
    }

    public void addDeveloper(Developer developer) {
        this.model.addDeveloper(developer);
    }

    public void setContributors(List contributors) {
        this.model.setContributors(contributors);
    }

    public List getContributors() {
        return this.model.getContributors();
    }

    public void addContributor(Contributor contributor) {
        this.model.addContributor(contributor);
    }

    public void setBuild(Build build) {
        this.model.setBuild(build);
    }

    public Build getBuild() {
        return this.model.getBuild();
    }

    public void setReporting(Reporting reporting) {
        this.model.setReporting(reporting);
    }

    public Reporting getReporting() {
        return this.model.getReporting();
    }

    public void setLicenses(List licenses) {
        this.model.setLicenses(licenses);
    }

    public List getLicenses() {
        return this.model.getLicenses();
    }

    public void addLicense(License license) {
        this.model.addLicense(license);
    }

    public void setArtifacts(Set artifacts) {
        this.artifacts = artifacts;
    }

    public Set getArtifacts() {
        return this.artifacts;
    }

    public void setPluginArtifacts(Set pluginArtifacts) {
        this.pluginArtifacts = pluginArtifacts;
    }

    public Set getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    public void setParentArtifact(Artifact parentArtifact) {
        this.parentArtifact = parentArtifact;
    }

    public Artifact getParentArtifact() {
        return this.parentArtifact;
    }

    public List getRepositories() {
        return this.model.getRepositories();
    }

    public List getReportPlugins() {
        if (this.model.getReporting() == null) {
            return null;
        }
        return this.model.getReporting().getPlugins();
    }

    public List getBuildPlugins() {
        if (this.model.getBuild() == null) {
            return null;
        }
        return this.model.getBuild().getPlugins();
    }

    public List getModules() {
        return this.model.getModules();
    }

    public PluginManagement getPluginManagement() {
        PluginManagement pluginMgmt = null;
        Build build = this.model.getBuild();
        if (build != null) {
            pluginMgmt = build.getPluginManagement();
        }
        return pluginMgmt;
    }

    public void addPlugin(Plugin plugin) {
        Build build = this.model.getBuild();
        if (build == null) {
            build = new Build();
            this.model.setBuild(build);
        }
        build.addPlugin(plugin);
    }

    public List getCollectedProjects() {
        return this.collectedProjects;
    }

    public void setCollectedProjects(List collectedProjects) {
        this.collectedProjects = collectedProjects;
    }

    public void setPluginArtifactRepositories(List pluginArtifactRepositories) {
        this.pluginArtifactRepositories = pluginArtifactRepositories;
    }

    public List getPluginArtifactRepositories() {
        return this.pluginArtifactRepositories;
    }

    public void setDistributionManagementArtifactRepository(ArtifactRepository distMgmtArtifactRepository) {
        this.distMgmtArtifactRepository = distMgmtArtifactRepository;
    }

    public ArtifactRepository getDistributionManagementArtifactRepository() {
        return this.distMgmtArtifactRepository;
    }

    public List getPluginRepositories() {
        return this.model.getPluginRepositories();
    }

    public Properties getProfileProperties() {
        return this.profileProperties;
    }

    public void addProfileProperties(Properties profileConfiguration) {
        ((Hashtable)this.profileProperties).putAll(profileConfiguration);
    }

    public void setActiveProfiles(List activeProfiles) {
        this.activeProfiles.addAll(activeProfiles);
    }

    public List getActiveProfiles() {
        return this.activeProfiles;
    }

    public void addAttachedArtifact(Artifact artifact) {
        this.getAttachedArtifacts().add(artifact);
    }

    public List getAttachedArtifacts() {
        if (this.attachedArtifacts == null) {
            this.attachedArtifacts = new ArrayList();
        }
        return this.attachedArtifacts;
    }

    public Xpp3Dom getGoalConfiguration(String pluginGroupId, String pluginArtifactId, String executionId, String goalId) {
        Xpp3Dom dom = null;
        if (this.getBuildPlugins() != null) {
            Iterator iterator = this.getBuildPlugins().iterator();
            while (iterator.hasNext()) {
                Xpp3Dom executionConfiguration;
                PluginExecution execution;
                Xpp3Dom newDom;
                Xpp3Dom goalConfiguration;
                Goal goal;
                Plugin plugin = (Plugin)iterator.next();
                if (!pluginGroupId.equals(plugin.getGroupId()) || !pluginArtifactId.equals(plugin.getArtifactId())) continue;
                dom = (Xpp3Dom)plugin.getConfiguration();
                if (goalId != null && (goal = (Goal)plugin.getGoalsAsMap().get(goalId)) != null && (goalConfiguration = (Xpp3Dom)goal.getConfiguration()) != null) {
                    newDom = new Xpp3Dom(goalConfiguration);
                    dom = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)newDom, (Xpp3Dom)dom);
                }
                if (executionId == null || (execution = (PluginExecution)plugin.getExecutionsAsMap().get(executionId)) == null || (executionConfiguration = (Xpp3Dom)execution.getConfiguration()) == null) break;
                newDom = new Xpp3Dom(executionConfiguration);
                dom = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)newDom, (Xpp3Dom)dom);
                break;
            }
        }
        if (dom != null) {
            dom = new Xpp3Dom(dom);
        }
        return dom;
    }

    public Xpp3Dom getReportConfiguration(String pluginGroupId, String pluginArtifactId, String reportSetId) {
        Xpp3Dom dom = null;
        if (this.getReportPlugins() != null) {
            Iterator iterator = this.getReportPlugins().iterator();
            while (iterator.hasNext()) {
                Xpp3Dom executionConfiguration;
                ReportSet reportSet;
                ReportPlugin plugin = (ReportPlugin)iterator.next();
                if (!pluginGroupId.equals(plugin.getGroupId()) || !pluginArtifactId.equals(plugin.getArtifactId())) continue;
                dom = (Xpp3Dom)plugin.getConfiguration();
                if (reportSetId == null || (reportSet = (ReportSet)plugin.getReportSetsAsMap().get(reportSetId)) == null || (executionConfiguration = (Xpp3Dom)reportSet.getConfiguration()) == null) break;
                Xpp3Dom newDom = new Xpp3Dom(executionConfiguration);
                dom = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)newDom, (Xpp3Dom)dom);
                break;
            }
        }
        if (dom != null) {
            dom = new Xpp3Dom(dom);
        }
        return dom;
    }

    public MavenProject getExecutionProject() {
        return this.executionProject;
    }

    public void setExecutionProject(MavenProject executionProject) {
        this.executionProject = executionProject;
    }

    public void writeModel(Writer writer) throws IOException {
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write(writer, this.getModel());
    }

    public Set getDependencyArtifacts() {
        return this.dependencyArtifacts;
    }

    public void setDependencyArtifacts(Set dependencyArtifacts) {
        this.dependencyArtifacts = dependencyArtifacts;
    }
}

