/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.model.Goal;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.inheritance.DefaultModelInheritanceAssembler;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public final class ModelUtils {
    public static void mergePluginLists(PluginContainer childContainer, PluginContainer parentContainer, boolean handleAsInheritance) {
        if (childContainer == null || parentContainer == null) {
            return;
        }
        List parentPlugins = parentContainer.getPlugins();
        if (parentPlugins != null && !parentPlugins.isEmpty()) {
            TreeMap<String, Plugin> assembledPlugins = new TreeMap<String, Plugin>();
            Map childPlugins = childContainer.getPluginsAsMap();
            Iterator<Object> it = parentPlugins.iterator();
            while (it.hasNext()) {
                Plugin parentPlugin = (Plugin)it.next();
                String parentInherited = parentPlugin.getInherited();
                if (handleAsInheritance && parentInherited != null && !Boolean.valueOf(parentInherited).booleanValue()) continue;
                Plugin assembledPlugin = parentPlugin;
                Plugin childPlugin = (Plugin)childPlugins.get(parentPlugin.getKey());
                if (childPlugin != null) {
                    assembledPlugin = childPlugin;
                    ModelUtils.mergePluginDefinitions(childPlugin, parentPlugin, handleAsInheritance);
                }
                if (handleAsInheritance && parentInherited == null) {
                    assembledPlugin.unsetInheritanceApplied();
                }
                assembledPlugins.put(assembledPlugin.getKey(), assembledPlugin);
            }
            it = childPlugins.values().iterator();
            while (it.hasNext()) {
                Plugin childPlugin = (Plugin)it.next();
                if (assembledPlugins.containsKey(childPlugin.getKey())) continue;
                assembledPlugins.put(childPlugin.getKey(), childPlugin);
            }
            childContainer.setPlugins(new ArrayList(assembledPlugins.values()));
            childContainer.flushPluginMap();
        }
    }

    public static void mergePluginDefinitions(Plugin child, Plugin parent, boolean handleAsInheritance) {
        if (child == null || parent == null) {
            return;
        }
        if (child.getVersion() == null && parent.getVersion() != null) {
            child.setVersion(parent.getVersion());
        }
        ModelUtils.mergeGoalContainerDefinitions(child, parent);
        String parentInherited = parent.getInherited();
        boolean parentIsInherited = parentInherited == null || Boolean.valueOf(parentInherited) != false;
        List parentExecutions = parent.getExecutions();
        if (parentExecutions != null && !parentExecutions.isEmpty()) {
            TreeMap<String, Object> assembledExecutions = new TreeMap<String, Object>();
            Map childExecutions = child.getExecutionsAsMap();
            Iterator<Object> it = parentExecutions.iterator();
            while (it.hasNext()) {
                PluginExecution parentExecution = (PluginExecution)it.next();
                if (handleAsInheritance && !parentIsInherited) continue;
                PluginExecution assembled = parentExecution;
                PluginExecution childExecution = (PluginExecution)childExecutions.get(parentExecution.getId());
                if (childExecution != null) {
                    ModelUtils.mergePluginExecutionDefinitions(childExecution, parentExecution);
                    assembled = childExecution;
                } else if (handleAsInheritance && parentInherited == null) {
                    parentExecution.unsetInheritanceApplied();
                }
                assembledExecutions.put(assembled.getId(), assembled);
            }
            it = childExecutions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String id = (String)entry.getKey();
                if (assembledExecutions.containsKey(id)) continue;
                assembledExecutions.put(id, entry.getValue());
            }
            child.setExecutions(new ArrayList(assembledExecutions.values()));
            child.flushExecutionMap();
        }
    }

    private static void mergeGoalContainerDefinitions(Plugin child, Plugin parent) {
        List parentGoals = parent.getGoals();
        if (parentGoals != null && !parentGoals.isEmpty()) {
            TreeMap<String, Goal> assembledGoals = new TreeMap<String, Goal>();
            Map childGoals = child.getGoalsAsMap();
            if (childGoals != null) {
                Goal childGoal;
                Iterator<Object> it = parentGoals.iterator();
                while (it.hasNext()) {
                    Goal parentGoal;
                    Goal assembledGoal = parentGoal = (Goal)it.next();
                    childGoal = (Goal)childGoals.get(parentGoal.getId());
                    if (childGoal != null) {
                        Xpp3Dom childGoalConfig = (Xpp3Dom)childGoal.getConfiguration();
                        Xpp3Dom parentGoalConfig = (Xpp3Dom)parentGoal.getConfiguration();
                        childGoalConfig = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childGoalConfig, (Xpp3Dom)parentGoalConfig);
                        childGoal.setConfiguration((Object)childGoalConfig);
                        assembledGoal = childGoal;
                    }
                    assembledGoals.put(assembledGoal.getId(), assembledGoal);
                }
                it = childGoals.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    String key = (String)entry.getKey();
                    childGoal = (Goal)entry.getValue();
                    if (assembledGoals.containsKey(key)) continue;
                    assembledGoals.put(key, childGoal);
                }
                child.setGoals(new ArrayList(assembledGoals.values()));
                child.flushGoalMap();
            }
        }
        Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
        childConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childConfiguration, (Xpp3Dom)parentConfiguration);
        child.setConfiguration((Object)childConfiguration);
    }

    private static void mergePluginExecutionDefinitions(PluginExecution child, PluginExecution parent) {
        List parentGoals = parent.getGoals();
        if (parentGoals != null && !parentGoals.isEmpty()) {
            ArrayList goals = new ArrayList(parentGoals);
            if (child.getGoals() != null) {
                goals.addAll(child.getGoals());
            }
            child.setGoals(goals);
        }
        Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
        childConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)childConfiguration, (Xpp3Dom)parentConfiguration);
        child.setConfiguration((Object)childConfiguration);
    }

    static Model cloneModel(Model model) {
        Model newModel = new Model();
        DefaultModelInheritanceAssembler assembler = new DefaultModelInheritanceAssembler();
        assembler.assembleModelInheritance(newModel, model);
        newModel.setVersion(model.getVersion());
        return newModel;
    }
}

