/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.MavenTools;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MavenTools.class)
public class DefaultMavenTools
implements MavenTools,
LogEnabled {
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Requirement
    private ArtifactRepositoryLayout defaultArtifactRepositoryLayout;
    @Requirement
    private Logger logger;
    private static HashMap<String, Artifact> cache = new HashMap();

    @Override
    public List<ArtifactRepository> buildArtifactRepositories(List<Repository> repositories) throws InvalidRepositoryException {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        for (Repository mavenRepo : repositories) {
            ArtifactRepository artifactRepo = this.buildArtifactRepository(mavenRepo);
            if (repos.contains(artifactRepo)) continue;
            repos.add(artifactRepo);
        }
        return repos;
    }

    @Override
    public ArtifactRepository buildDeploymentArtifactRepository(DeploymentRepository repo) throws InvalidRepositoryException {
        if (repo != null) {
            String id = repo.getId();
            String url = repo.getUrl();
            return this.artifactRepositoryFactory.createDeploymentArtifactRepository(id, url, repo.getLayout(), repo.isUniqueVersion());
        }
        return null;
    }

    @Override
    public ArtifactRepository buildArtifactRepository(Repository repo) throws InvalidRepositoryException {
        if (repo != null) {
            String id = repo.getId();
            String url = repo.getUrl();
            if (id == null || id.trim().length() < 1) {
                throw new InvalidRepositoryException("Repository ID must not be empty (URL is: " + url + ").", url);
            }
            if (url == null || url.trim().length() < 1) {
                throw new InvalidRepositoryException("Repository URL must not be empty (ID is: " + id + ").", id);
            }
            ArtifactRepositoryPolicy snapshots = this.buildArtifactRepositoryPolicy(repo.getSnapshots());
            ArtifactRepositoryPolicy releases = this.buildArtifactRepositoryPolicy(repo.getReleases());
            return this.artifactRepositoryFactory.createArtifactRepository(id, url, repo.getLayout(), snapshots, releases);
        }
        return null;
    }

    public ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }

    @Override
    public ArtifactRepository createLocalRepository(String url, String repositoryId) throws IOException {
        return this.createRepository(this.canonicalFileUrl(url), repositoryId);
    }

    private String canonicalFileUrl(String url) throws IOException {
        if (!url.startsWith("file:")) {
            url = "file://" + url;
        } else if (url.startsWith("file:") && !url.startsWith("file://")) {
            url = "file://" + url.substring("file:".length());
        }
        File localRepository = new File(url.substring("file://".length()));
        if (!localRepository.isAbsolute()) {
            url = "file://" + localRepository.getCanonicalPath();
        }
        return url;
    }

    @Override
    public ArtifactRepository createRepository(String url, String repositoryId) {
        String updatePolicyFlag = "always";
        String checksumPolicyFlag = "warn";
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        return this.artifactRepositoryFactory.createArtifactRepository(repositoryId, url, this.defaultArtifactRepositoryLayout, snapshotsPolicy, releasesPolicy);
    }

    @Override
    public ArtifactRepository createRepository(String url, String repositoryId, ArtifactRepositoryPolicy snapshotsPolicy, ArtifactRepositoryPolicy releasesPolicy) {
        return this.artifactRepositoryFactory.createArtifactRepository(repositoryId, url, this.defaultArtifactRepositoryLayout, snapshotsPolicy, releasesPolicy);
    }

    @Override
    public void setGlobalUpdatePolicy(String policy) {
        this.artifactRepositoryFactory.setGlobalUpdatePolicy(policy);
    }

    @Override
    public void setGlobalChecksumPolicy(String policy) {
        this.artifactRepositoryFactory.setGlobalChecksumPolicy(policy);
    }

    @Override
    public void findModelFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ProjectBuildingException {
        Artifact projectArtifact;
        if (cache.containsKey(artifact.getId())) {
            artifact.setFile(cache.get(artifact.getId()).getFile());
        }
        String projectId = this.safeVersionlessKey(artifact.getGroupId(), artifact.getArtifactId());
        remoteArtifactRepositories = this.normalizeToArtifactRepositories(remoteArtifactRepositories, projectId);
        if ("pom".equals(artifact.getType())) {
            projectArtifact = artifact;
        } else {
            this.logger.debug("Attempting to build MavenProject instance for Artifact (" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ") of type: " + artifact.getType() + "; constructing POM artifact instead.");
            projectArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
        }
        try {
            this.artifactResolver.resolve(projectArtifact, remoteArtifactRepositories, localRepository);
            File file = projectArtifact.getFile();
            artifact.setFile(file);
            cache.put(artifact.getId(), artifact);
        }
        catch (ArtifactResolutionException e) {
            throw new ProjectBuildingException(projectId, "Error getting POM for '" + projectId + "' from the repository: " + e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new ProjectBuildingException(projectId, "POM '" + projectId + "' not found in repository: " + e.getMessage(), e);
        }
    }

    @Override
    public List<ArtifactRepository> buildArtifactRepositories(Model model) throws ProjectBuildingException {
        try {
            return this.buildArtifactRepositories(model.getRepositories());
        }
        catch (InvalidRepositoryException e) {
            String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
            throw new ProjectBuildingException(projectId, e.getMessage(), e);
        }
    }

    private List normalizeToArtifactRepositories(List remoteArtifactRepositories, String projectId) throws ProjectBuildingException {
        ArrayList normalized = new ArrayList(remoteArtifactRepositories.size());
        boolean normalizationNeeded = false;
        for (Object item : remoteArtifactRepositories) {
            if (item instanceof ArtifactRepository) {
                normalized.add(item);
                continue;
            }
            if (item instanceof Repository) {
                Repository repo = (Repository)item;
                try {
                    item = this.buildArtifactRepository(repo);
                    normalized.add(item);
                    normalizationNeeded = true;
                    continue;
                }
                catch (InvalidRepositoryException e) {
                    throw new ProjectBuildingException(projectId, "Error building artifact repository for id: " + repo.getId(), e);
                }
            }
            throw new ProjectBuildingException(projectId, "Error building artifact repository from non-repository information item: " + item);
        }
        if (normalizationNeeded) {
            return normalized;
        }
        return remoteArtifactRepositories;
    }

    private String safeVersionlessKey(String groupId, String artifactId) {
        String aid;
        String gid = groupId;
        if (StringUtils.isEmpty((String)gid)) {
            gid = "unknown";
        }
        if (StringUtils.isEmpty((String)(aid = artifactId))) {
            aid = "unknown";
        }
        return ArtifactUtils.versionlessKey((String)gid, (String)aid);
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void resolve(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws IOException {
        File artifactFile = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
        artifact.setFile(artifactFile);
        try {
            this.artifactResolver.resolve(artifact, remoteRepositories, localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new IOException(e.getMessage());
        }
        catch (ArtifactNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }
}

