/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import java.io.IOException;
import java.util.Map;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.interpolation.EnvarBasedValueSource;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ProfileActivator.class, hint="file")
public class FileProfileActivator
implements ProfileActivator,
LogEnabled {
    private Logger logger;

    public boolean canDetermineActivation(Profile profile, ProfileActivationContext context) {
        return profile.getActivation() != null && profile.getActivation().getFile() != null;
    }

    public boolean isActive(Profile profile, ProfileActivationContext context) {
        Activation activation = profile.getActivation();
        ActivationFile actFile = activation.getFile();
        if (actFile != null) {
            String fileString = actFile.getExists();
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            try {
                interpolator.addValueSource((ValueSource)new EnvarBasedValueSource());
            }
            catch (IOException e) {
                // empty catch block
            }
            interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)System.getProperties()));
            if (StringUtils.isNotEmpty((String)fileString)) {
                try {
                    fileString = StringUtils.replace((String)interpolator.interpolate(fileString, ""), (String)"\\", (String)"/");
                }
                catch (InterpolationException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Failed to interpolate exists file location for profile activator: " + fileString, (Throwable)e);
                    }
                    this.logger.warn("Failed to interpolate exists file location for profile activator: " + fileString + ". Run in debug mode (-X) for more information.");
                }
                boolean result = FileUtils.fileExists((String)fileString);
                if (this.logger != null) {
                    this.logger.debug("FileProfileActivator: Checking file existence for: " + fileString + ". Result: " + result);
                }
                return result;
            }
            fileString = actFile.getMissing();
            if (StringUtils.isNotEmpty((String)fileString)) {
                boolean result;
                try {
                    fileString = StringUtils.replace((String)interpolator.interpolate(fileString, ""), (String)"\\", (String)"/");
                }
                catch (InterpolationException e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Failed to interpolate missing file location for profile activator: " + fileString, (Throwable)e);
                    }
                    this.logger.warn("Failed to interpolate missing file location for profile activator: " + fileString + ". Run in debug mode (-X) for more information.");
                }
                boolean bl = result = !FileUtils.fileExists((String)fileString);
                if (this.logger != null) {
                    this.logger.debug("FileProfileActivator: Checking file is missing for: " + fileString + ". Result: " + result);
                }
                return result;
            }
        } else if (this.logger != null) {
            this.logger.debug("FileProfileActivator: no file specified. Skipping activation.");
        }
        return false;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

