/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.maven.MavenTools;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.ManagedVersionMap;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Build;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.DuplicateArtifactAttachmentException;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ModelUtils;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.ActiveProjectArtifact;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProject
implements Cloneable {
    public static final String EMPTY_PROJECT_GROUP_ID = "unknown";
    public static final String EMPTY_PROJECT_ARTIFACT_ID = "empty-project";
    public static final String EMPTY_PROJECT_VERSION = "0";
    private Model model;
    private MavenProject parent;
    private File file;
    private Set artifacts;
    private Artifact parentArtifact;
    private Set<Artifact> pluginArtifacts;
    private List<ArtifactRepository> remoteArtifactRepositories;
    private List collectedProjects = Collections.EMPTY_LIST;
    private List<Artifact> attachedArtifacts;
    private MavenProject executionProject;
    private List compileSourceRoots = new ArrayList();
    private List testCompileSourceRoots = new ArrayList();
    private List scriptSourceRoots = new ArrayList();
    private List pluginArtifactRepositories;
    private ArtifactRepository releaseArtifactRepository;
    private ArtifactRepository snapshotArtifactRepository;
    private List activeProfiles = new ArrayList();
    private Set dependencyArtifacts;
    private Artifact artifact;
    private Map artifactMap;
    private Model originalModel;
    private Map pluginArtifactMap;
    private Set reportArtifacts;
    private Map reportArtifactMap;
    private Set extensionArtifacts;
    private Map extensionArtifactMap;
    private Map managedVersionMap;
    private Map projectReferences = new HashMap();
    private boolean executionRoot;
    private Map moduleAdjustments;
    private Stack previousExecutionProjects = new Stack();
    private ArtifactFactory artifactFactory;
    private MavenProjectBuilder mavenProjectBuilder;
    private ProjectBuilderConfiguration projectBuilderConfiguration;
    private File parentFile;

    public File getParentFile() {
        return this.parentFile;
    }

    public void setParentFile(File parentFile) {
        this.parentFile = parentFile;
    }

    public MavenProject() {
        Model model = new Model();
        model.setGroupId(EMPTY_PROJECT_GROUP_ID);
        model.setArtifactId(EMPTY_PROJECT_ARTIFACT_ID);
        model.setVersion(EMPTY_PROJECT_VERSION);
        this.setModel(model);
    }

    public MavenProject(Model model) {
        this.setModel(model);
    }

    public MavenProject(Model model, ArtifactFactory artifactFactory, MavenTools mavenTools, MavenProjectBuilder mavenProjectBuilder, ProjectBuilderConfiguration projectBuilderConfiguration) throws InvalidRepositoryException {
        this.setModel(model);
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.projectBuilderConfiguration = projectBuilderConfiguration;
        this.artifactFactory = artifactFactory;
        this.originalModel = model;
        DistributionManagement dm = model.getDistributionManagement();
        if (dm != null) {
            ArtifactRepository repo = mavenTools.buildDeploymentArtifactRepository(dm.getRepository());
            this.setReleaseArtifactRepository(repo);
            if (dm.getSnapshotRepository() != null) {
                repo = mavenTools.buildDeploymentArtifactRepository(dm.getSnapshotRepository());
                this.setSnapshotArtifactRepository(repo);
            }
        }
        try {
            LinkedHashSet repoSet = new LinkedHashSet();
            if (model.getRepositories() != null && !model.getRepositories().isEmpty()) {
                repoSet.addAll(model.getRepositories());
            }
            if (model.getPluginRepositories() != null && !model.getPluginRepositories().isEmpty()) {
                repoSet.addAll(model.getPluginRepositories());
            }
            this.setRemoteArtifactRepositories(mavenTools.buildArtifactRepositories(new ArrayList<Repository>(repoSet)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public MavenProject(MavenProject project) {
        this.deepCopy(project);
    }

    public String getModulePathAdjustment(MavenProject moduleProject) throws IOException {
        String module = moduleProject.getArtifactId();
        File moduleFile = moduleProject.getFile();
        if (moduleFile != null) {
            File moduleDir = moduleFile.getCanonicalFile().getParentFile();
            module = moduleDir.getName();
        }
        if (this.moduleAdjustments == null) {
            this.moduleAdjustments = new HashMap();
            List modules = this.getModules();
            if (modules != null) {
                for (String modulePath : modules) {
                    int lastSlash;
                    String moduleName = modulePath;
                    if (moduleName.endsWith("/") || moduleName.endsWith("\\")) {
                        moduleName = moduleName.substring(0, moduleName.length() - 1);
                    }
                    if ((lastSlash = moduleName.lastIndexOf(47)) < 0) {
                        lastSlash = moduleName.lastIndexOf(92);
                    }
                    String adjustment = null;
                    if (lastSlash > -1) {
                        moduleName = moduleName.substring(lastSlash + 1);
                        adjustment = modulePath.substring(0, lastSlash);
                    }
                    this.moduleAdjustments.put(moduleName, adjustment);
                }
            }
        }
        return (String)this.moduleAdjustments.get(module);
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Model getModel() {
        return this.model;
    }

    public MavenProject getParent() {
        if (this.parent == null) {
            if (this.parentFile != null) {
                try {
                    this.parent = this.mavenProjectBuilder.build(this.parentFile, this.projectBuilderConfiguration);
                }
                catch (ProjectBuildingException e) {
                    e.printStackTrace();
                }
            } else if (this.model.getParent() != null) {
                try {
                    this.parent = this.mavenProjectBuilder.buildFromRepository(this.getParentArtifact(), this.remoteArtifactRepositories, this.projectBuilderConfiguration.getLocalRepository());
                }
                catch (ProjectBuildingException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.parent;
    }

    public void setParent(MavenProject parent) {
        this.parent = parent;
    }

    public void setRemoteArtifactRepositories(List remoteArtifactRepositories) {
        this.remoteArtifactRepositories = remoteArtifactRepositories;
    }

    public List<ArtifactRepository> getRemoteArtifactRepositories() {
        return this.remoteArtifactRepositories;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getBasedir() {
        if (this.getFile() != null) {
            return this.getFile().getParentFile();
        }
        return null;
    }

    public void setDependencies(List dependencies) {
        this.getModel().setDependencies(dependencies);
    }

    public List getDependencies() {
        return this.getModel().getDependencies();
    }

    public DependencyManagement getDependencyManagement() {
        return this.getModel().getDependencyManagement();
    }

    public void addCompileSourceRoot(String path) {
        if (path != null && (path = path.trim()).length() != 0 && !this.getCompileSourceRoots().contains(path)) {
            this.getCompileSourceRoots().add(path);
        }
    }

    public void addScriptSourceRoot(String path) {
        if (path != null && (path = path.trim()).length() != 0 && !this.getScriptSourceRoots().contains(path)) {
            this.getScriptSourceRoots().add(path);
        }
    }

    public void addTestCompileSourceRoot(String path) {
        if (path != null && (path = path.trim()).length() != 0 && !this.getTestCompileSourceRoots().contains(path)) {
            this.getTestCompileSourceRoots().add(path);
        }
    }

    public List getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    public List getScriptSourceRoots() {
        return this.scriptSourceRoots;
    }

    public List getTestCompileSourceRoots() {
        return this.testCompileSourceRoots;
    }

    public List getCompileClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size());
        list.add(this.getBuild().getOutputDirectory());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !Artifact.SCOPE_COMPILE.equals(a.getScope()) && !Artifact.SCOPE_PROVIDED.equals(a.getScope()) && !Artifact.SCOPE_SYSTEM.equals(a.getScope())) continue;
            this.addArtifactPath(a, list);
        }
        return list;
    }

    public List getCompileArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !Artifact.SCOPE_COMPILE.equals(a.getScope()) && !Artifact.SCOPE_PROVIDED.equals(a.getScope()) && !Artifact.SCOPE_SYSTEM.equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    public List getCompileDependencies() {
        Set artifacts = this.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts.size());
        for (Artifact a : this.getArtifacts()) {
            if (!Artifact.SCOPE_COMPILE.equals(a.getScope()) && !Artifact.SCOPE_PROVIDED.equals(a.getScope()) && !Artifact.SCOPE_SYSTEM.equals(a.getScope())) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            dependency.setClassifier(a.getClassifier());
            list.add(dependency);
        }
        return list;
    }

    public List getTestClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size() + 2);
        list.add(this.getBuild().getTestOutputDirectory());
        list.add(this.getBuild().getOutputDirectory());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath()) continue;
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        return list;
    }

    public List getTestArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath()) continue;
            list.add(a);
        }
        return list;
    }

    public List getTestDependencies() {
        Set artifacts = this.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts.size());
        for (Artifact a : this.getArtifacts()) {
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            dependency.setClassifier(a.getClassifier());
            list.add(dependency);
        }
        return list;
    }

    public List getRuntimeClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size() + 1);
        list.add(this.getBuild().getOutputDirectory());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !Artifact.SCOPE_COMPILE.equals(a.getScope()) && !Artifact.SCOPE_RUNTIME.equals(a.getScope())) continue;
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        return list;
    }

    public List getRuntimeArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !Artifact.SCOPE_COMPILE.equals(a.getScope()) && !Artifact.SCOPE_RUNTIME.equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    public List getRuntimeDependencies() {
        Set artifacts = this.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts.size());
        for (Artifact a : artifacts) {
            if (!Artifact.SCOPE_COMPILE.equals(a.getScope()) && !Artifact.SCOPE_RUNTIME.equals(a.getScope())) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            dependency.setClassifier(a.getClassifier());
            list.add(dependency);
        }
        return list;
    }

    public List getSystemClasspathElements() throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(this.getArtifacts().size());
        list.add(this.getBuild().getOutputDirectory());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !Artifact.SCOPE_SYSTEM.equals(a.getScope())) continue;
            this.addArtifactPath(a, list);
        }
        return list;
    }

    public List getSystemArtifacts() {
        ArrayList<Artifact> list = new ArrayList<Artifact>(this.getArtifacts().size());
        for (Artifact a : this.getArtifacts()) {
            if (!a.getArtifactHandler().isAddedToClasspath() || !Artifact.SCOPE_SYSTEM.equals(a.getScope())) continue;
            list.add(a);
        }
        return list;
    }

    public List getSystemDependencies() {
        Set artifacts = this.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Dependency> list = new ArrayList<Dependency>(artifacts.size());
        for (Artifact a : this.getArtifacts()) {
            if (!Artifact.SCOPE_SYSTEM.equals(a.getScope())) continue;
            Dependency dependency = new Dependency();
            dependency.setArtifactId(a.getArtifactId());
            dependency.setGroupId(a.getGroupId());
            dependency.setVersion(a.getVersion());
            dependency.setScope(a.getScope());
            dependency.setType(a.getType());
            dependency.setClassifier(a.getClassifier());
            list.add(dependency);
        }
        return list;
    }

    public void setModelVersion(String pomVersion) {
        this.getModel().setModelVersion(pomVersion);
    }

    public String getModelVersion() {
        return this.getModel().getModelVersion();
    }

    public String getId() {
        return this.getModel().getId();
    }

    public void setGroupId(String groupId) {
        this.getModel().setGroupId(groupId);
    }

    public String getGroupId() {
        String groupId = this.getModel().getGroupId();
        if (groupId == null && this.getModel().getParent() != null) {
            groupId = this.getModel().getParent().getGroupId();
        }
        return groupId;
    }

    public void setArtifactId(String artifactId) {
        this.getModel().setArtifactId(artifactId);
    }

    public String getArtifactId() {
        return this.getModel().getArtifactId();
    }

    public void setName(String name) {
        this.getModel().setName(name);
    }

    public String getName() {
        if (this.getModel().getName() != null) {
            return this.getModel().getName();
        }
        return "Unnamed - " + this.getId();
    }

    public void setVersion(String version) {
        this.getModel().setVersion(version);
    }

    public String getVersion() {
        String version = this.getModel().getVersion();
        if (version == null && this.getModel().getParent() != null) {
            version = this.getModel().getParent().getVersion();
        }
        return version;
    }

    public String getPackaging() {
        return this.getModel().getPackaging();
    }

    public void setPackaging(String packaging) {
        this.getModel().setPackaging(packaging);
    }

    public void setInceptionYear(String inceptionYear) {
        this.getModel().setInceptionYear(inceptionYear);
    }

    public String getInceptionYear() {
        return this.getModel().getInceptionYear();
    }

    public void setUrl(String url) {
        this.getModel().setUrl(url);
    }

    public String getUrl() {
        return this.getModel().getUrl();
    }

    public Prerequisites getPrerequisites() {
        return this.getModel().getPrerequisites();
    }

    public void setIssueManagement(IssueManagement issueManagement) {
        this.getModel().setIssueManagement(issueManagement);
    }

    public CiManagement getCiManagement() {
        return this.getModel().getCiManagement();
    }

    public void setCiManagement(CiManagement ciManagement) {
        this.getModel().setCiManagement(ciManagement);
    }

    public IssueManagement getIssueManagement() {
        return this.getModel().getIssueManagement();
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        this.getModel().setDistributionManagement(distributionManagement);
    }

    public DistributionManagement getDistributionManagement() {
        return this.getModel().getDistributionManagement();
    }

    public void setDescription(String description) {
        this.getModel().setDescription(description);
    }

    public String getDescription() {
        return this.getModel().getDescription();
    }

    public void setOrganization(Organization organization) {
        this.getModel().setOrganization(organization);
    }

    public Organization getOrganization() {
        return this.getModel().getOrganization();
    }

    public void setScm(Scm scm) {
        this.getModel().setScm(scm);
    }

    public Scm getScm() {
        return this.getModel().getScm();
    }

    public void setMailingLists(List mailingLists) {
        this.getModel().setMailingLists(mailingLists);
    }

    public List getMailingLists() {
        return this.getModel().getMailingLists();
    }

    public void addMailingList(MailingList mailingList) {
        this.getModel().addMailingList(mailingList);
    }

    public void setDevelopers(List developers) {
        this.getModel().setDevelopers(developers);
    }

    public List getDevelopers() {
        return this.getModel().getDevelopers();
    }

    public void addDeveloper(Developer developer) {
        this.getModel().addDeveloper(developer);
    }

    public void setContributors(List contributors) {
        this.getModel().setContributors(contributors);
    }

    public List getContributors() {
        return this.getModel().getContributors();
    }

    public void addContributor(Contributor contributor) {
        this.getModel().addContributor(contributor);
    }

    public void setBuild(Build build) {
        this.getModel().setBuild(build);
    }

    public Build getBuild() {
        return this.getModelBuild();
    }

    public List getResources() {
        return this.getBuild().getResources();
    }

    public List getTestResources() {
        return this.getBuild().getTestResources();
    }

    public void addResource(Resource resource) {
        this.getBuild().addResource(resource);
    }

    public void addTestResource(Resource testResource) {
        this.getBuild().addTestResource(testResource);
    }

    public void setReporting(Reporting reporting) {
        this.getModel().setReporting(reporting);
    }

    public Reporting getReporting() {
        return this.getModel().getReporting();
    }

    public void setLicenses(List licenses) {
        this.getModel().setLicenses(licenses);
    }

    public List getLicenses() {
        return this.getModel().getLicenses();
    }

    public void addLicense(License license) {
        this.getModel().addLicense(license);
    }

    public void setArtifacts(Set artifacts) {
        this.artifacts = artifacts;
        this.artifactMap = null;
    }

    public Set getArtifacts() {
        return this.artifacts == null ? Collections.EMPTY_SET : this.artifacts;
    }

    public Map getArtifactMap() {
        if (this.artifactMap == null) {
            this.artifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)this.getArtifacts());
        }
        return this.artifactMap;
    }

    public Set getPluginArtifacts() {
        if (this.pluginArtifacts != null) {
            return this.pluginArtifacts;
        }
        this.pluginArtifacts = new HashSet<Artifact>();
        if (this.artifactFactory != null) {
            List plugins = this.getBuildPlugins();
            for (Plugin p : plugins) {
                Artifact artifact;
                String version = StringUtils.isEmpty((String)p.getVersion()) ? "RELEASE" : p.getVersion();
                try {
                    artifact = this.artifactFactory.createPluginArtifact(p.getGroupId(), p.getArtifactId(), VersionRange.createFromVersionSpec((String)version));
                }
                catch (InvalidVersionSpecificationException e) {
                    return this.pluginArtifacts;
                }
                if (artifact == null) continue;
                this.pluginArtifacts.add(artifact);
            }
        }
        this.pluginArtifactMap = null;
        return this.pluginArtifacts;
    }

    public Map getPluginArtifactMap() {
        this.pluginArtifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)this.getPluginArtifacts());
        return this.pluginArtifactMap;
    }

    public void setReportArtifacts(Set reportArtifacts) {
        this.reportArtifacts = reportArtifacts;
        this.reportArtifactMap = null;
    }

    public Set getReportArtifacts() {
        if (this.reportArtifacts != null) {
            return this.reportArtifacts;
        }
        this.reportArtifacts = new HashSet();
        List reports = this.getReportPlugins();
        if (reports != null) {
            for (ReportPlugin p : reports) {
                String version = StringUtils.isEmpty((String)p.getVersion()) ? "RELEASE" : p.getVersion();
                Artifact artifact = null;
                try {
                    artifact = this.artifactFactory.createPluginArtifact(p.getGroupId(), p.getArtifactId(), VersionRange.createFromVersionSpec((String)version));
                }
                catch (InvalidVersionSpecificationException e) {
                    // empty catch block
                }
                if (artifact == null) continue;
                this.reportArtifacts.add(artifact);
            }
        }
        this.reportArtifactMap = null;
        return this.reportArtifacts;
    }

    public Map getReportArtifactMap() {
        if (this.reportArtifactMap == null) {
            this.reportArtifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)this.getReportArtifacts());
        }
        return this.reportArtifactMap;
    }

    public void setExtensionArtifacts(Set extensionArtifacts) {
        this.extensionArtifacts = extensionArtifacts;
        this.extensionArtifactMap = null;
    }

    public Set getExtensionArtifacts() {
        if (this.extensionArtifacts != null) {
            return this.extensionArtifacts;
        }
        this.extensionArtifacts = new HashSet();
        List extensions = this.getBuildExtensions();
        if (extensions != null) {
            for (Extension ext : extensions) {
                String version = StringUtils.isEmpty((String)ext.getVersion()) ? "RELEASE" : ext.getVersion();
                Artifact artifact = null;
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)version);
                    artifact = this.artifactFactory.createExtensionArtifact(ext.getGroupId(), ext.getArtifactId(), versionRange);
                }
                catch (InvalidVersionSpecificationException e) {
                    // empty catch block
                }
                if (artifact == null) continue;
                this.extensionArtifacts.add(artifact);
            }
        }
        this.extensionArtifactMap = null;
        return this.extensionArtifacts;
    }

    public Map getExtensionArtifactMap() {
        if (this.extensionArtifactMap == null) {
            this.extensionArtifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)this.getExtensionArtifacts());
        }
        return this.extensionArtifactMap;
    }

    public void setParentArtifact(Artifact parentArtifact) {
        this.parentArtifact = parentArtifact;
    }

    public Artifact getParentArtifact() {
        if (this.parentArtifact == null && this.model.getParent() != null) {
            Parent p = this.model.getParent();
            this.parentArtifact = this.artifactFactory.createParentArtifact(p.getGroupId(), p.getArtifactId(), p.getVersion());
        }
        return this.parentArtifact;
    }

    public List getRepositories() {
        return this.getModel().getRepositories();
    }

    public List getReportPlugins() {
        if (this.getModel().getReporting() == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getModel().getReporting().getPlugins();
    }

    public List getBuildPlugins() {
        if (this.getModel().getBuild() == null) {
            return Collections.EMPTY_LIST;
        }
        return this.getModel().getBuild().getPlugins();
    }

    public List getModules() {
        return this.getModel().getModules();
    }

    public PluginManagement getPluginManagement() {
        PluginManagement pluginMgmt = null;
        Build build = this.getModel().getBuild();
        if (build != null) {
            pluginMgmt = build.getPluginManagement();
        }
        return pluginMgmt;
    }

    private Build getModelBuild() {
        Build build = this.getModel().getBuild();
        if (build == null) {
            build = new Build();
            this.getModel().setBuild(build);
        }
        return build;
    }

    public void addPlugin(Plugin plugin) {
        Build build = this.getModelBuild();
        if (!build.getPluginsAsMap().containsKey(plugin.getKey())) {
            this.injectPluginManagementInfo(plugin);
            build.addPlugin(plugin);
            build.flushPluginMap();
        }
    }

    public void injectPluginManagementInfo(Plugin plugin) {
        PluginManagement pm = this.getModelBuild().getPluginManagement();
        if (pm != null) {
            Map pmByKey = pm.getPluginsAsMap();
            String pluginKey = plugin.getKey();
            if (pmByKey != null && pmByKey.containsKey(pluginKey)) {
                Plugin pmPlugin = (Plugin)pmByKey.get(pluginKey);
                ModelUtils.mergePluginDefinitions((Plugin)plugin, (Plugin)pmPlugin, (boolean)false);
            }
        }
    }

    public List getCollectedProjects() {
        return this.collectedProjects;
    }

    public void setCollectedProjects(List collectedProjects) {
        this.collectedProjects = collectedProjects;
    }

    public void setPluginArtifactRepositories(List pluginArtifactRepositories) {
        this.pluginArtifactRepositories = pluginArtifactRepositories;
    }

    public List getPluginArtifactRepositories() {
        return this.getRemoteArtifactRepositories();
    }

    public ArtifactRepository getDistributionManagementArtifactRepository() {
        return this.getArtifact().isSnapshot() && this.getSnapshotArtifactRepository() != null ? this.getSnapshotArtifactRepository() : this.getReleaseArtifactRepository();
    }

    public List getPluginRepositories() {
        return this.getModel().getRepositories();
    }

    public void setActiveProfiles(List activeProfiles) {
        this.activeProfiles.addAll(activeProfiles);
    }

    public List getActiveProfiles() {
        return this.activeProfiles;
    }

    public void addAttachedArtifact(Artifact artifact) throws DuplicateArtifactAttachmentException {
        List<Artifact> attachedArtifacts = this.getAttachedArtifacts();
        if (attachedArtifacts.contains(artifact)) {
            System.out.println("[Warning] Duplicate artifact: " + artifact.toString());
            return;
        }
        this.getAttachedArtifacts().add(artifact);
    }

    public List<Artifact> getAttachedArtifacts() {
        if (this.attachedArtifacts == null) {
            this.attachedArtifacts = new ArrayList<Artifact>();
        }
        return this.attachedArtifacts;
    }

    public Xpp3Dom getReportConfiguration(String pluginGroupId, String pluginArtifactId, String reportSetId) {
        Xpp3Dom dom = null;
        if (this.getReportPlugins() != null) {
            for (ReportPlugin plugin : this.getReportPlugins()) {
                Xpp3Dom executionConfiguration;
                ReportSet reportSet;
                if (!pluginGroupId.equals(plugin.getGroupId()) || !pluginArtifactId.equals(plugin.getArtifactId())) continue;
                dom = (Xpp3Dom)plugin.getConfiguration();
                if (reportSetId == null || (reportSet = (ReportSet)plugin.getReportSetsAsMap().get(reportSetId)) == null || (executionConfiguration = (Xpp3Dom)reportSet.getConfiguration()) == null) break;
                Xpp3Dom newDom = new Xpp3Dom(executionConfiguration);
                dom = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)newDom, (Xpp3Dom)dom);
                break;
            }
        }
        if (dom != null) {
            dom = new Xpp3Dom(dom);
        }
        return dom;
    }

    public MavenProject getExecutionProject() {
        return this.executionProject == null ? this : this.executionProject;
    }

    public void setExecutionProject(MavenProject executionProject) {
        if (this.executionProject != null) {
            this.previousExecutionProjects.push(this.executionProject);
        }
        this.executionProject = executionProject;
    }

    public Set getDependencyArtifacts() {
        return this.dependencyArtifacts;
    }

    public void setDependencyArtifacts(Set dependencyArtifacts) {
        this.dependencyArtifacts = dependencyArtifacts;
    }

    public void setReleaseArtifactRepository(ArtifactRepository releaseArtifactRepository) {
        this.releaseArtifactRepository = releaseArtifactRepository;
    }

    public void setSnapshotArtifactRepository(ArtifactRepository snapshotArtifactRepository) {
        this.snapshotArtifactRepository = snapshotArtifactRepository;
    }

    public void setOriginalModel(Model originalModel) {
        this.originalModel = originalModel;
    }

    public Model getOriginalModel() {
        return this.originalModel;
    }

    public void setManagedVersionMap(Map map) {
        this.managedVersionMap = map;
    }

    public Map getManagedVersionMap() {
        if (this.managedVersionMap != null) {
            return this.managedVersionMap;
        }
        Map map = null;
        if (this.artifactFactory != null) {
            List deps;
            DependencyManagement dependencyManagement = this.getDependencyManagement();
            if (dependencyManagement != null && (deps = dependencyManagement.getDependencies()) != null && deps.size() > 0) {
                map = new ManagedVersionMap(map);
                for (Dependency d : dependencyManagement.getDependencies()) {
                    try {
                        VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                        Artifact artifact = this.artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
                        if (Artifact.SCOPE_SYSTEM.equals(d.getScope()) && d.getSystemPath() != null) {
                            artifact.setFile(new File(d.getSystemPath()));
                        }
                        if (null != d.getExclusions() && !d.getExclusions().isEmpty()) {
                            ArrayList<String> exclusions = new ArrayList<String>();
                            for (Exclusion e : d.getExclusions()) {
                                exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
                            }
                            ExcludesArtifactFilter eaf = new ExcludesArtifactFilter(exclusions);
                            artifact.setDependencyFilter((ArtifactFilter)eaf);
                        } else {
                            artifact.setDependencyFilter(null);
                        }
                        map.put(d.getManagementKey(), artifact);
                    }
                    catch (InvalidVersionSpecificationException e) {
                        map = Collections.EMPTY_MAP;
                    }
                }
            } else if (map == null) {
                map = Collections.EMPTY_MAP;
            }
        }
        this.managedVersionMap = map;
        return this.managedVersionMap;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MavenProject)) {
            return false;
        }
        MavenProject otherProject = (MavenProject)other;
        return this.getId().equals(otherProject.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public List getBuildExtensions() {
        Build build = this.getBuild();
        if (build == null || build.getExtensions() == null) {
            return Collections.EMPTY_LIST;
        }
        return build.getExtensions();
    }

    public Set createArtifacts(ArtifactFactory artifactFactory, String inheritedScope, ArtifactFilter dependencyFilter) throws InvalidDependencyVersionException {
        return MavenMetadataSource.createArtifacts(artifactFactory, this.getDependencies(), inheritedScope, dependencyFilter, this);
    }

    public void addProjectReference(MavenProject project) {
        this.projectReferences.put(MavenProject.getProjectReferenceId(project.getGroupId(), project.getArtifactId(), project.getVersion()), project);
    }

    @Deprecated
    public void attachArtifact(String type, String classifier, File file) {
    }

    public Properties getProperties() {
        return this.getModel().getProperties();
    }

    public List getFilters() {
        return this.getBuild().getFilters();
    }

    public Map getProjectReferences() {
        return this.projectReferences;
    }

    public boolean isExecutionRoot() {
        return this.executionRoot;
    }

    public void setExecutionRoot(boolean executionRoot) {
        this.executionRoot = executionRoot;
    }

    public String getDefaultGoal() {
        return this.getBuild() != null ? this.getBuild().getDefaultGoal() : null;
    }

    public Artifact replaceWithActiveArtifact(Artifact pluginArtifact) {
        if (this.getProjectReferences() != null && !this.getProjectReferences().isEmpty()) {
            String refId = MavenProject.getProjectReferenceId(pluginArtifact.getGroupId(), pluginArtifact.getArtifactId(), pluginArtifact.getVersion());
            MavenProject ref = (MavenProject)this.getProjectReferences().get(refId);
            if (ref != null && ref.getArtifact() != null) {
                if (ref.getArtifact().getDependencyConflictId().equals(pluginArtifact.getDependencyConflictId()) && ref.getArtifact().getFile() != null && ref.getArtifact().getFile().exists()) {
                    pluginArtifact = new ActiveProjectArtifact(ref, pluginArtifact);
                    return pluginArtifact;
                }
                for (Artifact attached : ref.getAttachedArtifacts()) {
                    if (!attached.getDependencyConflictId().equals(pluginArtifact.getDependencyConflictId())) continue;
                    Artifact resultArtifact = ArtifactUtils.copyArtifact((Artifact)attached);
                    resultArtifact.setScope(pluginArtifact.getScope());
                    return resultArtifact;
                }
                if (ref.getArtifactId().equals(pluginArtifact.getArtifactId()) && ref.getGroupId().equals(pluginArtifact.getGroupId()) && ref.getArtifact().getType().equals("ejb") && pluginArtifact.getType().equals("ejb-client") && ref.getArtifact().getFile() != null && ref.getArtifact().getFile().exists()) {
                    pluginArtifact = new ActiveProjectArtifact(ref, pluginArtifact);
                    return pluginArtifact;
                }
            }
        }
        return pluginArtifact;
    }

    public void clearExecutionProject() {
        this.executionProject = !this.previousExecutionProjects.isEmpty() ? (MavenProject)this.previousExecutionProjects.pop() : null;
    }

    public Plugin getPlugin(String pluginKey) {
        return (Plugin)this.getBuild().getPluginsAsMap().get(pluginKey);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(30);
        sb.append("MavenProject: ");
        sb.append(this.getGroupId());
        sb.append(":");
        sb.append(this.getArtifactId());
        sb.append(":");
        sb.append(this.getVersion());
        sb.append(" @ ");
        try {
            sb.append(this.getFile().getPath());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return sb.toString();
    }

    public void writeModel(Writer writer) throws IOException {
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        pomWriter.write(writer, this.getModel());
    }

    public Object clone() throws CloneNotSupportedException {
        MavenProject clone = (MavenProject)super.clone();
        clone.deepCopy(this);
        return clone;
    }

    protected void setModel(Model model) {
        this.model = model;
    }

    protected void setAttachedArtifacts(List attachedArtifacts) {
        this.attachedArtifacts = attachedArtifacts;
    }

    protected void setCompileSourceRoots(List compileSourceRoots) {
        this.compileSourceRoots = compileSourceRoots;
    }

    protected void setTestCompileSourceRoots(List testCompileSourceRoots) {
        this.testCompileSourceRoots = testCompileSourceRoots;
    }

    protected void setScriptSourceRoots(List scriptSourceRoots) {
        this.scriptSourceRoots = scriptSourceRoots;
    }

    protected ArtifactRepository getReleaseArtifactRepository() {
        return this.releaseArtifactRepository;
    }

    protected ArtifactRepository getSnapshotArtifactRepository() {
        return this.snapshotArtifactRepository;
    }

    private void deepCopy(MavenProject project) {
        this.setFile(project.getFile());
        if (project.getDependencyArtifacts() != null) {
            this.setDependencyArtifacts(Collections.unmodifiableSet(project.getDependencyArtifacts()));
        }
        if (project.getArtifacts() != null) {
            this.setArtifacts(Collections.unmodifiableSet(project.getArtifacts()));
        }
        if (project.getParentFile() != null) {
            this.parentFile = new File(project.getParentFile().getAbsolutePath());
        }
        if (project.getReportArtifacts() != null) {
            this.setReportArtifacts(Collections.unmodifiableSet(project.getReportArtifacts()));
        }
        if (project.getExtensionArtifacts() != null) {
            this.setExtensionArtifacts(Collections.unmodifiableSet(project.getExtensionArtifacts()));
        }
        this.setParentArtifact(project.getParentArtifact());
        if (project.getRemoteArtifactRepositories() != null) {
            this.setRemoteArtifactRepositories(Collections.unmodifiableList(project.getRemoteArtifactRepositories()));
        }
        if (project.getPluginArtifactRepositories() != null) {
            this.setPluginArtifactRepositories(Collections.unmodifiableList(project.getPluginArtifactRepositories()));
        }
        if (project.getCollectedProjects() != null) {
            this.setCollectedProjects(Collections.unmodifiableList(project.getCollectedProjects()));
        }
        if (project.getActiveProfiles() != null) {
            this.setActiveProfiles(Collections.unmodifiableList(project.getActiveProfiles()));
        }
        if (project.getAttachedArtifacts() != null) {
            this.setAttachedArtifacts(new ArrayList<Artifact>(project.getAttachedArtifacts()));
        }
        if (project.getCompileSourceRoots() != null) {
            this.setCompileSourceRoots(new ArrayList(project.getCompileSourceRoots()));
        }
        if (project.getTestCompileSourceRoots() != null) {
            this.setTestCompileSourceRoots(new ArrayList(project.getTestCompileSourceRoots()));
        }
        if (project.getScriptSourceRoots() != null) {
            this.setScriptSourceRoots(new ArrayList(project.getScriptSourceRoots()));
        }
        this.setModel(project.getModel());
        if (project.getOriginalModel() != null) {
            this.setOriginalModel(project.getOriginalModel());
        }
        this.setExecutionRoot(project.isExecutionRoot());
        if (project.getArtifact() != null) {
            this.setArtifact(ArtifactUtils.copyArtifact((Artifact)project.getArtifact()));
        }
        if (project.getManagedVersionMap() != null) {
            this.setManagedVersionMap((Map)new ManagedVersionMap(project.getManagedVersionMap()));
        }
        if (project.getReleaseArtifactRepository() != null) {
            this.setReleaseArtifactRepository(project.getReleaseArtifactRepository());
        }
        if (project.getSnapshotArtifactRepository() != null) {
            this.setSnapshotArtifactRepository(project.getSnapshotArtifactRepository());
        }
    }

    private void addArtifactPath(Artifact a, List list) throws DependencyResolutionRequiredException {
        String refId = MavenProject.getProjectReferenceId(a.getGroupId(), a.getArtifactId(), a.getVersion());
        MavenProject project = (MavenProject)this.projectReferences.get(refId);
        boolean projectDirFound = false;
        if (project != null) {
            if (a.getType().equals("test-jar")) {
                File testOutputDir = new File(project.getBuild().getTestOutputDirectory());
                if (testOutputDir.exists()) {
                    list.add(testOutputDir.getAbsolutePath());
                    projectDirFound = true;
                }
            } else {
                list.add(project.getBuild().getOutputDirectory());
                projectDirFound = true;
            }
        }
        if (!projectDirFound) {
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
    }

    private static String getProjectReferenceId(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }
}

