/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;

public final class SettingsUtils {
    private SettingsUtils() {
    }

    public static void merge(Settings dominant, Settings recessive, String recessiveSourceLevel) {
        if (dominant == null || recessive == null) {
            return;
        }
        recessive.setSourceLevel(recessiveSourceLevel);
        List dominantActiveProfiles = dominant.getActiveProfiles();
        List recessiveActiveProfiles = recessive.getActiveProfiles();
        Iterator it = recessiveActiveProfiles.iterator();
        while (it.hasNext()) {
            String profileId = (String)it.next();
            if (dominantActiveProfiles.contains(profileId)) continue;
            dominantActiveProfiles.add(profileId);
            dominant.getRuntimeInfo().setActiveProfileSourceLevel(profileId, recessiveSourceLevel);
        }
        if (StringUtils.isEmpty((String)dominant.getLocalRepository())) {
            dominant.setLocalRepository(recessive.getLocalRepository());
            dominant.getRuntimeInfo().setLocalRepositorySourceLevel(recessiveSourceLevel);
        }
        SettingsUtils.shallowMergeById(dominant.getMirrors(), recessive.getMirrors(), recessiveSourceLevel);
        SettingsUtils.shallowMergeById(dominant.getServers(), recessive.getServers(), recessiveSourceLevel);
        SettingsUtils.shallowMergeById(dominant.getProxies(), recessive.getProxies(), recessiveSourceLevel);
        SettingsUtils.shallowMergeById(dominant.getProfiles(), recessive.getProfiles(), recessiveSourceLevel);
    }

    private static void shallowMergeById(List dominant, List recessive, String recessiveSourceLevel) {
        Map dominantById = SettingsUtils.mapById(dominant);
        Iterator it = recessive.iterator();
        while (it.hasNext()) {
            IdentifiableBase identifiable = (IdentifiableBase)it.next();
            if (dominantById.containsKey(identifiable.getId())) continue;
            identifiable.setSourceLevel(recessiveSourceLevel);
            dominant.add(identifiable);
        }
    }

    private static Map mapById(List identifiables) {
        HashMap<String, IdentifiableBase> byId = new HashMap<String, IdentifiableBase>();
        Iterator it = identifiables.iterator();
        while (it.hasNext()) {
            IdentifiableBase identifiable = (IdentifiableBase)it.next();
            byId.put(identifiable.getId(), identifiable);
        }
        return byId;
    }

    public static org.apache.maven.model.Profile convertFromSettingsProfile(Profile settingsProfile) {
        List pluginRepos;
        org.apache.maven.model.Profile profile = new org.apache.maven.model.Profile();
        profile.setId(settingsProfile.getId());
        profile.setSource("settings.xml");
        Activation settingsActivation = settingsProfile.getActivation();
        if (settingsActivation != null) {
            org.apache.maven.model.Activation activation = new org.apache.maven.model.Activation();
            activation.setJdk(settingsActivation.getJdk());
            ActivationProperty settingsProp = settingsActivation.getProperty();
            if (settingsProp != null) {
                org.apache.maven.model.ActivationProperty prop = new org.apache.maven.model.ActivationProperty();
                prop.setName(settingsProp.getName());
                prop.setValue(settingsProp.getValue());
                activation.setProperty(prop);
            }
        }
        profile.setProperties(settingsProfile.getProperties());
        List repos = settingsProfile.getRepositories();
        if (repos != null) {
            Iterator it = repos.iterator();
            while (it.hasNext()) {
                profile.addRepository(SettingsUtils.convertFromSettingsRepository((Repository)it.next()));
            }
        }
        if ((pluginRepos = settingsProfile.getPluginRepositories()) != null) {
            Iterator it = pluginRepos.iterator();
            while (it.hasNext()) {
                profile.addPluginRepository(SettingsUtils.convertFromSettingsRepository((Repository)it.next()));
            }
        }
        return profile;
    }

    private static org.apache.maven.model.Repository convertFromSettingsRepository(Repository settingsRepo) {
        org.apache.maven.model.Repository repo = new org.apache.maven.model.Repository();
        repo.setId(settingsRepo.getId());
        repo.setLayout(settingsRepo.getLayout());
        repo.setName(settingsRepo.getName());
        repo.setSnapshotPolicy(settingsRepo.getSnapshotPolicy());
        repo.setChecksumPolicy(settingsRepo.getChecksumPolicy());
        repo.setUrl(settingsRepo.getUrl());
        return repo;
    }
}

