/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.TrackableBase;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class SettingsXpp3Writer {
    private XmlSerializer serializer;
    private String NAMESPACE;

    public void write(Writer writer, Settings settings) throws IOException {
        this.serializer = new MXSerializer();
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        this.serializer.setOutput(writer);
        this.writeSettings(settings, "settings", this.serializer);
    }

    private void writeActivation(Activation activation, String tagName, XmlSerializer serializer) throws IOException {
        if (activation != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activation.getJdk() != null) {
                serializer.startTag(this.NAMESPACE, "jdk").text(activation.getJdk()).endTag(this.NAMESPACE, "jdk");
            }
            if (activation.getProperty() != null) {
                this.writeActivationProperty(activation.getProperty(), "property", serializer);
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeActivationProperty(ActivationProperty activationProperty, String tagName, XmlSerializer serializer) throws IOException {
        if (activationProperty != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (activationProperty.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(activationProperty.getName()).endTag(this.NAMESPACE, "name");
            }
            if (activationProperty.getValue() != null) {
                serializer.startTag(this.NAMESPACE, "value").text(activationProperty.getValue()).endTag(this.NAMESPACE, "value");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeIdentifiableBase(IdentifiableBase identifiableBase, String tagName, XmlSerializer serializer) throws IOException {
        if (identifiableBase != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (identifiableBase.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(identifiableBase.getId()).endTag(this.NAMESPACE, "id");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeMirror(Mirror mirror, String tagName, XmlSerializer serializer) throws IOException {
        if (mirror != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (mirror.getMirrorOf() != null) {
                serializer.startTag(this.NAMESPACE, "mirrorOf").text(mirror.getMirrorOf()).endTag(this.NAMESPACE, "mirrorOf");
            }
            if (mirror.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(mirror.getName()).endTag(this.NAMESPACE, "name");
            }
            if (mirror.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(mirror.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (mirror.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(mirror.getId()).endTag(this.NAMESPACE, "id");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeProfile(Profile profile, String tagName, XmlSerializer serializer) throws IOException {
        if (profile != null) {
            Repository repository;
            Iterator<Object> iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (profile.getActivation() != null) {
                this.writeActivation(profile.getActivation(), "activation", serializer);
            }
            if (profile.getLocalRepository() != null) {
                serializer.startTag(this.NAMESPACE, "localRepository").text(profile.getLocalRepository()).endTag(this.NAMESPACE, "localRepository");
            }
            if (profile.getProperties() != null && ((Hashtable)profile.getProperties()).size() > 0) {
                serializer.startTag(this.NAMESPACE, "properties");
                iter = ((Hashtable)profile.getProperties()).keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = (String)((Hashtable)profile.getProperties()).get(key);
                    serializer.startTag(this.NAMESPACE, "" + key + "").text(value).endTag(this.NAMESPACE, "" + key + "");
                }
                serializer.endTag(this.NAMESPACE, "properties");
            }
            if (profile.getRepositories() != null && profile.getRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "repositories");
                iter = profile.getRepositories().iterator();
                while (iter.hasNext()) {
                    repository = (Repository)iter.next();
                    this.writeRepository(repository, "repository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "repositories");
            }
            if (profile.getPluginRepositories() != null && profile.getPluginRepositories().size() > 0) {
                serializer.startTag(this.NAMESPACE, "pluginRepositories");
                iter = profile.getPluginRepositories().iterator();
                while (iter.hasNext()) {
                    repository = (Repository)iter.next();
                    this.writeRepository(repository, "pluginRepository", serializer);
                }
                serializer.endTag(this.NAMESPACE, "pluginRepositories");
            }
            if (profile.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(profile.getId()).endTag(this.NAMESPACE, "id");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeProxy(Proxy proxy, String tagName, XmlSerializer serializer) throws IOException {
        if (proxy != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (proxy.isActive()) {
                serializer.startTag(this.NAMESPACE, "active").text(String.valueOf(proxy.isActive())).endTag(this.NAMESPACE, "active");
            }
            if (proxy.getProtocol() != null && !proxy.getProtocol().equals("http")) {
                serializer.startTag(this.NAMESPACE, "protocol").text(proxy.getProtocol()).endTag(this.NAMESPACE, "protocol");
            }
            if (proxy.getUsername() != null) {
                serializer.startTag(this.NAMESPACE, "username").text(proxy.getUsername()).endTag(this.NAMESPACE, "username");
            }
            if (proxy.getPassword() != null) {
                serializer.startTag(this.NAMESPACE, "password").text(proxy.getPassword()).endTag(this.NAMESPACE, "password");
            }
            if (proxy.getPort() != 0) {
                serializer.startTag(this.NAMESPACE, "port").text(String.valueOf(proxy.getPort())).endTag(this.NAMESPACE, "port");
            }
            if (proxy.getHost() != null) {
                serializer.startTag(this.NAMESPACE, "host").text(proxy.getHost()).endTag(this.NAMESPACE, "host");
            }
            if (proxy.getNonProxyHosts() != null) {
                serializer.startTag(this.NAMESPACE, "nonProxyHosts").text(proxy.getNonProxyHosts()).endTag(this.NAMESPACE, "nonProxyHosts");
            }
            if (proxy.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(proxy.getId()).endTag(this.NAMESPACE, "id");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer) throws IOException {
        if (repository != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (repository.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(repository.getId()).endTag(this.NAMESPACE, "id");
            }
            if (repository.getName() != null) {
                serializer.startTag(this.NAMESPACE, "name").text(repository.getName()).endTag(this.NAMESPACE, "name");
            }
            if (repository.getUrl() != null) {
                serializer.startTag(this.NAMESPACE, "url").text(repository.getUrl()).endTag(this.NAMESPACE, "url");
            }
            if (repository.getSnapshotPolicy() != null && !repository.getSnapshotPolicy().equals("daily")) {
                serializer.startTag(this.NAMESPACE, "snapshotPolicy").text(repository.getSnapshotPolicy()).endTag(this.NAMESPACE, "snapshotPolicy");
            }
            if (repository.getLayout() != null && !repository.getLayout().equals("default")) {
                serializer.startTag(this.NAMESPACE, "layout").text(repository.getLayout()).endTag(this.NAMESPACE, "layout");
            }
            if (repository.getChecksumPolicy() != null && !repository.getChecksumPolicy().equals("warn")) {
                serializer.startTag(this.NAMESPACE, "checksumPolicy").text(repository.getChecksumPolicy()).endTag(this.NAMESPACE, "checksumPolicy");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeServer(Server server, String tagName, XmlSerializer serializer) throws IOException {
        if (server != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            if (server.getUsername() != null) {
                serializer.startTag(this.NAMESPACE, "username").text(server.getUsername()).endTag(this.NAMESPACE, "username");
            }
            if (server.getPassword() != null) {
                serializer.startTag(this.NAMESPACE, "password").text(server.getPassword()).endTag(this.NAMESPACE, "password");
            }
            if (server.getPrivateKey() != null) {
                serializer.startTag(this.NAMESPACE, "privateKey").text(server.getPrivateKey()).endTag(this.NAMESPACE, "privateKey");
            }
            if (server.getPassphrase() != null) {
                serializer.startTag(this.NAMESPACE, "passphrase").text(server.getPassphrase()).endTag(this.NAMESPACE, "passphrase");
            }
            if (server.getId() != null) {
                serializer.startTag(this.NAMESPACE, "id").text(server.getId()).endTag(this.NAMESPACE, "id");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeSettings(Settings settings, String tagName, XmlSerializer serializer) throws IOException {
        if (settings != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (settings.getLocalRepository() != null) {
                serializer.startTag(this.NAMESPACE, "localRepository").text(settings.getLocalRepository()).endTag(this.NAMESPACE, "localRepository");
            }
            if (!settings.isInteractiveMode()) {
                serializer.startTag(this.NAMESPACE, "interactiveMode").text(String.valueOf(settings.isInteractiveMode())).endTag(this.NAMESPACE, "interactiveMode");
            }
            if (settings.isOffline()) {
                serializer.startTag(this.NAMESPACE, "offline").text(String.valueOf(settings.isOffline())).endTag(this.NAMESPACE, "offline");
            }
            if (settings.getProxies() != null && settings.getProxies().size() > 0) {
                serializer.startTag(this.NAMESPACE, "proxies");
                iter = settings.getProxies().iterator();
                while (iter.hasNext()) {
                    Proxy proxy = (Proxy)iter.next();
                    this.writeProxy(proxy, "proxy", serializer);
                }
                serializer.endTag(this.NAMESPACE, "proxies");
            }
            if (settings.getServers() != null && settings.getServers().size() > 0) {
                serializer.startTag(this.NAMESPACE, "servers");
                iter = settings.getServers().iterator();
                while (iter.hasNext()) {
                    Server server = (Server)iter.next();
                    this.writeServer(server, "server", serializer);
                }
                serializer.endTag(this.NAMESPACE, "servers");
            }
            if (settings.getMirrors() != null && settings.getMirrors().size() > 0) {
                serializer.startTag(this.NAMESPACE, "mirrors");
                iter = settings.getMirrors().iterator();
                while (iter.hasNext()) {
                    Mirror mirror = (Mirror)iter.next();
                    this.writeMirror(mirror, "mirror", serializer);
                }
                serializer.endTag(this.NAMESPACE, "mirrors");
            }
            if (settings.getProfiles() != null && settings.getProfiles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "profiles");
                iter = settings.getProfiles().iterator();
                while (iter.hasNext()) {
                    Profile profile = (Profile)iter.next();
                    this.writeProfile(profile, "profile", serializer);
                }
                serializer.endTag(this.NAMESPACE, "profiles");
            }
            if (settings.getActiveProfiles() != null && settings.getActiveProfiles().size() > 0) {
                serializer.startTag(this.NAMESPACE, "activeProfiles");
                iter = settings.getActiveProfiles().iterator();
                while (iter.hasNext()) {
                    String activeProfile = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "activeProfile").text(activeProfile).endTag(this.NAMESPACE, "activeProfile");
                }
                serializer.endTag(this.NAMESPACE, "activeProfiles");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }

    private void writeTrackableBase(TrackableBase trackableBase, String tagName, XmlSerializer serializer) throws IOException {
        if (trackableBase != null) {
            serializer.startTag(this.NAMESPACE, tagName);
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

