/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.artifact;

import java.util.List;
import org.apache.maven.mercury.artifact.Artifact;
import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.mercury.artifact.ArtifactScopeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactMetadata
extends ArtifactBasicMetadata {
    private boolean release;
    protected String why;
    protected List<ArtifactBasicMetadata> dependencies;
    protected boolean resolved = false;
    protected boolean artifactExists = false;
    protected String artifactUri;
    private String error;

    public ArtifactMetadata() {
    }

    public ArtifactMetadata(String name) {
        if (name == null) {
            return;
        }
        String[] tokens = name.split(":");
        if (tokens == null || tokens.length < 1) {
            return;
        }
        int count = tokens.length;
        this.groupId = ArtifactMetadata.nullify(tokens[0]);
        if (count > 1) {
            this.artifactId = ArtifactMetadata.nullify(tokens[1]);
        }
        if (count > 2) {
            this.version = ArtifactMetadata.nullify(tokens[2]);
        }
        if (count > 3) {
            this.classifier = ArtifactMetadata.nullify(tokens[3]);
        }
        if (count > 4) {
            this.type = ArtifactMetadata.nullify(tokens[4]);
        }
    }

    private static final String nullify(String s) {
        if (s == null || s.length() < 1) {
            return null;
        }
        return s;
    }

    public ArtifactMetadata(String groupId, String name, String version) {
        this(groupId, name, version, null);
    }

    public ArtifactMetadata(String groupId, String name, String version, String type) {
        this(groupId, name, version, type, null);
    }

    public ArtifactMetadata(String groupId, String name, String version, String type, ArtifactScopeEnum artifactScope) {
        this(groupId, name, version, type, artifactScope, null);
    }

    public ArtifactMetadata(String groupId, String name, String version, String type, ArtifactScopeEnum artifactScope, String classifier) {
        this(groupId, name, version, type, artifactScope, classifier, null);
    }

    public ArtifactMetadata(String groupId, String name, String version, String type, ArtifactScopeEnum artifactScope, String classifier, String artifactUri) {
        this(groupId, name, version, type, artifactScope, classifier, artifactUri, null, true, null);
    }

    public ArtifactMetadata(String groupId, String name, String version, String type, ArtifactScopeEnum artifactScope, String classifier, String artifactUri, String why, boolean resolved, String error) {
        this.groupId = groupId;
        this.artifactId = name;
        this.version = version;
        this.type = type;
        this.artifactScope = artifactScope;
        this.classifier = classifier;
        this.artifactUri = artifactUri;
        this.why = why;
        this.resolved = resolved;
        this.error = error;
    }

    public ArtifactMetadata(ArtifactBasicMetadata bmd) {
        this(bmd.getGroupId(), bmd.getArtifactId(), bmd.getVersion(), bmd.getType(), null, bmd.getClassifier());
    }

    public ArtifactMetadata(String groupId, String name, String version, String type, String scopeString, String classifier, String artifactUri, String why, boolean resolved, String error) {
        this(groupId, name, version, type, scopeString == null ? ArtifactScopeEnum.DEFAULT_SCOPE : ArtifactScopeEnum.valueOf(scopeString), classifier, artifactUri, why, resolved, error);
    }

    public ArtifactMetadata(Artifact af) {
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public boolean isArtifactExists() {
        return this.artifactExists;
    }

    public void setArtifactExists(boolean artifactExists) {
        this.artifactExists = artifactExists;
    }

    public List<ArtifactBasicMetadata> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<ArtifactBasicMetadata> dependencies) {
        this.dependencies = dependencies;
    }

    public String getArtifactUri() {
        return this.artifactUri;
    }

    public void setArtifactUri(String artifactUri) {
        this.artifactUri = artifactUri;
    }

    public String getWhy() {
        return this.why;
    }

    public void setWhy(String why) {
        this.why = why;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean isError() {
        return this.error == null;
    }

    public void setRelease(boolean release) {
        this.release = release;
    }

    public boolean isRelease() {
        return this.release;
    }
}

