/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.artifact.version;

import org.apache.maven.mercury.artifact.Quality;
import org.apache.maven.mercury.artifact.QualityEnum;
import org.apache.maven.mercury.artifact.QualityRange;
import org.apache.maven.mercury.artifact.version.AttributeQuery;
import org.apache.maven.mercury.artifact.version.DefaultArtifactVersion;
import org.apache.maven.mercury.artifact.version.VersionException;
import org.apache.maven.mercury.artifact.version.VersionRange;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

class MavenVersionRange
implements VersionRange {
    public static final String SYSTEM_PARAMETER_OSGI_VERSION = "maven.mercury.osgi.version";
    public static final String SYSTEM_PARAMETER_OSGI_VERSION_DEFAULT = "false";
    private boolean _osgiVersion = Boolean.parseBoolean(System.getProperty("maven.mercury.osgi.version", "false"));
    private static final DefaultArtifactVersion ZERO_VERSION = new DefaultArtifactVersion("0.0.0");
    private static final Language _lang = new DefaultLanguage(MavenVersionRange.class);
    QualityRange _toQualityRange = QualityRange.ALL;
    DefaultArtifactVersion _fromVersion = ZERO_VERSION;
    boolean _fromInclusive = true;
    DefaultArtifactVersion _toVersion;
    boolean _toInclusive = false;
    boolean _singleton = false;

    protected MavenVersionRange(String range, QualityRange qRange) throws VersionException {
        this(range);
        this.setToQualityRange(qRange);
    }

    protected MavenVersionRange(String rangeIn) throws VersionException {
        String range = AttributeQuery.stripExpression(rangeIn);
        if (range == null || range.length() < 1) {
            return;
        }
        if (range.indexOf(44) > 0) {
            String sToT;
            String sTo;
            String sFromT;
            if (range.startsWith("[")) {
                this._fromInclusive = true;
            } else if (range.startsWith("(")) {
                this._fromInclusive = false;
            } else {
                throw new VersionException(_lang.getMessage("invalid.maven.version.range", new String[]{range}));
            }
            if (range.endsWith("]")) {
                this._toInclusive = true;
            } else if (range.endsWith(")")) {
                this._toInclusive = false;
            } else {
                throw new VersionException(_lang.getMessage("invalid.maven.version.range", new String[]{range}));
            }
            int ind = range.indexOf(44);
            String sFrom = range.substring(1, ind);
            if (sFrom != null && sFrom.length() > 0 && (sFromT = sFrom.trim()) != null && sFromT.length() > 0) {
                this.checkForValidCharacters(sFromT);
                Quality vq = new Quality(sFromT);
                if (vq.getQuality().equals((Object)QualityEnum.snapshot) || vq.getQuality().equals((Object)QualityEnum.unknown)) {
                    throw new VersionException(_lang.getMessage("bad.version.sn", new String[]{sFromT}));
                }
                this._fromVersion = new DefaultArtifactVersion(sFromT);
            }
            if ((sTo = range.substring(ind + 1, range.length() - 1)) != null && sTo.length() > 0 && (sToT = sTo.trim()) != null && sToT.length() > 0) {
                this.checkForValidCharacters(sToT);
                this._toVersion = new DefaultArtifactVersion(sToT);
            }
            if (this._fromVersion == null && this._fromInclusive) {
                throw new VersionException(_lang.getMessage("invalid.maven.version.range.bad.from", new String[]{range}));
            }
            if (this._toVersion == null && this._toInclusive) {
                throw new VersionException(_lang.getMessage("invalid.maven.version.range.bad.to", new String[]{range}));
            }
        } else {
            this.checkForValidCharacters(range);
            this._fromVersion = new DefaultArtifactVersion(range);
            this._singleton = true;
            if (!this._osgiVersion) {
                this._toVersion = this._fromVersion;
                this._fromInclusive = true;
                this._toInclusive = true;
            }
        }
    }

    protected void setToQualityRange(QualityRange qRange) {
        this._toQualityRange = qRange;
    }

    private void checkForValidCharacters(String v) throws VersionException {
        if (v == null || v.length() < 1) {
            throw new VersionException("empty version");
        }
        int len = v.length();
        for (int i = 0; i < len; ++i) {
            char c = v.charAt(0);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-' || c == '_') continue;
            throw new VersionException(_lang.getMessage("invalid.character", new String[]{"" + c, v}));
        }
    }

    public boolean includes(String version) {
        DefaultArtifactVersion ver = new DefaultArtifactVersion(version);
        int cmp1 = ver.compareTo(this._fromVersion);
        if (cmp1 < 0) {
            return false;
        }
        if (cmp1 == 0) {
            return this._fromInclusive;
        }
        if (this._toVersion == null) {
            return true;
        }
        int cmp2 = ver.compareTo(this._toVersion);
        if (cmp2 < 0) {
            if (ver.sameBase(this._toVersion)) {
                return this._toQualityRange.isAcceptedQuality(ver.getQuality());
            }
            return true;
        }
        if (cmp2 == 0) {
            return this._toInclusive;
        }
        return false;
    }

    public void setOption(String name, String val) {
        if (SYSTEM_PARAMETER_OSGI_VERSION.equals(name)) {
            this._osgiVersion = Boolean.parseBoolean(System.getProperty(val, SYSTEM_PARAMETER_OSGI_VERSION_DEFAULT));
        }
    }

    public boolean isSingleton() {
        return this._singleton;
    }
}

