/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.crypto.pgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.SignatureException;
import org.apache.maven.mercury.crypto.api.AbstractStreamVerifier;
import org.apache.maven.mercury.crypto.api.StreamObserverException;
import org.apache.maven.mercury.crypto.api.StreamVerifier;
import org.apache.maven.mercury.crypto.api.StreamVerifierAttributes;
import org.apache.maven.mercury.crypto.api.StreamVerifierException;
import org.apache.maven.mercury.crypto.pgp.PgpHelper;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public class PgpStreamVerifier
extends AbstractStreamVerifier
implements StreamVerifier {
    private static final Language lang = new DefaultLanguage(PgpStreamVerifier.class);
    private PGPPublicKeyRingCollection trustedPublicKeyRing;
    private PGPSignatureGenerator signatureGenerator;
    private PGPSignature signature;
    private String signatureString;
    private long length = -1L;
    private String lastModified;

    public PgpStreamVerifier(StreamVerifierAttributes attributes) {
        super(attributes);
    }

    public void init(PGPPublicKeyRingCollection trustedPublicKeyRing) {
        this.trustedPublicKeyRing = trustedPublicKeyRing;
    }

    public void init(PGPPrivateKey privateKey, int algorithm, int digestAlgorithm) throws StreamVerifierException {
        if (privateKey == null) {
            throw new IllegalArgumentException(lang.getMessage("null.private.key", new String[0]));
        }
        try {
            this.signatureGenerator = new PGPSignatureGenerator(algorithm, digestAlgorithm, "BC");
            this.signatureGenerator.initSign(0, privateKey);
            this.signatureString = null;
        }
        catch (Exception e) {
            throw new StreamVerifierException((Throwable)e);
        }
    }

    public void byteReady(int b) throws StreamObserverException {
        try {
            if (this.signature == null) {
                if (this.signatureGenerator == null) {
                    throw new StreamVerifierException(lang.getMessage("no.stream.processor", new String[0]));
                }
                this.signatureGenerator.update((byte)b);
            } else {
                this.signature.update((byte)b);
            }
        }
        catch (SignatureException e) {
            throw new StreamObserverException((Throwable)e);
        }
    }

    public void bytesReady(byte[] b, int off, int len) throws StreamObserverException {
        try {
            if (this.signature == null) {
                if (this.signatureGenerator == null) {
                    throw new StreamVerifierException(lang.getMessage("no.stream.processor", new String[0]));
                }
                this.signatureGenerator.update(b, off, len);
            } else {
                this.signature.update(b, off, len);
            }
        }
        catch (SignatureException e) {
            throw new StreamObserverException((Throwable)e);
        }
    }

    public void initSignature(String signatureString) throws StreamVerifierException {
        try {
            if (this.trustedPublicKeyRing == null) {
                throw new StreamVerifierException(lang.getMessage("no.trusted.ring", new String[0]));
            }
            if (signatureString == null || signatureString.length() < 1) {
                throw new StreamVerifierException(lang.getMessage("no.signature.string", new String[0]));
            }
            this.signature = PgpHelper.readSignature(new ByteArrayInputStream(signatureString.getBytes()));
            if (this.signature == null) {
                throw new StreamVerifierException("no.signatures.in.stream");
            }
            this.signature.initVerify(this.trustedPublicKeyRing.getPublicKey(this.signature.getKeyID()), "BC");
        }
        catch (Exception e) {
            throw new StreamVerifierException((Throwable)e);
        }
        if (this.signature == null) {
            throw new StreamVerifierException("no.signatures.in.stream");
        }
    }

    public boolean verifySignature() throws StreamVerifierException {
        if (this.signature == null) {
            throw new StreamVerifierException(lang.getMessage("null.verify.signature", new String[0]));
        }
        try {
            boolean res = this.signature.verify();
            return res;
        }
        catch (Exception e) {
            throw new StreamVerifierException((Throwable)e);
        }
    }

    public String getSignature() throws StreamVerifierException {
        if (this.signatureString != null) {
            return this.signatureString;
        }
        if (this.signatureGenerator == null) {
            throw new StreamVerifierException("bad.verify.signature.state");
        }
        BCPGOutputStream signaturePgpBytes = null;
        try {
            ByteArrayOutputStream signatureBytes = new ByteArrayOutputStream();
            ArmoredOutputStream aos = new ArmoredOutputStream((OutputStream)signatureBytes);
            signaturePgpBytes = new BCPGOutputStream((OutputStream)aos);
            this.signatureGenerator.generate().encode((OutputStream)signaturePgpBytes);
            signaturePgpBytes.finish();
            aos.flush();
            aos.close();
            this.signatureString = signatureBytes.toString();
        }
        catch (Exception e) {
            throw new StreamVerifierException((Throwable)e);
        }
        finally {
            if (signaturePgpBytes != null) {
                try {
                    signaturePgpBytes.close();
                }
                catch (Exception any) {}
            }
        }
        this.signatureGenerator = null;
        return this.signatureString;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String time) {
        this.lastModified = time;
    }
}

