/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.metadata.sat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.mercury.artifact.ArtifactMetadata;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.metadata.MetadataTreeNode;
import org.apache.maven.mercury.metadata.sat.SatException;
import org.apache.maven.mercury.metadata.sat.SatVar;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

class SatContext {
    private static final Language _lang = new DefaultLanguage(SatContext.class);
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(SatContext.class);
    Map<MetadataTreeNode, SatVar> variables;

    public SatContext(int estimatedTreeSize) {
        this.variables = new HashMap<MetadataTreeNode, SatVar>(estimatedTreeSize);
    }

    public SatVar findOrAdd(MetadataTreeNode n) throws SatException {
        if (n == null) {
            throw new SatException("cannot create a literal out of a null metadata: " + n);
        }
        SatVar var = this.variables.get(n);
        if (var != null) {
            if (_log.isDebugEnabled()) {
                _log.debug(var.toString());
            }
            return var;
        }
        var = new SatVar(n);
        this.variables.put(n, var);
        if (_log.isDebugEnabled()) {
            _log.debug(var.toString());
        }
        return var;
    }

    public ArtifactMetadata getMd(int literal) {
        for (SatVar v : this.variables.values()) {
            if (v._literal != literal) continue;
            return v.getMd();
        }
        return null;
    }

    private static final boolean isSolution(int m, int[] model) {
        for (int mm : model) {
            if (mm != m) continue;
            return true;
        }
        return false;
    }

    public MetadataTreeNode getSolutionSubtree(MetadataTreeNode tree, int[] model) {
        if (tree == null) {
            throw new IllegalArgumentException(_lang.getMessage("null.tree", new String[0]));
        }
        if (tree.getMd() == null) {
            throw new IllegalArgumentException(_lang.getMessage("null.tree.md", new String[0]));
        }
        if (model == null) {
            throw new IllegalArgumentException(_lang.getMessage("null.model", new String[0]));
        }
        if (model.length < 1) {
            throw new IllegalArgumentException(_lang.getMessage("empty.model", new String[0]));
        }
        int sz = 0;
        for (int m : model) {
            if (m <= 0) continue;
            ++sz;
        }
        if (sz == 0) {
            return null;
        }
        MetadataTreeNode res = MetadataTreeNode.deepCopy(tree);
        SatContext.cleanTree(res, model);
        return res;
    }

    private static final void cleanTree(MetadataTreeNode tn, int[] model) {
        if (!tn.hasChildren()) {
            return;
        }
        ArrayList<MetadataTreeNode> badKids = new ArrayList<MetadataTreeNode>();
        for (MetadataTreeNode kid : tn.getChildren()) {
            if (SatContext.isSolution(kid.getId(), model)) continue;
            badKids.add(kid);
        }
        tn.getChildren().removeAll(badKids);
        if (!tn.hasChildren()) {
            return;
        }
        for (MetadataTreeNode kid : tn.getChildren()) {
            SatContext.cleanTree(kid, model);
        }
    }
}

