/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.metadata;

import java.util.Iterator;
import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.repository.metadata.MetadataOperand;
import org.apache.maven.mercury.repository.metadata.MetadataOperation;
import org.apache.maven.mercury.repository.metadata.Plugin;
import org.apache.maven.mercury.repository.metadata.Snapshot;
import org.apache.maven.mercury.repository.metadata.Versioning;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

public class MergeOperation
implements MetadataOperation {
    private static final Language lang = new DefaultLanguage(MergeOperation.class);
    Metadata sourceMetadata;

    public MergeOperation(MetadataOperand data) throws MetadataException {
        this.setOperand(data);
    }

    public boolean perform(Metadata targetMetadata) throws MetadataException {
        boolean changed = false;
        if (this.sourceMetadata == null || targetMetadata == null) {
            return false;
        }
        for (Plugin plugin : this.sourceMetadata.getPlugins()) {
            boolean found = false;
            Iterator it = targetMetadata.getPlugins().iterator();
            while (it.hasNext() && !found) {
                Plugin preExisting = (Plugin)it.next();
                if (!preExisting.getPrefix().equals(plugin.getPrefix())) continue;
                found = true;
            }
            if (found) continue;
            Plugin mappedPlugin = new Plugin();
            mappedPlugin.setArtifactId(plugin.getArtifactId());
            mappedPlugin.setPrefix(plugin.getPrefix());
            mappedPlugin.setName(plugin.getName());
            targetMetadata.addPlugin(mappedPlugin);
            changed = true;
        }
        Versioning sourceVersioning = this.sourceMetadata.getVersioning();
        if (sourceVersioning != null) {
            Versioning targetVersioning = targetMetadata.getVersioning();
            if (targetVersioning == null) {
                targetVersioning = new Versioning();
                targetMetadata.setVersioning(targetVersioning);
                changed = true;
            }
            for (String version : sourceVersioning.getVersions()) {
                if (targetVersioning.getVersions().contains(version)) continue;
                changed = true;
                targetVersioning.getVersions().add(version);
            }
            if ("null".equals(sourceVersioning.getLastUpdated())) {
                sourceVersioning.setLastUpdated(null);
            }
            if ("null".equals(targetVersioning.getLastUpdated())) {
                targetVersioning.setLastUpdated(null);
            }
            if (sourceVersioning.getLastUpdated() == null || sourceVersioning.getLastUpdated().length() == 0) {
                sourceVersioning.setLastUpdated(targetVersioning.getLastUpdated());
            }
            if (targetVersioning.getLastUpdated() == null || targetVersioning.getLastUpdated().length() == 0 || sourceVersioning.getLastUpdated().compareTo(targetVersioning.getLastUpdated()) >= 0) {
                changed = true;
                targetVersioning.setLastUpdated(sourceVersioning.getLastUpdated());
                if (sourceVersioning.getRelease() != null) {
                    changed = true;
                    targetVersioning.setRelease(sourceVersioning.getRelease());
                }
                if (sourceVersioning.getLatest() != null) {
                    changed = true;
                    targetVersioning.setLatest(sourceVersioning.getLatest());
                }
                Snapshot s = targetVersioning.getSnapshot();
                Snapshot snapshot = sourceVersioning.getSnapshot();
                if (snapshot != null) {
                    if (s == null) {
                        s = new Snapshot();
                        targetVersioning.setSnapshot(s);
                        changed = true;
                    }
                    if (s.getTimestamp() == null ? snapshot.getTimestamp() != null : !s.getTimestamp().equals(snapshot.getTimestamp())) {
                        s.setTimestamp(snapshot.getTimestamp());
                        changed = true;
                    }
                    if (s.getBuildNumber() != snapshot.getBuildNumber()) {
                        s.setBuildNumber(snapshot.getBuildNumber());
                        changed = true;
                    }
                    if (s.isLocalCopy() != snapshot.isLocalCopy()) {
                        s.setLocalCopy(snapshot.isLocalCopy());
                        changed = true;
                    }
                }
            }
        }
        return changed;
    }

    public void setOperand(Object data) throws MetadataException {
        if (data == null || !(data instanceof MetadataOperand)) {
            throw new MetadataException(lang.getMessage("bad.operand", new String[]{"MetadataOperand", data == null ? "null" : data.getClass().getName()}));
        }
        this.sourceMetadata = ((MetadataOperand)data).getOperand();
    }
}

