/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.plexus;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.mercury.artifact.Artifact;
import org.apache.maven.mercury.artifact.ArtifactBasicMetadata;
import org.apache.maven.mercury.artifact.ArtifactExclusionList;
import org.apache.maven.mercury.artifact.ArtifactInclusionList;
import org.apache.maven.mercury.artifact.ArtifactMetadata;
import org.apache.maven.mercury.artifact.ArtifactQueryList;
import org.apache.maven.mercury.artifact.ArtifactScopeEnum;
import org.apache.maven.mercury.builder.api.DependencyProcessor;
import org.apache.maven.mercury.crypto.api.StreamObserverFactory;
import org.apache.maven.mercury.crypto.api.StreamVerifierAttributes;
import org.apache.maven.mercury.crypto.api.StreamVerifierException;
import org.apache.maven.mercury.crypto.api.StreamVerifierFactory;
import org.apache.maven.mercury.crypto.pgp.PgpStreamVerifierFactory;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.metadata.DependencyBuilder;
import org.apache.maven.mercury.metadata.DependencyBuilderFactory;
import org.apache.maven.mercury.metadata.MetadataTreeException;
import org.apache.maven.mercury.metadata.MetadataTreeNode;
import org.apache.maven.mercury.plexus.PlexusMercury;
import org.apache.maven.mercury.repository.api.ArtifactResults;
import org.apache.maven.mercury.repository.api.Repository;
import org.apache.maven.mercury.repository.api.RepositoryException;
import org.apache.maven.mercury.repository.api.RepositoryWriter;
import org.apache.maven.mercury.repository.local.m2.LocalRepositoryM2;
import org.apache.maven.mercury.repository.remote.m2.RemoteRepositoryM2;
import org.apache.maven.mercury.repository.virtual.VirtualRepositoryReader;
import org.apache.maven.mercury.transport.api.Credentials;
import org.apache.maven.mercury.transport.api.Server;
import org.apache.maven.mercury.util.Util;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;
import org.codehaus.plexus.logging.AbstractLogEnabled;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PlexusMercury.class)
public class DefaultPlexusMercury
extends AbstractLogEnabled
implements PlexusMercury {
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(DefaultPlexusMercury.class);
    private static final Language _lang = new DefaultLanguage(DefaultPlexusMercury.class);
    @Requirement(hint="maven")
    DependencyProcessor dependencyProcessor;
    @Requirement
    PlexusContainer plexus;

    @Override
    public DependencyProcessor findDependencyProcessor(String hint) throws RepositoryException {
        if (this.dependencyProcessor != null) {
            return this.dependencyProcessor;
        }
        if (this.plexus == null) {
            throw new RepositoryException(_lang.getMessage("no.plexus.injected", new String[0]));
        }
        DependencyProcessor dp = null;
        try {
            dp = (DependencyProcessor)this.plexus.lookup(DependencyProcessor.class, hint);
            return dp;
        }
        catch (ComponentLookupException e) {
            throw new RepositoryException(_lang.getMessage("no.dep.processor.injected", new String[]{hint, e.getMessage()}));
        }
    }

    @Override
    public DependencyProcessor findDependencyProcessor() throws RepositoryException {
        return this.findDependencyProcessor("default");
    }

    @Override
    public RemoteRepositoryM2 constructRemoteRepositoryM2(String id, URL serverUrl, String serverUser, String serverPass, URL proxyUrl, String proxyUser, String proxyPass, Set<StreamObserverFactory> readerStreamObservers, Set<StreamVerifierFactory> readerStreamVerifiers, Set<StreamObserverFactory> writerStreamObservers, Set<StreamVerifierFactory> writerStreamVerifiers) throws RepositoryException {
        Credentials cred;
        Server server = new Server(id, serverUrl);
        server.setReaderStreamObserverFactories(readerStreamObservers);
        server.setReaderStreamVerifierFactories(readerStreamVerifiers);
        server.setWriterStreamObserverFactories(writerStreamObservers);
        server.setWriterStreamVerifierFactories(writerStreamVerifiers);
        if (serverUser != null) {
            cred = new Credentials(serverUser, serverPass);
            server.setServerCredentials(cred);
        }
        if (proxyUrl != null) {
            server.setProxy(proxyUrl);
            if (proxyUser != null) {
                cred = new Credentials(proxyUser, proxyPass);
                server.setProxyCredentials(cred);
            }
        }
        RemoteRepositoryM2 repo = new RemoteRepositoryM2(id, server, this.findDependencyProcessor());
        return repo;
    }

    @Override
    public LocalRepositoryM2 constructLocalRepositoryM2(String id, File rootDir, Set<StreamObserverFactory> readerStreamObservers, Set<StreamVerifierFactory> readerStreamVerifiers, Set<StreamObserverFactory> writerStreamObservers, Set<StreamVerifierFactory> writerStreamVerifiers) throws RepositoryException {
        Server server;
        try {
            server = new Server(id, rootDir.toURL());
        }
        catch (MalformedURLException e) {
            throw new RepositoryException((Throwable)e);
        }
        server.setReaderStreamObserverFactories(readerStreamObservers);
        server.setReaderStreamVerifierFactories(readerStreamVerifiers);
        server.setWriterStreamObserverFactories(writerStreamObservers);
        server.setWriterStreamVerifierFactories(writerStreamVerifiers);
        LocalRepositoryM2 repo = new LocalRepositoryM2(server, this.findDependencyProcessor());
        return repo;
    }

    @Override
    public void write(Repository repo, Artifact ... artifacts) throws RepositoryException {
        this.write(repo, Arrays.asList(artifacts));
    }

    @Override
    public void write(Repository repo, Collection<Artifact> artifacts) throws RepositoryException {
        if (repo == null) {
            throw new RepositoryException(_lang.getMessage("null.repo", new String[0]));
        }
        RepositoryWriter wr = repo.getWriter();
        wr.writeArtifacts(artifacts);
    }

    @Override
    public List<Artifact> read(List<Repository> repos, List<ArtifactMetadata> artifacts) throws RepositoryException {
        if (Util.isEmpty(repos)) {
            throw new RepositoryException(_lang.getMessage("null.repo", new String[0]));
        }
        VirtualRepositoryReader vr = new VirtualRepositoryReader(repos);
        ArtifactResults ar = vr.readArtifacts(artifacts);
        if (ar.hasExceptions()) {
            throw new RepositoryException(ar.getExceptions().toString());
        }
        if (!ar.hasResults()) {
            return null;
        }
        Map am = ar.getResults();
        ArrayList<Artifact> al = new ArrayList<Artifact>();
        for (Map.Entry e : am.entrySet()) {
            al.addAll((Collection)e.getValue());
        }
        return al;
    }

    @Override
    public List<Artifact> read(List<Repository> repo, ArtifactMetadata ... artifacts) throws RepositoryException {
        return this.read(repo, Arrays.asList(artifacts));
    }

    @Override
    public PgpStreamVerifierFactory createPgpReaderFactory(boolean lenient, boolean sufficient, InputStream pubRing) throws StreamVerifierException {
        return new PgpStreamVerifierFactory(new StreamVerifierAttributes("asc", lenient, sufficient), pubRing);
    }

    @Override
    public PgpStreamVerifierFactory createPgpWriterFactory(boolean lenient, boolean sufficient, InputStream secRing, String keyId, String keyPass) throws StreamVerifierException {
        return new PgpStreamVerifierFactory(new StreamVerifierAttributes("asc", lenient, sufficient), secRing, keyId, keyPass);
    }

    @Override
    public List<ArtifactMetadata> resolve(List<Repository> repos, ArtifactScopeEnum scope, ArtifactMetadata metadata) throws RepositoryException {
        return this.resolve(repos, scope, new ArtifactQueryList(new ArtifactBasicMetadata[]{metadata}), null, null);
    }

    @Override
    public List<ArtifactMetadata> resolve(List<Repository> repos, ArtifactScopeEnum scope, ArtifactQueryList artifacts, ArtifactInclusionList inclusions, ArtifactExclusionList exclusions) throws RepositoryException {
        if (Util.isEmpty((Object)artifacts) || artifacts.isEmpty()) {
            throw new IllegalArgumentException(_lang.getMessage("no.artifacts", new String[0]));
        }
        if (artifacts.size() > 1) {
            throw new RepositoryException("I dont support more'n 1 artifact now");
        }
        try {
            DependencyBuilder depBuilder = DependencyBuilderFactory.create((String)"java", repos, null, null, null);
            ArtifactBasicMetadata a = (ArtifactBasicMetadata)artifacts.getMetadataList().get(0);
            if (inclusions != null && !inclusions.isEmpty()) {
                a.setInclusions((Collection)inclusions.getMetadataList());
            }
            if (exclusions != null && !exclusions.isEmpty()) {
                a.setExclusions((Collection)exclusions.getMetadataList());
            }
            MetadataTreeNode root = depBuilder.buildTree(a, scope);
            List res = depBuilder.resolveConflicts(root);
            return res;
        }
        catch (MetadataTreeException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

