/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.api;

import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.mercury.artifact.ArtifactCoordinates;
import org.apache.maven.mercury.artifact.version.VersionComparator;
import org.apache.maven.mercury.repository.metadata.Metadata;
import org.apache.maven.mercury.repository.metadata.MetadataException;
import org.apache.maven.mercury.util.TimeUtil;
import org.apache.maven.mercury.util.Util;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryGAVMetadata {
    private static final Language _lang = new DefaultLanguage(RepositoryGAVMetadata.class);
    protected ArtifactCoordinates gav;
    protected TreeSet<String> snapshots = new TreeSet(new VersionComparator());
    protected Collection<String> classifiers;
    protected long lastCheck;
    protected transient boolean expired = false;

    protected RepositoryGAVMetadata() {
    }

    public RepositoryGAVMetadata(ArtifactCoordinates gav, Collection<String> snapshots, Collection<String> classifiers) {
        this.gav = gav;
        if (!Util.isEmpty(snapshots)) {
            this.snapshots.addAll(snapshots);
        }
        this.classifiers = classifiers;
        this.lastCheck = TimeUtil.getUTCTimestampAsLong();
    }

    public RepositoryGAVMetadata(Metadata md) throws MetadataException {
        if (md == null) {
            throw new IllegalArgumentException(_lang.getMessage("empty.mdbytes", new String[0]));
        }
        this.gav = new ArtifactCoordinates(md.getGroupId(), md.getArtifactId(), md.getVersion());
        List versions = null;
        if (md.getVersioning() != null) {
            versions = md.getVersioning().getVersions();
        }
        if (!Util.isEmpty(versions)) {
            this.snapshots.addAll(versions);
        }
        this.lastCheck = TimeUtil.getUTCTimestampAsLong();
    }

    public RepositoryGAVMetadata(RepositoryGAVMetadata md) throws MetadataException {
        this.gav = md.getGAV();
        if (!Util.isEmpty(md.getSnapshots())) {
            this.snapshots.addAll(md.getSnapshots());
        }
        this.lastCheck = TimeUtil.getUTCTimestampAsLong();
    }

    public TreeSet<String> getSnapshots() {
        return this.snapshots;
    }

    public Collection<String> getClassifiers() {
        return this.classifiers;
    }

    public String getSnapshot() {
        return this.snapshots.last();
    }

    public long getLastCheck() {
        return this.lastCheck;
    }

    public long getLastCheckMillis() throws ParseException {
        return TimeUtil.toMillis((long)this.lastCheck);
    }

    public void updateSnapshots(Collection<String> snapshots) {
        this.snapshots.clear();
        if (!Util.isEmpty(snapshots)) {
            this.snapshots.addAll(snapshots);
        }
        this.lastCheck = TimeUtil.getUTCTimestampAsLong();
    }

    public void updateClassifiers(Collection<String> classifiers) {
        this.classifiers = classifiers;
        this.lastCheck = TimeUtil.getUTCTimestampAsLong();
    }

    public ArtifactCoordinates getGAV() {
        return this.gav;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }
}

