/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.repository.cache.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.mercury.repository.api.MetadataCorruptionException;
import org.apache.maven.mercury.repository.cache.md.Attribute;
import org.apache.maven.mercury.repository.cache.md.CachedRawMetadata;
import org.apache.maven.mercury.repository.cache.md.Element;
import org.apache.maven.mercury.repository.cache.md.io.xpp3.CachedMetadataXpp3Reader;
import org.apache.maven.mercury.repository.cache.md.io.xpp3.CachedMetadataXpp3Writer;
import org.apache.maven.mercury.util.Util;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CachedMetadata {
    private static final Language _lang = new DefaultLanguage(CachedMetadata.class);
    private CachedRawMetadata crm;
    private File mdFile;

    private static CachedRawMetadata readRawMetadata(File mdFile) throws FileNotFoundException, IOException, XmlPullParserException {
        CachedMetadataXpp3Reader reader = new CachedMetadataXpp3Reader();
        return reader.read(new FileReader(mdFile));
    }

    private static void writeRawMetadata(CachedRawMetadata cmd, File mdFile) throws FileNotFoundException, IOException, XmlPullParserException {
        CachedMetadataXpp3Writer writer = new CachedMetadataXpp3Writer();
        writer.write(new FileWriter(mdFile), cmd);
    }

    protected CachedMetadata() {
        this.crm = new CachedRawMetadata();
    }

    protected CachedMetadata(File mdFile) throws FileNotFoundException, IOException, XmlPullParserException {
        this.crm = mdFile.exists() ? CachedMetadata.readRawMetadata(mdFile) : new CachedRawMetadata();
        this.mdFile = mdFile;
    }

    public void save(File mdFile) throws FileNotFoundException, IOException, XmlPullParserException {
        CachedMetadata.writeRawMetadata(this.crm, mdFile);
    }

    protected Element findElement(String elem) {
        ArrayList<Element> el = this.crm.getElements();
        if (Util.isEmpty((Collection)el)) {
            el = new ArrayList<Element>();
            this.crm.setElements(el);
        }
        Element e = null;
        for (Element le : el) {
            if (!le.getName().equals(elem)) continue;
            e = le;
            break;
        }
        if (e == null) {
            e = new Element();
            e.setName(elem);
            el.add(e);
        }
        return e;
    }

    protected void cleanAttribute(Element e, String attr) {
        List al = e.getAttributes();
        if (Util.isEmpty((Collection)al)) {
            return;
        }
        int sz = al.size();
        for (int i = sz - 1; i >= 0; --i) {
            Attribute a = (Attribute)al.get(i);
            if (!a.getName().equals(attr)) continue;
            al.remove(i);
        }
    }

    protected List<String> findAttributes(Element e, String attr) {
        ArrayList al = e.getAttributes();
        if (Util.isEmpty((Collection)al)) {
            al = new ArrayList();
            e.setAttributes(al);
            return null;
        }
        ArrayList<String> a = null;
        for (Attribute la : al) {
            if (!la.getName().equals(attr)) continue;
            if (a == null) {
                a = new ArrayList<String>();
            }
            a.add(la.getValue());
        }
        return a;
    }

    protected List<String> findAttributes(String elem, String attr) {
        Element e = this.findElement(elem);
        return this.findAttributes(e, attr);
    }

    protected String getAttribute(String elem, String attr, boolean mandatory) throws MetadataCorruptionException {
        Element e = this.findElement(elem);
        List<String> a = this.findAttributes(e, attr);
        if (Util.isEmpty(a)) {
            if (mandatory) {
                throw new MetadataCorruptionException(_lang.getMessage("no.mandatory.attribute", new String[]{elem, attr}));
            }
            return null;
        }
        return a.get(0);
    }

    protected void addAttribute(Element e, String attr, String val) {
        ArrayList<Attribute> al = e.getAttributes();
        if (al == null) {
            al = new ArrayList<Attribute>();
            e.setAttributes(al);
        }
        Attribute a = new Attribute();
        a.setName(attr);
        a.setValue(val);
        al.add(a);
    }

    protected void setAttribute(String elem, String attr, String val) {
        Element e = this.findElement(elem);
        this.cleanAttribute(e, attr);
        this.addAttribute(e, attr, val);
    }

    protected void setAttribute(String elem, String attr, Collection<String> vals) {
        Element e = this.findElement(elem);
        this.cleanAttribute(e, attr);
        for (String val : vals) {
            this.addAttribute(e, attr, val);
        }
    }

    protected void setLastUpdate(String lastUpdated) {
        this.crm.setLastUpdated(lastUpdated);
    }

    protected String getLastUpdate() {
        return this.crm.getLastUpdated();
    }

    protected void clean() {
        this.crm.setElements(null);
    }
}

