/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.client;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.transport.api.Server;
import org.mortbay.jetty.client.Address;
import org.mortbay.jetty.client.HttpDestination;
import org.mortbay.jetty.client.security.Realm;
import org.mortbay.jetty.client.security.RealmResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DestinationRealmResolver
implements RealmResolver {
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(DestinationRealmResolver.class);
    protected Set<Server> _servers = new HashSet<Server>();

    public DestinationRealmResolver(Set<Server> servers) {
        this._servers.addAll(servers);
    }

    public Realm getRealm(String name, HttpDestination dest, String pathSpec) throws IOException {
        Address address = dest.getAddress();
        boolean secure = dest.isSecure();
        if (_log.isDebugEnabled()) {
            _log.debug("Dest " + address.getHost() + ":" + address.getPort() + "(secure=" + secure + ")");
            _log.debug("Server list: " + this._servers);
        }
        Server server = null;
        Iterator<Server> itor = this._servers.iterator();
        while (server == null && itor.hasNext()) {
            Server s = itor.next();
            if (s.getURL() == null) continue;
            String protocol = s.getURL().getProtocol();
            String host = s.getURL().getHost();
            int port = s.getURL().getPort();
            if (port == -1) {
                int n = port = "https".equalsIgnoreCase(protocol) ? 443 : 80;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Trying dest " + address.getHost() + ":" + address.getPort() + "(secure=" + dest.isSecure() + ") against server " + protocol + "://" + host + ":" + port);
            }
            if ((!secure || !"https".equalsIgnoreCase(protocol)) && (secure || !"http".equalsIgnoreCase(protocol)) || address.getPort() != port || !address.getHost().equalsIgnoreCase(host) && !address.getHost().equalsIgnoreCase(host)) continue;
            server = s;
            if (!_log.isDebugEnabled()) continue;
            _log.debug("Matched server " + address.getHost() + ":" + address.getPort());
        }
        if (server == null || server.getServerCredentials() == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("No server matching " + address.getHost() + ":" + address.getPort() + " or no credentials");
            }
            return null;
        }
        if (server.getServerCredentials().isCertificate()) {
            throw new UnsupportedOperationException("Certificate not supported");
        }
        final Server realmServer = server;
        return new Realm(){

            public String getCredentials() {
                return realmServer.getServerCredentials().getPass();
            }

            public String getId() {
                return realmServer.getId();
            }

            public String getPrincipal() {
                return realmServer.getServerCredentials().getUser();
            }
        };
    }
}

