/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.client;

import java.net.URI;
import java.net.URL;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.transport.api.Credentials;
import org.apache.maven.mercury.transport.api.Server;
import org.mortbay.jetty.client.Address;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpDestination;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.jetty.client.security.Authorization;
import org.mortbay.jetty.client.security.ProxyAuthorization;

public class SecureSender {
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(SecureSender.class);

    public static void send(Server server, HttpClient httpClient, HttpExchange exchange) throws Exception {
        if (server != null && server.hasProxy() && server.getProxy() != null) {
            String s = exchange.getURI();
            URI uri = new URI(s);
            boolean ssl = "https".equalsIgnoreCase(uri.getScheme());
            URL proxy = server.getProxy();
            String host = proxy.getHost();
            int port = proxy.getPort();
            boolean proxySsl = "https".equalsIgnoreCase(proxy.getProtocol());
            if (port < 0) {
                port = proxySsl ? 443 : 80;
            }
            Address proxyAddress = new Address(host, port);
            HttpDestination destination = httpClient.getDestination(exchange.getAddress(), ssl);
            if (_log.isDebugEnabled()) {
                _log.debug("Matched destination " + destination);
            }
            destination.setProxy(proxyAddress);
            if (_log.isDebugEnabled()) {
                _log.debug("Set proxy " + host + ":" + port + " on destination");
            }
            _log.info("Set proxy " + host + ":" + port + " on destination");
            Credentials proxyCredentials = server.getProxyCredentials();
            if (proxyCredentials != null) {
                if (proxyCredentials.isCertificate()) {
                    throw new UnsupportedOperationException("Proxy credential not supported");
                }
                destination.setProxyAuthentication((Authorization)new ProxyAuthorization(proxyCredentials.getUser(), proxyCredentials.getPass()));
                if (_log.isDebugEnabled()) {
                    _log.debug("Set proxy authentication: " + proxyCredentials.getUser() + ":" + proxyCredentials.getPass());
                }
            }
            destination.send(exchange);
        } else {
            httpClient.send(exchange);
        }
    }
}

