/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.client.deploy;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.mercury.crypto.api.StreamObserver;
import org.apache.maven.mercury.crypto.api.StreamObserverException;
import org.apache.maven.mercury.crypto.api.StreamVerifierFactory;
import org.apache.maven.mercury.spi.http.client.DestinationRealmResolver;
import org.apache.maven.mercury.spi.http.client.HandshakeExchange;
import org.apache.maven.mercury.spi.http.client.HttpClientException;
import org.apache.maven.mercury.spi.http.client.deploy.BatchIdGenerator;
import org.apache.maven.mercury.spi.http.client.deploy.DefaultDeployResponse;
import org.apache.maven.mercury.spi.http.client.deploy.DeployCallback;
import org.apache.maven.mercury.spi.http.client.deploy.DeployRequest;
import org.apache.maven.mercury.spi.http.client.deploy.DeployResponse;
import org.apache.maven.mercury.spi.http.client.deploy.Deployer;
import org.apache.maven.mercury.spi.http.client.deploy.DeploymentTarget;
import org.apache.maven.mercury.spi.http.client.deploy.RandomBatchIdGenerator;
import org.apache.maven.mercury.transport.api.Binding;
import org.apache.maven.mercury.transport.api.Server;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.security.RealmResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDeployer
implements Deployer {
    private HttpClient _httpClient;
    private BatchIdGenerator _idGenerator;
    private Set<Server> _servers = new HashSet<Server>();

    public DefaultDeployer() throws HttpClientException {
        this._idGenerator = new RandomBatchIdGenerator();
        this._httpClient = new HttpClient();
        this._httpClient.setConnectorType(2);
        this._httpClient.registerListener("org.mortbay.jetty.client.webdav.WebdavListener");
        try {
            this._httpClient.start();
        }
        catch (Exception e) {
            throw new HttpClientException(null, "unable to start http client", e);
        }
    }

    public DefaultDeployer(HttpClient client, BatchIdGenerator idGenerator) throws HttpClientException {
        this._idGenerator = idGenerator;
        if (this._idGenerator == null) {
            throw new HttpClientException(null, "no id generator supplied");
        }
        this._httpClient = client;
        try {
            if (this._httpClient.isStarted()) {
                this._httpClient.start();
            }
        }
        catch (Exception e) {
            throw new HttpClientException(null, "unable to start http client", e);
        }
    }

    public BatchIdGenerator getBatchIdGenerator() {
        return this._idGenerator;
    }

    public HttpClient getHttpClient() {
        return this._httpClient;
    }

    public void setServers(Set<Server> servers) {
        this._servers.clear();
        this._servers.addAll(servers);
        this._httpClient.setRealmResolver((RealmResolver)new DestinationRealmResolver(this._servers));
    }

    public Set<Server> getServers() {
        return this._servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeployResponse deploy(DeployRequest request) {
        final DeployResponse[] response = new DeployResponse[]{null};
        this.deploy(request, new DeployCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(DeployResponse r) {
                DeployResponse[] deployResponseArray = response;
                synchronized (response) {
                    response[0] = r;
                    response.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        DeployResponse[] deployResponseArray = response;
        synchronized (response) {
            try {
                while (response[0] == null) {
                    response.wait();
                }
            }
            catch (InterruptedException e) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            return response[0];
        }
    }

    @Override
    public void deploy(final DeployRequest request, final DeployCallback callback) {
        if (request == null) {
            throw new IllegalArgumentException("No request");
        }
        if (callback == null) {
            throw new IllegalArgumentException("No callback");
        }
        final String batchId = this._idGenerator.getId();
        final AtomicInteger count = new AtomicInteger(request.getBindings().size());
        ArrayList<2> targets = new ArrayList<2>(request.getBindings().size());
        final DefaultDeployResponse response = new DefaultDeployResponse();
        final HashSet<String> remoteHandshakeUrls = new HashSet<String>();
        Binding[] bindings = new Binding[request.getBindings().size()];
        request.getBindings().toArray(bindings);
        for (int i = 0; i < bindings.length && count.get() > 0; ++i) {
            Binding binding = bindings[i];
            DeploymentTarget target = null;
            try {
                Server server = this.resolveServer(binding);
                Set<StreamObserver> observers = this.createStreamObservers(server);
                target = new DeploymentTarget(server, this._httpClient, batchId, binding, request.getValidators(), observers){

                    public void onComplete() {
                        if (this.getRemoteJettyUrl() != null) {
                            remoteHandshakeUrls.add(this.getRemoteJettyUrl());
                        }
                        DefaultDeployer.this.checkComplete(callback, batchId, count, request, response, remoteHandshakeUrls);
                    }

                    public void onError(HttpClientException exception) {
                        if (this.getRemoteJettyUrl() != null) {
                            remoteHandshakeUrls.add(this.getRemoteJettyUrl());
                        }
                        response.add(exception);
                        DefaultDeployer.this.checkComplete(callback, batchId, count, request, response, remoteHandshakeUrls);
                    }
                };
                targets.add(target);
                continue;
            }
            catch (Exception e) {
                response.add(new HttpClientException(binding, (Throwable)e));
                this.checkComplete(callback, batchId, count, request, response, remoteHandshakeUrls);
            }
        }
        for (DeploymentTarget deploymentTarget : targets) {
            deploymentTarget.deploy();
        }
    }

    private synchronized void checkComplete(DeployCallback callback, String batchId, AtomicInteger count, DeployRequest request, DeployResponse response, Set<String> remoteHandshakeUrls) {
        boolean completor;
        int x = count.decrementAndGet();
        boolean bl = completor = x == 0;
        if (!completor && request.isFailFast() && response.getExceptions().size() > 0) {
            boolean bl2 = completor = count.getAndSet(0) > 0;
        }
        if (completor) {
            this.commit(callback, response, batchId, remoteHandshakeUrls);
        }
    }

    private void commit(final DeployCallback callback, final DeployResponse response, String batchId, Set<String> remoteHandshakeUrls) {
        if (remoteHandshakeUrls.isEmpty()) {
            callback.onComplete(response);
        } else {
            final AtomicInteger count = new AtomicInteger(remoteHandshakeUrls.size());
            HashMap<String, String> headers = new HashMap<String, String>();
            if (response.getExceptions().isEmpty()) {
                headers.put("Jetty-Batch-Commit", batchId);
            } else {
                headers.put("Jetty-Batch-Discard", batchId);
            }
            for (String remoteUrl : remoteHandshakeUrls) {
                HandshakeExchange exchange = new HandshakeExchange(this._httpClient, "POST", remoteUrl, headers){

                    public void onHandshakeComplete(String url) {
                        DefaultDeployer.this.checkHandshakeComplete(callback, response, count);
                    }

                    public void onHandshakeError(String url, Exception e) {
                        response.getExceptions().add(new HttpClientException(null, (Throwable)e));
                        DefaultDeployer.this.checkHandshakeComplete(callback, response, count);
                    }
                };
            }
        }
    }

    private void checkHandshakeComplete(DeployCallback callback, DeployResponse response, AtomicInteger count) {
        boolean completor;
        boolean bl = completor = count.decrementAndGet() == 0;
        if (completor) {
            callback.onComplete(response);
        }
    }

    private Server resolveServer(Binding binding) throws MalformedURLException {
        if (binding.getRemoteResource() == null) {
            return null;
        }
        URL bindingURL = binding.getRemoteResource();
        Iterator<Server> itor = this._servers.iterator();
        Server server = null;
        while (itor.hasNext() && server == null) {
            Server s = itor.next();
            if (!bindingURL.getProtocol().equalsIgnoreCase(s.getURL().getProtocol()) || !bindingURL.getHost().equalsIgnoreCase(s.getURL().getHost()) || bindingURL.getPort() != s.getURL().getPort()) continue;
            server = s;
        }
        return server;
    }

    private Set<StreamObserver> createStreamObservers(Server server) throws StreamObserverException {
        Set factories;
        HashSet<StreamObserver> observers = new HashSet<StreamObserver>();
        if (server == null) {
            return observers;
        }
        if (server.hasWriterStreamVerifierFactories()) {
            factories = server.getWriterStreamVerifierFactories();
            for (StreamVerifierFactory f : factories) {
                observers.add((StreamObserver)f.newInstance());
            }
        }
        if (server.hasWriterStreamObserverFactories()) {
            factories = server.getWriterStreamObserverFactories();
            for (StreamVerifierFactory f : factories) {
                observers.add(f.newInstance());
            }
        }
        return observers;
    }
}

