/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.client.retrieve;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.mercury.crypto.api.StreamObserver;
import org.apache.maven.mercury.crypto.api.StreamObserverException;
import org.apache.maven.mercury.crypto.api.StreamVerifierException;
import org.apache.maven.mercury.crypto.api.StreamVerifierFactory;
import org.apache.maven.mercury.spi.http.client.DestinationRealmResolver;
import org.apache.maven.mercury.spi.http.client.HttpClientException;
import org.apache.maven.mercury.spi.http.client.retrieve.DefaultRetrievalResponse;
import org.apache.maven.mercury.spi.http.client.retrieve.RetrievalCallback;
import org.apache.maven.mercury.spi.http.client.retrieve.RetrievalRequest;
import org.apache.maven.mercury.spi.http.client.retrieve.RetrievalResponse;
import org.apache.maven.mercury.spi.http.client.retrieve.RetrievalTarget;
import org.apache.maven.mercury.spi.http.client.retrieve.Retriever;
import org.apache.maven.mercury.transport.api.Binding;
import org.apache.maven.mercury.transport.api.Server;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.security.RealmResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRetriever
implements Retriever {
    private HttpClient _httpClient;
    private Set<Server> _servers = new HashSet<Server>();

    public DefaultRetriever() throws HttpClientException {
        this._httpClient = new HttpClient();
        this._httpClient.setConnectorType(2);
        try {
            this._httpClient.start();
        }
        catch (Exception e) {
            throw new HttpClientException(null, "Unable to start http client.", e);
        }
    }

    public DefaultRetriever(HttpClient client) throws HttpClientException {
        this._httpClient = client;
        try {
            if (this._httpClient.isStarted()) {
                this._httpClient.start();
            }
        }
        catch (Exception e) {
            throw new HttpClientException(null, "unable to start http client", e);
        }
    }

    public void setServers(Set<Server> servers) {
        this._servers.clear();
        this._servers.addAll(servers);
        this._httpClient.setRealmResolver((RealmResolver)new DestinationRealmResolver(this._servers));
    }

    public Set<Server> getServers() {
        return this._servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetrievalResponse retrieve(RetrievalRequest request) {
        final RetrievalResponse[] response = new RetrievalResponse[]{null};
        this.retrieve(request, new RetrievalCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(RetrievalResponse r) {
                RetrievalResponse[] retrievalResponseArray = response;
                synchronized (response) {
                    response[0] = r;
                    response.notify();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        RetrievalResponse[] retrievalResponseArray = response;
        synchronized (response) {
            try {
                while (response[0] == null) {
                    response.wait();
                }
            }
            catch (InterruptedException e) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            return response[0];
        }
    }

    @Override
    public void retrieve(final RetrievalRequest request, final RetrievalCallback callback) {
        if (request == null) {
            throw new IllegalArgumentException("No request");
        }
        if (callback == null) {
            throw new IllegalArgumentException("No callback");
        }
        final AtomicInteger count = new AtomicInteger(request.getBindings().size());
        final ArrayList<RetrievalTarget> targets = new ArrayList<RetrievalTarget>(request.getBindings().size());
        final DefaultRetrievalResponse response = new DefaultRetrievalResponse();
        Binding[] bindings = new Binding[request.getBindings().size()];
        request.getBindings().toArray(bindings);
        for (int i = 0; i < bindings.length && count.get() > 0; ++i) {
            final Binding binding = bindings[i];
            RetrievalTarget target = null;
            try {
                Server server = this.resolveServer(binding);
                Set<StreamObserver> observers = this.createStreamObservers(server);
                target = new RetrievalTarget(server, this, binding, request.getValidators(), observers){

                    public void onComplete() {
                        ArrayList<String> validateErrors;
                        boolean checksumOK = false;
                        try {
                            checksumOK = this.verifyChecksum();
                            if (!checksumOK) {
                                response.add(new HttpClientException(binding, "Checksum failed"));
                            }
                        }
                        catch (StreamVerifierException e) {
                            response.add(new HttpClientException(binding, e.getMessage()));
                        }
                        if (checksumOK && !this.validate(validateErrors = new ArrayList<String>())) {
                            for (String s : validateErrors) {
                                response.add(new HttpClientException(binding, s));
                            }
                        }
                        if (DefaultRetriever.this.isComplete(count, request, response, targets)) {
                            callback.onComplete(response);
                        }
                    }

                    public void onError(HttpClientException exception) {
                        response.add(exception);
                        if (DefaultRetriever.this.isComplete(count, request, response, targets)) {
                            callback.onComplete(response);
                        }
                    }
                };
                targets.add(target);
                continue;
            }
            catch (Exception e) {
                response.add(new HttpClientException(binding, (Throwable)e));
                if (!this.isComplete(count, request, response, targets)) continue;
                callback.onComplete(response);
            }
        }
        for (RetrievalTarget target : targets) {
            target.retrieve();
        }
    }

    private boolean isComplete(AtomicInteger count, RetrievalRequest request, RetrievalResponse response, List<RetrievalTarget> targets) {
        boolean completor;
        boolean bl = completor = count.decrementAndGet() == 0;
        if (!completor && request.isFailFast() && response.getExceptions().size() > 0) {
            boolean bl2 = completor = count.getAndSet(0) > 0;
        }
        if (completor) {
            if (response.getExceptions().size() == 0) {
                for (RetrievalTarget t : targets) {
                    if (t == null) continue;
                    t.move();
                }
            }
            for (RetrievalTarget t : targets) {
                t.cleanup();
            }
            return true;
        }
        return false;
    }

    public HttpClient getHttpClient() {
        return this._httpClient;
    }

    private Server resolveServer(Binding binding) throws MalformedURLException {
        if (binding.getRemoteResource() == null) {
            return null;
        }
        URL bindingURL = binding.getRemoteResource();
        if (this._servers == null) {
            return null;
        }
        Iterator<Server> itor = this._servers.iterator();
        Server server = null;
        while (itor.hasNext() && server == null) {
            Server s = itor.next();
            if (!bindingURL.getProtocol().equalsIgnoreCase(s.getURL().getProtocol()) || !bindingURL.getHost().equalsIgnoreCase(s.getURL().getHost()) || bindingURL.getPort() != s.getURL().getPort()) continue;
            server = s;
        }
        return server;
    }

    private Set<StreamObserver> createStreamObservers(Server server) throws StreamObserverException {
        Set factories;
        HashSet<StreamObserver> observers = new HashSet<StreamObserver>();
        if (server == null) {
            return observers;
        }
        if (server.hasReaderStreamVerifierFactories()) {
            factories = server.getReaderStreamVerifierFactories();
            for (StreamVerifierFactory f : factories) {
                observers.add((StreamObserver)f.newInstance());
            }
        }
        if (server.hasReaderStreamObserverFactories()) {
            factories = server.getReaderStreamObserverFactories();
            for (StreamVerifierFactory f : factories) {
                observers.add(f.newInstance());
            }
        }
        return observers;
    }
}

