/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.client.retrieve;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.mercury.crypto.api.StreamObserver;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.spi.http.client.FileExchange;
import org.apache.maven.mercury.spi.http.client.HttpClientException;
import org.apache.maven.mercury.spi.http.client.ObservableOutputStream;
import org.apache.maven.mercury.transport.api.Binding;
import org.apache.maven.mercury.transport.api.Server;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferUtil;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.client.HttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileGetExchange
extends FileExchange {
    private static final IMercuryLogger log = MercuryLoggerManager.getLogger(FileGetExchange.class);
    private OutputStream _outputStream;
    private Set<StreamObserver> _observers = new HashSet<StreamObserver>();
    int _contentLength = -1;

    public FileGetExchange(Server server, Binding binding, File localFile, Set<StreamObserver> observers, HttpClient client) {
        super(server, binding, localFile, client);
        if (observers != null) {
            this._observers.addAll(observers);
        }
    }

    @Override
    public void send() {
        this.setMethod("GET");
        super.send();
    }

    protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
        int header = HttpHeaders.CACHE.getOrdinal(value);
        switch (header) {
            case 12: {
                this._contentLength = BufferUtil.toInt((Buffer)value);
                for (StreamObserver o : this._observers) {
                    o.setLength((long)this._contentLength);
                }
                if (!log.isDebugEnabled()) break;
                log.debug("GET of " + this._contentLength + " bytes");
                break;
            }
            case 18: {
                for (StreamObserver o : this._observers) {
                    o.setLastModified(BufferUtil.to8859_1_String((Buffer)value));
                }
                break;
            }
        }
    }

    protected void onResponseComplete() {
        try {
            if (this._outputStream != null) {
                this._outputStream.close();
            }
            if (this._status == 404) {
                this.onFileError(this._url, new FileNotFoundException("File not found on remote server"));
                return;
            }
            if (this._status != 200) {
                this.onFileError(this._url, new Exception("Http status code=" + this._status));
                return;
            }
            this.onFileComplete(this._url, this._localFile);
        }
        catch (Exception e) {
            this.onFileError(this._url, new HttpClientException(this._binding, e.getLocalizedMessage()));
        }
    }

    protected void onResponseContent(Buffer content) throws IOException {
        try {
            OutputStream os = this.getOutputStream();
            content.writeTo(os);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    protected OutputStream getOutputStream() throws IOException, NoSuchAlgorithmException {
        if (this._outputStream == null) {
            OutputStream os = null;
            if (this._binding.isFile()) {
                os = new FileOutputStream(this._localFile);
            } else if (this._binding.isInMemory()) {
                os = this._binding.getLocalOutputStream();
            }
            ObservableOutputStream oos = new ObservableOutputStream(os);
            oos.addObservers(this._observers);
            this._outputStream = oos;
        }
        return this._outputStream;
    }
}

