/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.client.retrieve;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.mercury.crypto.api.StreamObserver;
import org.apache.maven.mercury.crypto.api.StreamVerifier;
import org.apache.maven.mercury.crypto.api.StreamVerifierException;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.spi.http.client.FileExchange;
import org.apache.maven.mercury.spi.http.client.HttpClientException;
import org.apache.maven.mercury.spi.http.client.SecureSender;
import org.apache.maven.mercury.spi.http.client.retrieve.DefaultRetriever;
import org.apache.maven.mercury.spi.http.client.retrieve.FileGetExchange;
import org.apache.maven.mercury.spi.http.validate.Validator;
import org.apache.maven.mercury.transport.api.Binding;
import org.apache.maven.mercury.transport.api.Server;
import org.mortbay.jetty.client.HttpExchange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RetrievalTarget {
    private static final IMercuryLogger log = MercuryLoggerManager.getLogger(RetrievalTarget.class);
    public static final String __PREFIX = "JTY_";
    public static final String __TEMP_SUFFIX = ".tmp";
    public static final int __START_STATE = 1;
    public static final int __REQUESTED_STATE = 2;
    public static final int __READY_STATE = 3;
    protected int _checksumState;
    protected int _targetState;
    protected Server _server;
    protected HttpClientException _exception;
    protected Binding _binding;
    protected File _tempFile;
    protected DefaultRetriever _retriever;
    protected boolean _complete;
    protected HttpExchange _exchange;
    protected Set<Validator> _validators;
    protected Set<StreamObserver> _observers = new HashSet<StreamObserver>();
    protected List<StreamVerifier> _verifiers = new ArrayList<StreamVerifier>();
    protected Map<StreamVerifier, String> _verifierMap = new HashMap<StreamVerifier, String>();

    public abstract void onComplete();

    public abstract void onError(HttpClientException var1);

    public RetrievalTarget(Server server, DefaultRetriever retriever, Binding binding, Set<Validator> validators, Set<StreamObserver> observers) {
        if (binding == null || binding.getRemoteResource() == null || binding.isFile() && binding.getLocalFile() == null || binding.isInMemory() && binding.getLocalOutputStream() == null) {
            throw new IllegalArgumentException("Nothing to retrieve");
        }
        this._server = server;
        this._retriever = retriever;
        this._binding = binding;
        this._validators = validators;
        for (StreamObserver o : observers) {
            if (StreamVerifier.class.isAssignableFrom(o.getClass())) {
                this._verifiers.add((StreamVerifier)o);
                continue;
            }
            this._observers.add(o);
        }
        if (this._binding.isFile()) {
            this._tempFile = new File(this._binding.getLocalFile().getParentFile(), __PREFIX + this._binding.getLocalFile().getName() + __TEMP_SUFFIX);
            this._tempFile.deleteOnExit();
            if (!this._tempFile.getParentFile().exists()) {
                this._tempFile.getParentFile().mkdirs();
            }
            if (this._tempFile.exists()) {
                this.onError(new HttpClientException(binding, "File exists " + this._tempFile.getAbsolutePath()));
            } else if (!this._tempFile.getParentFile().canWrite()) {
                this.onError(new HttpClientException(binding, "Unable to write to dir " + this._tempFile.getParentFile().getAbsolutePath()));
            }
        }
    }

    public File getTempFile() {
        return this._tempFile;
    }

    public String getUrl() {
        return this._binding.getRemoteResource().toExternalForm();
    }

    public void retrieve() {
        if (this._verifiers.size() == 0) {
            this._checksumState = 3;
            this.updateTargetState(1, null);
        } else {
            this._checksumState = 1;
            this.updateChecksumState(-1, null);
        }
    }

    public boolean move() {
        if (this._binding.isFile()) {
            boolean ok = this._tempFile.renameTo(this._binding.getLocalFile());
            if (log.isDebugEnabled()) {
                log.debug("Renaming " + this._tempFile.getAbsolutePath() + " to " + this._binding.getLocalFile().getAbsolutePath() + ": " + ok);
            }
            return ok;
        }
        return true;
    }

    public synchronized void cleanup() {
        this.deleteTempFile();
        if (this._exchange != null) {
            this._exchange.cancel();
        }
    }

    public synchronized boolean isComplete() {
        return this._complete;
    }

    public String toString() {
        return "T:" + this._binding.getRemoteResource() + ":" + this._targetState + ":" + this._checksumState + ":" + this._complete;
    }

    private void updateChecksumState(int index, Throwable ex) {
        if (this._exception == null && ex != null) {
            this._exception = ex instanceof HttpClientException ? (HttpClientException)ex : new HttpClientException(this._binding, ex);
        }
        if (ex != null) {
            this._checksumState = 3;
            this.onError(this._exception);
        } else {
            StreamVerifier v;
            boolean proceedWithTargetFile = false;
            if (index >= 0 && this._verifierMap.containsKey(v = this._verifiers.get(index)) && v.getAttributes().isSufficient()) {
                proceedWithTargetFile = true;
            }
            if (++index < this._verifiers.size() && !proceedWithTargetFile) {
                this.retrieveChecksum(index);
            } else {
                this._checksumState = 3;
                this._observers.addAll(this._verifierMap.keySet());
                this.updateTargetState(1, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyChecksum() throws StreamVerifierException {
        boolean ok = true;
        Map<StreamVerifier, String> map = this._verifierMap;
        synchronized (map) {
            Iterator<Map.Entry<StreamVerifier, String>> itor = this._verifierMap.entrySet().iterator();
            while (itor.hasNext() && ok) {
                Map.Entry<StreamVerifier, String> e = itor.next();
                ok = e.getKey().verifySignature();
            }
        }
        return ok;
    }

    public boolean validate(List<String> errors) {
        int i;
        if (this._validators == null || this._validators.isEmpty()) {
            return true;
        }
        String ext = this._binding.getRemoteResource().toString();
        if (ext.endsWith("/")) {
            ext = ext.substring(0, ext.length() - 1);
        }
        ext = (i = ext.lastIndexOf(".")) > 0 ? ext.substring(i + 1) : "";
        for (Validator v : this._validators) {
            String vExt = v.getFileExtension();
            if (!vExt.equalsIgnoreCase(ext)) continue;
            try {
                if (this._binding.isFile()) {
                    if (v.validate(this._tempFile.getCanonicalPath(), errors)) continue;
                    return false;
                }
                if (!this._binding.isInMemory()) continue;
            }
            catch (IOException e) {
                errors.add(e.getMessage());
                return false;
            }
        }
        return true;
    }

    protected synchronized void updateTargetState(int state, Throwable ex) {
        this._targetState = state;
        if (this._exception == null && ex != null) {
            this._exception = ex instanceof HttpClientException ? (HttpClientException)ex : new HttpClientException(this._binding, ex);
        }
        if (this._targetState == 1) {
            this._exchange = this.retrieveTargetFile();
        } else if (this._targetState == 3) {
            this._complete = true;
            if (this._exception == null) {
                this.onComplete();
            } else {
                this.onError(this._exception);
            }
        }
    }

    private HttpExchange retrieveChecksum(final int index) {
        HttpExchange.ContentExchange exchange = new HttpExchange.ContentExchange(){

            protected void onException(Throwable ex) {
                if (!RetrievalTarget.this._verifiers.get(index).getAttributes().isLenient()) {
                    RetrievalTarget.this.updateChecksumState(index, ex);
                } else {
                    RetrievalTarget.this.updateChecksumState(index, null);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onResponseComplete() throws IOException {
                super.onResponseComplete();
                StreamVerifier v = RetrievalTarget.this._verifiers.get(index);
                if (this.getResponseStatus() == 200) {
                    Map<StreamVerifier, String> map = RetrievalTarget.this._verifierMap;
                    synchronized (map) {
                        if (v.getAttributes().isSufficient()) {
                            RetrievalTarget.this._verifierMap.clear();
                        }
                        String actualSignature = this.getResponseContent().trim();
                        try {
                            v.initSignature(actualSignature);
                        }
                        catch (StreamVerifierException e) {
                            throw new IOException(e.getMessage());
                        }
                        RetrievalTarget.this._verifierMap.put(v, actualSignature);
                    }
                    RetrievalTarget.this.updateChecksumState(index, null);
                } else if (!v.getAttributes().isLenient()) {
                    RetrievalTarget.this.updateChecksumState(index, new Exception("Mandatory checksum file not found " + this.getURI()));
                } else {
                    RetrievalTarget.this.updateChecksumState(index, null);
                }
            }
        };
        exchange.setURL(this.getChecksumFileURLAsString(this._verifiers.get(index)));
        try {
            SecureSender.send(this._server, this._retriever.getHttpClient(), (HttpExchange)exchange);
        }
        catch (Exception ex) {
            this.updateChecksumState(index, ex);
        }
        return exchange;
    }

    private HttpExchange retrieveTargetFile() {
        this.updateTargetState(2, null);
        FileGetExchange exchange = new FileGetExchange(this._server, this._binding, this.getTempFile(), this._observers, this._retriever.getHttpClient()){

            public void onFileComplete(String url, File localFile) {
                RetrievalTarget.this._targetState = 3;
                RetrievalTarget.this.updateTargetState(3, null);
            }

            public void onFileError(String url, Exception e) {
                RetrievalTarget.this._targetState = 3;
                RetrievalTarget.this.updateTargetState(3, e);
            }
        };
        if (this._server != null && this._server.hasUserAgent()) {
            exchange.setRequestHeader("User-Agent", this._server.getUserAgent());
        }
        ((FileExchange)exchange).send();
        return exchange;
    }

    private String getChecksumFileURLAsString(StreamVerifier verifier) {
        String extension = verifier.getAttributes().getExtension();
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        return this._binding.getRemoteResource().toString() + extension;
    }

    private boolean deleteTempFile() {
        if (this._tempFile != null && this._tempFile.exists()) {
            boolean ok = this._tempFile.delete();
            if (log.isDebugEnabled()) {
                log.debug("Deleting file " + this._tempFile.getAbsolutePath() + " : " + ok);
            }
            return ok;
        }
        return false;
    }
}

