/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.spi.http.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.maven.mercury.spi.http.server.BatchFilter;
import org.mortbay.util.IO;
import org.mortbay.util.URIUtil;

public class StagingBatchFilter
extends BatchFilter {
    private String _stagingDirURI;

    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        String t = config.getInitParameter("stagingDirURI");
        if (t != null) {
            this._stagingDirURI = t;
        } else {
            File f = new File(this._context.getRealPath("/"));
            File w = new File(f, "WEB-INF");
            File l = new File(w, "lib");
            this._stagingDirURI = l.toURI().toString();
        }
    }

    public void putFile(HttpServletRequest request, HttpServletResponse response, String pathInContext, String batchId) throws Exception {
        String stagedResource = URIUtil.addPaths((String)this._stagingDirURI, (String)batchId);
        stagedResource = URIUtil.addPaths((String)stagedResource, (String)pathInContext);
        File stagedFile = null;
        try {
            stagedFile = new File(new URI(stagedResource));
            File parent = stagedFile.getParentFile();
            parent.mkdirs();
            int toRead = request.getContentLength();
            ServletInputStream in = request.getInputStream();
            FileOutputStream out = new FileOutputStream(stagedFile, false);
            if (toRead >= 0) {
                IO.copy((InputStream)in, (OutputStream)out, (long)toRead);
            } else {
                IO.copy((InputStream)in, (OutputStream)out);
            }
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            try {
                if (stagedFile.exists()) {
                    stagedFile.delete();
                }
                throw e;
            }
            catch (Exception ex) {
                this._context.log(ex.toString(), (Throwable)ex);
            }
        }
    }

    public boolean commitFiles(HttpServletRequest request, HttpServletResponse response, BatchFilter.Batch batch) throws Exception {
        if (batch == null) {
            return true;
        }
        boolean ok = true;
        String stagedResource = URIUtil.addPaths((String)this._stagingDirURI, (String)batch.getBatchId());
        File batchDir = new File(new URI(stagedResource));
        File[] files = batchDir.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            String name = files[i].getName();
            File dest = new File(new URI(URIUtil.addPaths((String)this._baseURI, (String)name)));
            if (files[i].renameTo(dest)) continue;
            ok = false;
            this._context.log("Unable to rename file " + files[i].getAbsolutePath() + " to " + dest.getAbsolutePath());
        }
        if (ok && !(ok = batchDir.delete())) {
            this._context.log("Unable to delete batch dir " + batchDir.getAbsolutePath());
        }
        return ok;
    }

    public boolean discardFiles(HttpServletRequest request, HttpServletResponse response, BatchFilter.Batch batch) throws Exception {
        if (batch == null) {
            return true;
        }
        String stagedResource = URIUtil.addPaths((String)this._stagingDirURI, (String)batch.getBatchId());
        File batchDir = new File(new URI(stagedResource));
        boolean ok = true;
        if (!this.deleteFile(batchDir)) {
            ok = false;
        }
        return ok;
    }

    private boolean deleteFile(File f) {
        if (f == null) {
            return true;
        }
        if (f.isFile()) {
            boolean ok = f.delete();
            if (!ok) {
                this._context.log("Unable to delete file " + f.getAbsolutePath());
            }
            return ok;
        }
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            boolean ok = true;
            for (int i = 0; files != null && i < files.length; ++i) {
                if (this.deleteFile(files[i])) continue;
                ok = false;
            }
            if (!f.delete()) {
                ok = false;
                this._context.log("Unable to delete dir " + f.getAbsolutePath());
            }
            return ok;
        }
        return true;
    }
}

