/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.maven.mercury.crypto.api.StreamObserverException;
import org.apache.maven.mercury.crypto.api.StreamObserverFactory;
import org.apache.maven.mercury.crypto.api.StreamVerifier;
import org.apache.maven.mercury.crypto.api.StreamVerifierAttributes;
import org.apache.maven.mercury.crypto.api.StreamVerifierException;
import org.apache.maven.mercury.crypto.api.StreamVerifierFactory;
import org.apache.maven.mercury.crypto.pgp.PgpStreamVerifierFactory;
import org.apache.maven.mercury.crypto.sha.SHA1VerifierFactory;
import org.apache.maven.mercury.logging.IMercuryLogger;
import org.apache.maven.mercury.logging.MercuryLoggerManager;
import org.apache.maven.mercury.util.FileLockBundle;
import org.apache.maven.mercury.util.FileUtilException;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static final String SEP = "/";
    public static final char SEP_CHAR = "/".charAt(0);
    public static final String DASH = "-";
    public static final char DASH_CHAR = "-".charAt(0);
    public static final String LOCK_FILE = ".lock";
    public static final String DEFAULT_CHARSET = "utf-8";
    public static final int K = 1024;
    public static final int DEFAULT_BUFFER_SIZE = 10240;
    private static final IMercuryLogger _log = MercuryLoggerManager.getLogger(FileUtil.class);
    private static final Language _lang = new DefaultLanguage(FileUtil.class);
    private static final OverlappingFileLockException FILE_LOCKED = new OverlappingFileLockException();

    public static void delete(File f) {
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            File[] kids;
            for (File kid : kids = f.listFiles()) {
                FileUtil.delete(kid);
            }
        }
        f.delete();
    }

    public static void copy(File fromFile, File toFile, boolean clean) throws IOException {
        if (toFile.exists() && clean) {
            FileUtil.delete(toFile);
        }
        if (fromFile.isFile()) {
            FileUtil.copyFile(fromFile, toFile);
            return;
        }
        File[] kids = fromFile.listFiles();
        if (kids != null) {
            for (File kid : kids) {
                if (kid.isDirectory()) {
                    File newDir = new File(toFile, kid.getName());
                    newDir.mkdirs();
                    FileUtil.copy(kid, newDir, false);
                    continue;
                }
                FileUtil.copyFile(kid, toFile);
            }
        }
    }

    private static void copyFile(File f, File toFile) throws IOException {
        File fOut = null;
        fOut = toFile.isDirectory() ? new File(toFile, f.getName()) : toFile;
        FileInputStream fis = new FileInputStream(f);
        FileUtil.writeRawData(fOut, fis);
    }

    public static String readRawDataAsString(File file) throws IOException {
        return new String(FileUtil.readRawData(file), DEFAULT_CHARSET);
    }

    public static byte[] readRawData(File file) throws IOException {
        byte[] byArray;
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            int len = (int)file.length();
            if (len == 0) {
                _log.info(_lang.getMessage("reading.empty.file", new String[]{file.getAbsolutePath()}));
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] pom = new byte[len];
            while (fis.available() < 1) {
                try {
                    Thread.sleep(8L);
                }
                catch (InterruptedException e) {}
            }
            fis.read(pom, 0, len);
            byArray = pom;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception any) {}
            }
        }
        return byArray;
    }

    public static byte[] readRawData(File file, Collection<StreamVerifierFactory> vFacs) throws IOException, FileUtilException, StreamVerifierException {
        if (file == null || !file.exists()) {
            return null;
        }
        boolean verify = vFacs != null && vFacs.size() > 0;
        String fileName = file.getAbsolutePath();
        HashSet<StreamVerifier> vs = new HashSet<StreamVerifier>(verify ? vFacs.size() : 1);
        for (StreamVerifierFactory svf : vFacs) {
            StreamVerifier sv = svf.newInstance();
            String ext = sv.getAttributes().getExtension();
            String sigFileName = fileName + (ext.startsWith(".") ? "" : ".") + ext;
            File sigFile = new File(sigFileName);
            if (sigFile.exists()) {
                try {
                    sv.initSignature(FileUtil.readRawDataAsString(sigFile));
                }
                catch (IOException e) {
                    throw new FileUtilException(_lang.getMessage("cannot.read.signature.file", new String[]{sigFileName, e.getMessage()}));
                }
                vs.add(sv);
                continue;
            }
            if (sv.getAttributes().isLenient()) continue;
            throw new FileUtilException(_lang.getMessage("no.signature.file", new String[]{ext, sigFileName}));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            byte[] buf = new byte[10240];
            int n = -1;
            while ((n = fin.read(buf)) != -1) {
                if (verify) {
                    for (StreamVerifier sv : vs) {
                        try {
                            sv.bytesReady(buf, 0, n);
                        }
                        catch (StreamObserverException e) {
                            if (sv.getAttributes().isLenient()) continue;
                            throw new FileUtilException(e);
                        }
                    }
                }
                baos.write(buf, 0, n);
            }
            if (verify) {
                for (StreamVerifier sv : vs) {
                    if (sv.verifySignature()) {
                        if (!sv.getAttributes().isSufficient()) continue;
                        break;
                    }
                    if (sv.getAttributes().isLenient()) continue;
                    throw new StreamVerifierException(_lang.getMessage("signature.failed", new String[]{sv.getAttributes().getExtension(), fileName}));
                }
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new FileUtilException(e);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception any) {}
            }
        }
    }

    public static byte[] readRawData(InputStream in) throws IOException {
        byte[] bytes = new byte[10240];
        int n = -1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((n = in.read(bytes)) != -1) {
            baos.write(bytes, 0, n);
        }
        return baos.toByteArray();
    }

    public static void writeRawData(File file, String sBytes) throws IOException {
        FileUtil.writeRawData(file, sBytes.getBytes(DEFAULT_CHARSET));
    }

    public static void writeRawData(File f, InputStream in) throws IOException {
        int n;
        FileOutputStream out = new FileOutputStream(f);
        byte[] buf = new byte[10240];
        while ((n = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, n);
        }
        in.close();
        out.flush();
        ((OutputStream)out).close();
    }

    public static void writeRawData(File file, byte[] bytes) throws IOException {
        File parentDir;
        if (file.exists()) {
            file.delete();
        }
        if (!(parentDir = file.getParentFile()).exists()) {
            parentDir.mkdirs();
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception any) {}
            }
        }
    }

    public static void writeAndSign(String fName, byte[] bytes, Set<StreamVerifierFactory> vFacs) throws IOException, StreamObserverException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        FileUtil.writeAndSign(fName, bais, vFacs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAndSign(String fName, InputStream in, Set<StreamVerifierFactory> vFacs) throws IOException, StreamObserverException {
        byte[] buf = new byte[10240];
        int n = -1;
        HashSet<StreamVerifier> vSet = new HashSet<StreamVerifier>(vFacs.size());
        for (StreamVerifierFactory vf : vFacs) {
            vSet.add(vf.newInstance());
        }
        FileOutputStream fout = null;
        try {
            File f = new File(fName);
            f.getParentFile().mkdirs();
            fout = new FileOutputStream(f);
            while ((n = in.read(buf)) != -1) {
                for (StreamVerifier sv : vSet) {
                    sv.bytesReady(buf, 0, n);
                }
                fout.write(buf, 0, n);
            }
            fout.flush();
            fout.close();
            fout = null;
            for (StreamVerifier sv : vSet) {
                String sig = sv.getSignature();
                FileUtil.writeRawData(new File(fName + sv.getAttributes().getExtension()), sig);
            }
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception any) {}
            }
        }
    }

    public List<String> dirToList(File dir, boolean includeDirs, boolean includeFiles) {
        if (!dir.exists()) {
            return null;
        }
        File[] files = dir.listFiles();
        ArrayList<String> res = new ArrayList<String>(files.length);
        for (File f : files) {
            if (f.isDirectory()) {
                if (!includeDirs) continue;
                res.add(f.getName());
                continue;
            }
            if (!includeFiles) continue;
            res.add(f.getName());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sign(File f, Set<StreamVerifierFactory> vFacs, boolean recurse, boolean force) throws IOException, StreamObserverException {
        if (vFacs == null || vFacs.size() < 1) {
            return;
        }
        if (f.isDirectory()) {
            File[] kids;
            if (!recurse) {
                return;
            }
            for (File kid : kids = f.listFiles()) {
                FileUtil.sign(kid, vFacs, recurse, force);
            }
            return;
        }
        String fName = f.getAbsolutePath();
        HashSet<StreamVerifier> vs = new HashSet<StreamVerifier>(vFacs.size());
        for (StreamVerifierFactory vf : vFacs) {
            StreamVerifier sv = vf.newInstance();
            String ext = sv.getAttributes().getExtension();
            if (fName.endsWith(ext)) {
                return;
            }
            File sf = new File(fName + ext);
            if (sf.exists()) {
                if (!force) continue;
                sf.delete();
            }
            vs.add(sv);
        }
        byte[] buf = new byte[10240];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            int n = -1;
            while ((n = fis.read(buf)) != -1) {
                for (StreamVerifier sv : vs) {
                    sv.bytesReady(buf, 0, n);
                }
            }
            for (StreamVerifier sv : vs) {
                String sig = sv.getSignature();
                String ext = sv.getAttributes().getExtension();
                File sf = new File(fName + ext);
                FileUtil.writeRawData(sf, sig);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception any) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verify(File f, Set<StreamVerifierFactory> vFacs, boolean recurse, boolean force) throws IOException, StreamObserverException {
        if (vFacs == null || vFacs.size() < 1) {
            return;
        }
        if (f.isDirectory()) {
            File[] kids;
            if (!recurse) {
                return;
            }
            for (File kid : kids = f.listFiles()) {
                FileUtil.verify(kid, vFacs, recurse, force);
            }
            return;
        }
        String fName = f.getAbsolutePath();
        HashSet<StreamVerifier> vs = new HashSet<StreamVerifier>(vFacs.size());
        for (StreamVerifierFactory vf : vFacs) {
            StreamVerifier sv = vf.newInstance();
            String ext = sv.getAttributes().getExtension();
            if (fName.endsWith(ext)) {
                return;
            }
            File sf = new File(fName + ext);
            if (!sf.exists()) {
                if (!force) continue;
                throw new StreamVerifierException(_lang.getMessage("no.mandatory.signature", new String[]{f.getAbsolutePath(), sf.getAbsolutePath()}));
            }
            String sig = FileUtil.readRawDataAsString(sf);
            sv.initSignature(sig);
            vs.add(sv);
        }
        byte[] buf = new byte[10240];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            int n = -1;
            while ((n = fis.read(buf)) != -1) {
                for (StreamVerifier sv : vs) {
                    sv.bytesReady(buf, 0, n);
                }
            }
            ArrayList<String> fl = null;
            int comma = 32;
            for (StreamVerifier sv : vs) {
                if (sv.verifySignature()) continue;
                if (fl == null) {
                    fl = new ArrayList<String>(4);
                }
                fl.add(sv.getAttributes().getExtension().replace('.', (char)comma));
                comma = 44;
            }
            if (fl != null) {
                throw new StreamVerifierException(_lang.getMessage("file.failed.verification", new String[]{f.getAbsolutePath(), ((Object)fl).toString()}));
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception any) {}
            }
        }
    }

    public static void main(String[] args) throws IOException, StreamObserverException {
        Option sign = new Option("sign", _lang.getMessage("option.sign", new String[0]));
        Option verify = new Option("verify", _lang.getMessage("option.verify", new String[0]));
        OptionGroup cmd = new OptionGroup();
        cmd.addOption(sign);
        cmd.addOption(verify);
        Option recurce = new Option("r", _lang.getMessage("option.r", new String[0]));
        Option force = new Option("force", _lang.getMessage("option.force", new String[0]));
        OptionGroup sig = new OptionGroup();
        Option sha1 = new Option("sha1", _lang.getMessage("option.sha1", new String[0]));
        Option pgp = new Option("pgp", _lang.getMessage("option.pgp", new String[0]));
        sig.addOption(sha1);
        sig.addOption(pgp);
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withType(File.class);
        OptionBuilder.withDescription((String)_lang.getMessage("option.keyring", new String[0]));
        Option keyring = OptionBuilder.create((String)"keyring");
        OptionBuilder.withArgName((String)"hexstring");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)_lang.getMessage("option.keyid", new String[0]));
        Option keyid = OptionBuilder.create((String)"keyid");
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)_lang.getMessage("option.keypass", new String[0]));
        Option keypass = OptionBuilder.create((String)"keypass");
        Options options = new Options();
        options.addOptionGroup(cmd);
        options.addOptionGroup(sig);
        options.addOption(recurce);
        options.addOption(force);
        options.addOption(keyring);
        options.addOption(keyid);
        options.addOption(keypass);
        CommandLine commandLine = null;
        GnuParser parser = new GnuParser();
        if (args == null || args.length < 2) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("mercury-util", options);
            return;
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("Command line parsing eror: " + e.getMessage());
            return;
        }
        HashSet<StreamVerifierFactory> vFacs = new HashSet<StreamVerifierFactory>(4);
        if (commandLine.hasOption("pgp")) {
            if (commandLine.hasOption("sign") && commandLine.hasOption("keyring") && commandLine.hasOption("keyid")) {
                BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                String pass = commandLine.hasOption("keypass") ? commandLine.getOptionValue("keypass") : r.readLine();
                vFacs.add((StreamVerifierFactory)new PgpStreamVerifierFactory(new StreamVerifierAttributes("asc", false, true), (InputStream)new FileInputStream(commandLine.getOptionValue("keyring")), commandLine.getOptionValue("keyid"), pass));
            } else if (commandLine.hasOption("verify") && commandLine.hasOption("keyring")) {
                vFacs.add((StreamVerifierFactory)new PgpStreamVerifierFactory(new StreamVerifierAttributes("asc", false, true), (InputStream)new FileInputStream(commandLine.getOptionValue("keyring"))));
            } else {
                System.err.println(_lang.getMessage("bad.pgp.args", new String[0]));
                return;
            }
        }
        if (commandLine.hasOption("sha1")) {
            vFacs.add((StreamVerifierFactory)new SHA1VerifierFactory(true, false));
        }
        try {
            FileUtil.signAll(commandLine.getArgList(), vFacs, commandLine.hasOption("r"), commandLine.hasOption("force"), commandLine.hasOption("sign"));
        }
        catch (Exception e) {
            System.err.println("Bummer: " + e.getMessage());
            return;
        }
        System.out.println("Done");
    }

    private static void signAll(List<String> fileNames, Set<StreamVerifierFactory> vFacs, boolean recurse, boolean force, boolean sign) throws IOException, StreamObserverException {
        if (vFacs == null || vFacs.size() < 1) {
            System.err.println("no.verifiers");
            return;
        }
        File f = null;
        for (String fName : fileNames) {
            f = new File(fName);
            if (!f.exists()) {
                System.out.println(_lang.getMessage("file.not.exists", new String[]{fName}));
                continue;
            }
            if (f.isDirectory() && !recurse) {
                System.out.println(_lang.getMessage("file.is.directory", new String[]{fName}));
                continue;
            }
            if (sign) {
                FileUtil.sign(f, vFacs, recurse, force);
                continue;
            }
            FileUtil.verify(f, vFacs, recurse, force);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static FileLockBundle lockDir(String dir, long millis, long sleepFor) throws IOException {
        long start;
        File df = new File(dir);
        boolean exists = df.exists();
        for (int i = 0; i < 10 && !exists; ++i) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            df.mkdirs();
            exists = df.exists();
            _log.info(_lang.getMessage("had.to.create.directory", new String[]{dir, exists + ""}));
        }
        if (!exists) {
            throw new IOException(_lang.getMessage("cannot.create.directory", new String[]{dir}));
        }
        if (!df.isDirectory()) {
            throw new IOException(_lang.getMessage("file.is.not.directory", new String[]{dir, df.exists() + "", df.isDirectory() + "", df.isFile() + ""}));
        }
        File lockFile = new File(dir, LOCK_FILE);
        long now = start = System.currentTimeMillis();
        while (now - start < millis) {
            try {
                Class<FileUtil> clazz = FileUtil.class;
                // MONITORENTER : org.apache.maven.mercury.util.FileUtil.class
                if (!lockFile.exists()) {
                    FileUtil.writeRawData(lockFile, "lock");
                    lockFile.deleteOnExit();
                    // MONITOREXIT : clazz
                    return new FileLockBundle(dir);
                }
                // MONITOREXIT : clazz
                Thread.sleep(sleepFor);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
        return null;
    }

    public static FileLockBundle lockDirNio(String dir, long millis, long sleepFor) throws IOException {
        File df = new File(dir);
        boolean exists = df.exists();
        for (int i = 0; i < 10 && !exists; ++i) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            df.mkdirs();
            exists = df.exists();
            _log.info(_lang.getMessage("had.to.create.directory", new String[]{dir, exists + ""}));
        }
        if (!exists) {
            throw new IOException(_lang.getMessage("cannot.create.directory", new String[]{dir}));
        }
        if (!df.isDirectory()) {
            throw new IOException(_lang.getMessage("file.is.not.directory", new String[]{dir, df.exists() + "", df.isDirectory() + "", df.isFile() + ""}));
        }
        File lockFile = new File(dir, LOCK_FILE);
        if (!lockFile.exists()) {
            FileUtil.writeRawData(lockFile, "lock");
        }
        lockFile.deleteOnExit();
        FileChannel ch = new RandomAccessFile(lockFile, "rw").getChannel();
        FileLock lock = null;
        long start = System.currentTimeMillis();
        while (true) {
            try {
                lock = ch.tryLock(0L, 4L, false);
                if (lock == null) {
                    throw FILE_LOCKED;
                }
                return new FileLockBundle(dir, ch, lock);
            }
            catch (OverlappingFileLockException oe) {
                try {
                    Thread.sleep(sleepFor);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - start <= millis) continue;
                return null;
            }
            break;
        }
    }

    public static synchronized void unlockDir(String dir) {
        try {
            File df = new File(dir);
            if (!df.isDirectory()) {
                throw new IOException(_lang.getMessage("file.is.not.directory", new String[]{dir}));
            }
            File lock = new File(dir, LOCK_FILE);
            if (lock.exists()) {
                lock.delete();
            }
        }
        catch (IOException e) {
            _log.error(e.getMessage());
        }
    }

    public static final Set<StreamVerifierFactory> vSet(StreamVerifierFactory ... facs) {
        if (facs == null || facs.length < 1) {
            return null;
        }
        HashSet<StreamVerifierFactory> res = new HashSet<StreamVerifierFactory>(facs.length);
        for (StreamVerifierFactory f : facs) {
            res.add(f);
        }
        return res;
    }

    public static final Set<StreamObserverFactory> oSet(StreamObserverFactory ... facs) {
        if (facs == null || facs.length < 1) {
            return null;
        }
        HashSet<StreamObserverFactory> res = new HashSet<StreamObserverFactory>(facs.length);
        for (StreamObserverFactory f : facs) {
            res.add(f);
        }
        return res;
    }

    public static void renameFile(File dir, String from, String to) {
        if (dir == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length < 1) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                FileUtil.renameFile(f, from, to);
                continue;
            }
            if (!from.equals(f.getName())) continue;
            f.renameTo(new File(f.getParent(), to));
        }
    }

    public static int depth(File file) {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException(_lang.getMessage("file.not.exists.error", new String[]{file == null ? "null" : file.getAbsolutePath()}));
        }
        if (file.isFile()) {
            return 0;
        }
        File[] files = file.listFiles();
        int max = 0;
        for (File f : files) {
            int res;
            if (!f.isDirectory() || (res = FileUtil.depth(f)) <= max) continue;
            max = res;
        }
        return max + 1;
    }
}

