/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.AbstractAssemblyMojo;
import org.apache.maven.plugin.assembly.repository.RepositoryAssemblyException;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public abstract class AbstractDirectoryMojo
extends AbstractAssemblyMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        List assemblies = this.readAssemblies();
        Iterator i = assemblies.iterator();
        while (i.hasNext()) {
            Assembly assembly = (Assembly)i.next();
            this.createDirectory(assembly);
        }
    }

    private void createDirectory(Assembly assembly) throws MojoExecutionException, MojoFailureException {
        String fullName = this.finalName;
        if (this.appendAssemblyId) {
            fullName = fullName + "-" + assembly.getId();
        } else if (this.getClassifier() != null) {
            fullName = fullName + "-" + this.getClassifier();
        }
        try {
            Archiver archiver = this.archiverManager.getArchiver("dir");
            this.createArchive(archiver, assembly, fullName);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Error creating assembly", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error creating assembly", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating assembly", (Exception)e);
        }
        catch (RepositoryAssemblyException e) {
            throw new MojoExecutionException("Error creating assembly: " + e.getMessage(), (Exception)e);
        }
    }
}

