/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ComponentsXmlArchiverFileFilter {
    private Map components;
    public static final String COMPONENTS_XML_PATH = "META-INF/plexus/components.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponentsXml(File componentsXml) throws IOException, XmlPullParserException {
        Xpp3Dom newDom;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(componentsXml);
            newDom = Xpp3DomBuilder.build((Reader)fileReader);
        }
        catch (Throwable throwable) {
            IOUtil.close(fileReader);
            throw throwable;
        }
        IOUtil.close((Reader)fileReader);
        if (newDom != null) {
            newDom = newDom.getChild("components");
        }
        if (newDom != null) {
            Xpp3Dom[] children = newDom.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Xpp3Dom component = children[i];
                if (this.components == null) {
                    this.components = new LinkedHashMap();
                }
                String role = component.getChild("role").getValue();
                Xpp3Dom child = component.getChild("role-hint");
                String roleHint = child != null ? child.getValue() : "";
                this.components.put(role + roleHint, component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToArchive(Archiver archiver) throws IOException, ArchiverException {
        if (this.components != null) {
            File f = File.createTempFile("maven-assembly-plugin", "tmp");
            f.deleteOnExit();
            FileWriter fileWriter = new FileWriter(f);
            try {
                Xpp3Dom dom = new Xpp3Dom("component-set");
                Xpp3Dom componentDom = new Xpp3Dom("components");
                dom.addChild(componentDom);
                Iterator i = this.components.values().iterator();
                while (i.hasNext()) {
                    Xpp3Dom component = (Xpp3Dom)i.next();
                    componentDom.addChild(component);
                }
                Xpp3DomWriter.write((Writer)fileWriter, (Xpp3Dom)dom);
            }
            finally {
                IOUtil.close((Writer)fileWriter);
            }
            archiver.addFile(f, COMPONENTS_XML_PATH);
        }
    }
}

