/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.filter;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

public class AssemblyIncludesArtifactFilter
implements ArtifactFilter {
    private final List patterns;

    public AssemblyIncludesArtifactFilter(List patterns) {
        this.patterns = Collections.unmodifiableList(patterns);
    }

    public boolean include(Artifact artifact) {
        String shortId = artifact.getGroupId() + ":" + artifact.getArtifactId();
        String id = artifact.getDependencyConflictId();
        boolean matched = false;
        Iterator i = this.patterns.iterator();
        while (i.hasNext() && !matched) {
            String pattern = (String)i.next();
            if (id.equals(pattern)) {
                matched = true;
                continue;
            }
            if (!shortId.equals(pattern)) continue;
            matched = true;
        }
        return matched;
    }
}

