/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.plugin.DebugConfigurationListener;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.AssemblyContext;
import org.apache.maven.plugin.assembly.DefaultAssemblyContext;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugin.assembly.archive.ManifestCreationFinalizer;
import org.apache.maven.plugin.assembly.archive.archiver.AssemblyProxyArchiver;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.artifact.DependencyResolver;
import org.apache.maven.plugin.assembly.filter.ComponentsXmlArchiverFileFilter;
import org.apache.maven.plugin.assembly.filter.ContainerDescriptorHandler;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.interpolation.AssemblyExpressionEvaluator;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.filters.JarSecurityFileSelector;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.collections.ActiveCollectionManager;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultAssemblyArchiver
extends AbstractLogEnabled
implements AssemblyArchiver,
Contextualizable {
    private ArchiverManager archiverManager;
    private List assemblyPhases;
    private Map containerDescriptorHandlers;
    private DependencyResolver dependencyResolver;
    private PlexusContainer container;

    public DefaultAssemblyArchiver() {
    }

    protected DefaultAssemblyArchiver(ArchiverManager archiverManager, ActiveCollectionManager collectionManager, DependencyResolver resolver, List assemblyPhases) {
        this.archiverManager = archiverManager;
        this.dependencyResolver = resolver;
        this.assemblyPhases = assemblyPhases;
    }

    public File createArchive(Assembly assembly, String fullName, String format, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        String filename = fullName;
        if (!configSource.isIgnoreDirFormatExtensions() || !format.startsWith("dir")) {
            filename = filename + "." + format;
        }
        AssemblyFileUtils.verifyTempDirectoryAvailability(configSource.getTemporaryRootDirectory(), this.getLogger());
        File outputDirectory = configSource.getOutputDirectory();
        File destFile = new File(outputDirectory, filename);
        try {
            String finalName = configSource.getFinalName();
            String specifiedBasedir = assembly.getBaseDirectory();
            String basedir = finalName;
            if (specifiedBasedir != null) {
                basedir = AssemblyFormatUtils.getOutputDirectory(specifiedBasedir, configSource.getProject(), null, finalName, configSource);
            }
            List containerHandlers = this.selectContainerDescriptorHandlers(assembly.getContainerDescriptorHandlers(), configSource);
            Archiver archiver = this.createArchiver(format, assembly.isIncludeBaseDirectory(), basedir, configSource, containerHandlers);
            archiver.setDestFile(destFile);
            Map managedVersionMap = this.dependencyResolver.buildManagedVersionMap(assembly, configSource);
            AssemblyContext context = new DefaultAssemblyContext().setManagedVersionMap(managedVersionMap);
            for (AssemblyArchiverPhase phase : this.assemblyPhases) {
                phase.execute(assembly, archiver, configSource, context);
            }
            archiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new ArchiveCreationException("Error creating assembly archive " + assembly.getId() + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ArchiveCreationException("Error creating assembly archive " + assembly.getId() + ": " + e.getMessage(), e);
        }
        catch (NoSuchArchiverException e) {
            throw new ArchiveCreationException("Unable to obtain archiver for extension '" + format + "'");
        }
        catch (ArtifactResolutionException e) {
            throw new ArchiveCreationException("Unable to create managed-version map for all assembly activities: " + e.getMessage(), e);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new ArchiveCreationException("Unable to create managed-version map for all assembly activities: " + e.getMessage(), e);
        }
        catch (InvalidDependencyVersionException e) {
            throw new ArchiveCreationException("Unable to create managed-version map for all assembly activities: " + e.getMessage(), e);
        }
        return destFile;
    }

    private List selectContainerDescriptorHandlers(List requestedContainerDescriptorHandlers, AssemblerConfigurationSource configSource) throws InvalidAssemblerConfigurationException {
        this.getLogger().debug("All known ContainerDescritporHandler components: " + (this.containerDescriptorHandlers == null ? "none; map is null." : "" + this.containerDescriptorHandlers.keySet()));
        if (requestedContainerDescriptorHandlers == null) {
            requestedContainerDescriptorHandlers = new ArrayList();
        }
        ArrayList<ContainerDescriptorHandler> handlers = new ArrayList<ContainerDescriptorHandler>();
        boolean foundPlexus = false;
        if (requestedContainerDescriptorHandlers != null && !requestedContainerDescriptorHandlers.isEmpty()) {
            for (ContainerDescriptorHandlerConfig config : requestedContainerDescriptorHandlers) {
                String hint = config.getHandlerName();
                ContainerDescriptorHandler handler = (ContainerDescriptorHandler)this.containerDescriptorHandlers.get(hint);
                if (handler == null) {
                    throw new InvalidAssemblerConfigurationException("Cannot find ContainerDescriptorHandler with hint: " + hint);
                }
                this.getLogger().debug("Found container descriptor handler with hint: " + hint + " (component: " + handler + ")");
                if (config.getConfiguration() != null) {
                    this.getLogger().debug("Configuring handler with:\n\n" + config.getConfiguration() + "\n\n");
                    this.configureContainerDescriptorHandler(handler, (Xpp3Dom)config.getConfiguration(), configSource);
                }
                handlers.add(handler);
                if (!"plexus".equals(hint)) continue;
                foundPlexus = true;
            }
        }
        if (!foundPlexus) {
            handlers.add(new ComponentsXmlArchiverFileFilter());
        }
        return handlers;
    }

    protected Archiver createArchiver(String format, boolean includeBaseDir, String finalName, AssemblerConfigurationSource configSource, List containerHandlers) throws ArchiverException, NoSuchArchiverException {
        Archiver archiver = format.startsWith("tar") ? this.createTarArchiver(format, configSource.getTarLongFileMode()) : ("war".equals(format) ? this.createWarArchiver() : this.archiverManager.getArchiver(format));
        List<JarSecurityFileSelector> extraSelectors = null;
        List<ManifestCreationFinalizer> extraFinalizers = null;
        if (archiver instanceof JarArchiver) {
            extraSelectors = Collections.singletonList(new JarSecurityFileSelector());
            extraFinalizers = Collections.singletonList(new ManifestCreationFinalizer(configSource.getProject(), configSource.getJarArchiveConfiguration()));
        }
        if (configSource.getArchiverConfig() != null) {
            this.configureArchiver(archiver, configSource);
        }
        String prefix = "";
        if (includeBaseDir) {
            prefix = finalName;
        }
        archiver = new AssemblyProxyArchiver(prefix, archiver, containerHandlers, extraSelectors, extraFinalizers, this.getLogger(), configSource.isDryRun());
        return archiver;
    }

    private void configureContainerDescriptorHandler(ContainerDescriptorHandler handler, Xpp3Dom config, AssemblerConfigurationSource configSource) throws InvalidAssemblerConfigurationException {
        this.getLogger().debug("Configuring handler: '" + handler.getClass().getName() + "' -->");
        try {
            this.configureComponent(handler, config, configSource);
        }
        catch (ComponentConfigurationException e) {
            throw new InvalidAssemblerConfigurationException("Failed to configure handler: " + handler.getClass().getName(), e);
        }
        catch (ComponentLookupException e) {
            throw new InvalidAssemblerConfigurationException("Failed to lookup configurator for setup of handler: " + handler.getClass().getName(), e);
        }
        this.getLogger().debug("-- end configuration --");
    }

    private void configureArchiver(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiverException {
        Xpp3Dom config;
        try {
            config = Xpp3DomBuilder.build((Reader)new StringReader(configSource.getArchiverConfig()));
        }
        catch (XmlPullParserException e) {
            throw new ArchiverException("Failed to parse archiver configuration for: " + archiver.getClass().getName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ArchiverException("Failed to parse archiver configuration for: " + archiver.getClass().getName(), (Throwable)e);
        }
        this.getLogger().debug("Configuring archiver: '" + archiver.getClass().getName() + "' -->");
        try {
            this.configureComponent(archiver, config, configSource);
        }
        catch (ComponentConfigurationException e) {
            throw new ArchiverException("Failed to configure archiver: " + archiver.getClass().getName(), (Throwable)e);
        }
        catch (ComponentLookupException e) {
            throw new ArchiverException("Failed to lookup configurator for setup of archiver: " + archiver.getClass().getName(), (Throwable)e);
        }
        this.getLogger().debug("-- end configuration --");
    }

    private void configureComponent(Object component, Xpp3Dom config, AssemblerConfigurationSource configSource) throws ComponentLookupException, ComponentConfigurationException {
        ComponentConfigurator configurator = (ComponentConfigurator)this.container.lookup(ComponentConfigurator.ROLE, "basic");
        DebugConfigurationListener listener = new DebugConfigurationListener(this.getLogger());
        AssemblyExpressionEvaluator expressionEvaluator = new AssemblyExpressionEvaluator(configSource);
        XmlPlexusConfiguration configuration = new XmlPlexusConfiguration(config);
        Object[] containerRealm = this.getContainerRealm();
        try {
            Method configureComponent = ComponentConfigurator.class.getMethod("configureComponent", Object.class, PlexusConfiguration.class, ExpressionEvaluator.class, (Class)containerRealm[1], ConfigurationListener.class);
            configureComponent.invoke((Object)configurator, component, configuration, expressionEvaluator, containerRealm[0], listener);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ComponentConfigurationException) {
                throw (ComponentConfigurationException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private Object[] getContainerRealm() {
        try {
            Method getContainerRealm = this.container.getClass().getMethod("getContainerRealm", null);
            return new Object[]{getContainerRealm.invoke((Object)this.container, null), getContainerRealm.getReturnType()};
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected Archiver createWarArchiver() throws NoSuchArchiverException {
        WarArchiver warArchiver = (WarArchiver)this.archiverManager.getArchiver("war");
        warArchiver.setIgnoreWebxml(false);
        return warArchiver;
    }

    protected Archiver createTarArchiver(String format, String tarLongFileMode) throws NoSuchArchiverException, ArchiverException {
        TarArchiver tarArchiver = (TarArchiver)this.archiverManager.getArchiver("tar");
        int index = format.indexOf(46);
        if (index >= 0) {
            TarArchiver.TarCompressionMethod tarCompressionMethod = new TarArchiver.TarCompressionMethod();
            String compression = format.substring(index + 1);
            if ("gz".equals(compression)) {
                tarCompressionMethod.setValue("gzip");
            } else if ("bz2".equals(compression)) {
                tarCompressionMethod.setValue("bzip2");
            } else {
                throw new IllegalArgumentException("Unknown compression format: " + compression);
            }
            tarArchiver.setCompression(tarCompressionMethod);
        }
        TarLongFileMode tarFileMode = new TarLongFileMode();
        tarFileMode.setValue(tarLongFileMode);
        tarArchiver.setLongfile(tarFileMode);
        return tarArchiver;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected void setContainer(PlexusContainer container) {
        this.container = container;
    }
}

