/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.task;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.task.AddArtifactTask;
import org.apache.maven.plugins.assembly.archive.task.ProjectBuildingRequestCreator;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.format.ReaderFormatter;
import org.apache.maven.plugins.assembly.model.DependencySet;
import org.apache.maven.plugins.assembly.model.UnpackOptions;
import org.apache.maven.plugins.assembly.utils.AssemblyFormatUtils;
import org.apache.maven.plugins.assembly.utils.FilterUtils;
import org.apache.maven.plugins.assembly.utils.TypeConversionUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.logging.Logger;

public class AddDependencySetsTask {
    private static final List<String> NON_ARCHIVE_DEPENDENCY_TYPES;
    private final List<DependencySet> dependencySets;
    private final Logger logger;
    private final MavenProject project;
    private final ProjectBuilder projectBuilder1;
    private final Set<Artifact> resolvedArtifacts;
    private MavenProject moduleProject;
    private String defaultOutputDirectory;
    private String defaultOutputFileNameMapping;
    private Artifact moduleArtifact;

    public AddDependencySetsTask(List<DependencySet> dependencySets, Set<Artifact> resolvedArtifacts, MavenProject project, ProjectBuilder projectBuilder, Logger logger) {
        this.dependencySets = dependencySets;
        this.resolvedArtifacts = resolvedArtifacts;
        this.project = project;
        this.projectBuilder1 = projectBuilder;
        this.logger = logger;
    }

    public void execute(Archiver archiver, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        if (this.dependencySets == null || this.dependencySets.isEmpty()) {
            this.logger.debug("No dependency sets specified.");
            return;
        }
        List deps = this.project.getDependencies();
        if (deps == null || deps.isEmpty()) {
            this.logger.debug("Project " + this.project.getId() + " has no dependencies. Skipping dependency set addition.");
        }
        for (DependencySet dependencySet : this.dependencySets) {
            this.addDependencySet(dependencySet, archiver, configSource);
        }
    }

    void addDependencySet(DependencySet dependencySet, Archiver archiver, AssemblerConfigurationSource configSource) throws AssemblyFormattingException, ArchiveCreationException, InvalidAssemblerConfigurationException {
        this.logger.debug("Processing DependencySet (output=" + dependencySet.getOutputDirectory() + ")");
        if (!dependencySet.isUseTransitiveDependencies() && dependencySet.isUseTransitiveFiltering()) {
            this.logger.warn("DependencySet has nonsensical configuration: useTransitiveDependencies == false AND useTransitiveFiltering == true. Transitive filtering flag will be ignored.");
        }
        Set<Artifact> dependencyArtifacts = this.resolveDependencyArtifacts(dependencySet);
        if (!this.unpackTransformsContent(dependencySet) && dependencyArtifacts.size() > 1) {
            this.checkMultiArtifactOutputConfig(dependencySet);
        }
        this.logger.debug("Adding " + dependencyArtifacts.size() + " dependency artifacts.");
        InputStreamTransformer fileSetTransformers = this.isUnpackWithOptions(dependencySet) ? ReaderFormatter.getFileSetTransformers(configSource, dependencySet.getUnpackOptions().isFiltered(), dependencySet.getUnpackOptions().getLineEnding()) : null;
        for (Artifact depArtifact : dependencyArtifacts) {
            MavenProject depProject;
            ProjectBuildingRequest pbr = this.getProjectBuildingRequest(configSource);
            try {
                ProjectBuildingResult build = this.projectBuilder1.build(depArtifact, pbr);
                depProject = build.getProject();
            }
            catch (ProjectBuildingException e) {
                this.logger.debug("Error retrieving POM of module-dependency: " + depArtifact.getId() + "; Reason: " + e.getMessage() + "\n\nBuilding stub project instance.");
                depProject = this.buildProjectStub(depArtifact);
            }
            if (NON_ARCHIVE_DEPENDENCY_TYPES.contains(depArtifact.getType())) {
                this.addNonArchiveDependency(depArtifact, depProject, dependencySet, archiver, configSource);
                continue;
            }
            this.addNormalArtifact(dependencySet, depArtifact, depProject, archiver, configSource, fileSetTransformers);
        }
    }

    private ProjectBuildingRequest getProjectBuildingRequest(AssemblerConfigurationSource configSource) {
        MavenSession session = configSource.getMavenSession();
        ProjectBuildingRequest pbr = ProjectBuildingRequestCreator.create(session);
        pbr.setRemoteRepositories(configSource.getRemoteRepositories());
        pbr.setLocalRepository(configSource.getLocalRepository());
        return pbr;
    }

    private boolean isUnpackWithOptions(DependencySet dependencySet) {
        return dependencySet.isUnpack() && dependencySet.getUnpackOptions() != null;
    }

    private boolean unpackTransformsContent(DependencySet dependencySet) {
        return this.isUnpackWithOptions(dependencySet) && this.isConentModifyingOption(dependencySet.getUnpackOptions());
    }

    private boolean isConentModifyingOption(UnpackOptions opts) {
        return opts.isFiltered() || opts.getLineEnding() != null;
    }

    private void checkMultiArtifactOutputConfig(DependencySet dependencySet) {
        String mapping;
        String dir = dependencySet.getOutputDirectory();
        if (dir == null) {
            dir = this.defaultOutputDirectory;
        }
        if ((mapping = dependencySet.getOutputFileNameMapping()) == null) {
            mapping = this.defaultOutputFileNameMapping;
        }
        if (!(dir != null && dir.contains("${") || mapping != null && mapping.contains("${"))) {
            this.logger.warn("NOTE: Your assembly specifies a dependencySet that matches multiple artifacts, but specifies a concrete output format. THIS MAY RESULT IN ONE OR MORE ARTIFACTS BEING OBSCURED!\n\nOutput directory: '" + dir + "'\nOutput filename mapping: '" + mapping + "'");
        }
    }

    private void addNormalArtifact(DependencySet dependencySet, Artifact depArtifact, MavenProject depProject, Archiver archiver, AssemblerConfigurationSource configSource, InputStreamTransformer fileSetTransformers) throws AssemblyFormattingException, ArchiveCreationException {
        int fileMode;
        this.logger.debug("Adding dependency artifact " + depArtifact.getId() + ".");
        String encoding = this.isUnpackWithOptions(dependencySet) ? dependencySet.getUnpackOptions().getEncoding() : null;
        Charset charset = encoding != null ? Charset.forName(encoding) : null;
        AddArtifactTask task = new AddArtifactTask(depArtifact, this.logger, fileSetTransformers, charset);
        task.setProject(depProject);
        task.setModuleProject(this.moduleProject);
        task.setModuleArtifact(this.moduleArtifact);
        task.setOutputDirectory(dependencySet.getOutputDirectory(), this.defaultOutputDirectory);
        task.setFileNameMapping(dependencySet.getOutputFileNameMapping(), this.defaultOutputFileNameMapping);
        int dirMode = TypeConversionUtils.modeToInt(dependencySet.getDirectoryMode(), this.logger);
        if (dirMode != -1) {
            task.setDirectoryMode(dirMode);
        }
        if ((fileMode = TypeConversionUtils.modeToInt(dependencySet.getFileMode(), this.logger)) != -1) {
            task.setFileMode(fileMode);
        }
        task.setUnpack(dependencySet.isUnpack());
        UnpackOptions opts = dependencySet.getUnpackOptions();
        if (this.isUnpackWithOptions(dependencySet)) {
            task.setIncludes(opts.getIncludes());
            task.setExcludes(opts.getExcludes());
        }
        task.execute(archiver, configSource);
    }

    private MavenProject buildProjectStub(Artifact depArtifact) {
        Model model = new Model();
        model.setGroupId(depArtifact.getGroupId());
        model.setArtifactId(depArtifact.getArtifactId());
        model.setVersion(depArtifact.getBaseVersion());
        model.setPackaging(depArtifact.getType());
        model.setDescription("Stub for " + depArtifact.getId());
        MavenProject project = new MavenProject(model);
        project.setArtifact(depArtifact);
        return project;
    }

    Set<Artifact> resolveDependencyArtifacts(DependencySet dependencySet) throws InvalidAssemblerConfigurationException {
        List attachments;
        LinkedHashSet<Artifact> dependencyArtifacts = new LinkedHashSet<Artifact>();
        if (this.resolvedArtifacts != null) {
            dependencyArtifacts.addAll(this.resolvedArtifacts);
        }
        if (dependencySet.isUseProjectArtifact()) {
            Artifact projectArtifact = this.project.getArtifact();
            if (projectArtifact != null && projectArtifact.getFile() != null) {
                dependencyArtifacts.add(projectArtifact);
            } else {
                this.logger.warn("Cannot include project artifact: " + projectArtifact + "; it doesn't have an associated file or directory.");
            }
        }
        if (dependencySet.isUseProjectAttachments() && (attachments = this.project.getAttachedArtifacts()) != null) {
            for (Artifact attachment : attachments) {
                if (attachment.getFile() != null) {
                    dependencyArtifacts.add(attachment);
                    continue;
                }
                this.logger.warn("Cannot include attached artifact: " + this.project.getId() + " for project: " + this.project.getId() + "; it doesn't have an associated file or directory.");
            }
        }
        if (dependencySet.isUseTransitiveFiltering()) {
            this.logger.debug("Filtering dependency artifacts USING transitive dependency path information.");
        } else {
            this.logger.debug("Filtering dependency artifacts WITHOUT transitive dependency path information.");
        }
        ScopeArtifactFilter filter = new ScopeArtifactFilter(dependencySet.getScope());
        FilterUtils.filterArtifacts(dependencyArtifacts, dependencySet.getIncludes(), dependencySet.getExcludes(), dependencySet.isUseStrictFiltering(), dependencySet.isUseTransitiveFiltering(), this.logger, new ArtifactFilter[]{filter});
        return dependencyArtifacts;
    }

    private void addNonArchiveDependency(Artifact depArtifact, MavenProject depProject, DependencySet dependencySet, Archiver archiver, AssemblerConfigurationSource configSource) throws AssemblyFormattingException, ArchiveCreationException {
        File source = depArtifact.getFile();
        String outputDirectory = dependencySet.getOutputDirectory();
        FixedStringSearchInterpolator moduleProjectInterpolator = AssemblyFormatUtils.moduleProjectInterpolator(this.moduleProject);
        FixedStringSearchInterpolator artifactProjectInterpolator = AssemblyFormatUtils.artifactProjectInterpolator(depProject);
        outputDirectory = AssemblyFormatUtils.getOutputDirectory(outputDirectory, depProject.getBuild().getFinalName(), configSource, moduleProjectInterpolator, artifactProjectInterpolator);
        String destName = AssemblyFormatUtils.evaluateFileNameMapping(dependencySet.getOutputFileNameMapping(), depArtifact, configSource.getProject(), this.moduleArtifact, configSource, moduleProjectInterpolator, artifactProjectInterpolator);
        String target = outputDirectory.endsWith("/") || outputDirectory.endsWith("\\") ? outputDirectory + destName : outputDirectory + "/" + destName;
        try {
            int mode = TypeConversionUtils.modeToInt(dependencySet.getFileMode(), this.logger);
            if (mode > -1) {
                archiver.addFile(source, target, mode);
            } else {
                archiver.addFile(source, target);
            }
        }
        catch (ArchiverException e) {
            throw new ArchiveCreationException("Error adding file to archive: " + e.getMessage(), e);
        }
    }

    public List<DependencySet> getDependencySets() {
        return this.dependencySets;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setDefaultOutputDirectory(String defaultOutputDirectory) {
        this.defaultOutputDirectory = defaultOutputDirectory;
    }

    public void setDefaultOutputFileNameMapping(String defaultOutputFileNameMapping) {
        this.defaultOutputFileNameMapping = defaultOutputFileNameMapping;
    }

    public void setModuleProject(MavenProject moduleProject) {
        this.moduleProject = moduleProject;
    }

    public void setModuleArtifact(Artifact moduleArtifact) {
        this.moduleArtifact = moduleArtifact;
    }

    static {
        ArrayList<String> nonArch = new ArrayList<String>();
        nonArch.add("pom");
        NON_ARCHIVE_DEPENDENCY_TYPES = Collections.unmodifiableList(nonArch);
    }
}

