/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.archive.task;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;

public class ProjectBuildingRequestCreator {
    static final Class AETHER = ProjectBuildingRequestCreator.tryLoadClass("org.sonatype.aether.RepositorySystemSession");
    static final Class ECLIPSE = ProjectBuildingRequestCreator.tryLoadClass("org.eclipse.aether.RepositorySystemSession");

    public static ProjectBuildingRequest create(MavenSession session) {
        DefaultProjectBuildingRequest projectBuildingRequest1 = new DefaultProjectBuildingRequest();
        Object repositorySession = ProjectBuildingRequestCreator.invoke(session, "getRepositorySession");
        Method setRepositorySession = ProjectBuildingRequestCreator.getMethod(projectBuildingRequest1.getClass(), "setRepositorySession", ECLIPSE != null ? ECLIPSE : AETHER);
        ProjectBuildingRequestCreator.invoke(setRepositorySession, projectBuildingRequest1, repositorySession);
        ProjectBuildingRequestCreator.injectSession((ProjectBuildingRequest)projectBuildingRequest1, session);
        return projectBuildingRequest1;
    }

    private static void injectSession(ProjectBuildingRequest request, MavenSession session) {
        request.setSystemProperties(session.getSystemProperties());
        if (request.getUserProperties().isEmpty()) {
            request.setUserProperties(session.getUserProperties());
        }
    }

    private static Class tryLoadClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Object invoke(Object object, String method) throws RuntimeException {
        try {
            return object.getClass().getMethod(method, new Class[0]).invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Method getMethod(Class<?> objectClazz, String method, Class<?> ... params) throws RuntimeException {
        try {
            return objectClazz.getMethod(method, params);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Object invoke(Method method, Object object, Object ... args) throws RuntimeException {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

