/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.5.1,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.plugins.assembly.model;

/**
 * 
 *       Specifies options for including/excluding/filtering items
 * extracted from an archive. (Since 2.2)
 *       .
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class UnpackOptions
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field includes.
     */
    private java.util.List<String> includes;

    /**
     * Field excludes.
     */
    private java.util.List<String> excludes;

    /**
     * 
     *           Whether to filter symbols in the files as they are
     * unpacked from the archive, using
     *           properties from the build configuration. (Since
     * 2.2)
     *           .
     */
    private boolean filtered = false;

    /**
     * Field nonFilteredFileExtensions.
     */
    private java.util.List<String> nonFilteredFileExtensions;

    /**
     * 
     *             
     *             Sets the line-endings of the files. (Since 2.2)
     *             Valid values:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     *             
     *           
     */
    private String lineEnding;

    /**
     * 
     *             Whether standard exclusion patterns, such as
     * those matching CVS and Subversion
     *             metadata files, should be used when calculating
     * the files affected by this set.
     *             For backward compatibility, the default value is
     * true. (Since 2.2)
     *           .
     */
    private boolean useDefaultExcludes = true;

    /**
     * 
     *               
     *               Allows to specify the encoding to use when
     * unpacking archives, for unarchivers
     *               that support specifying encoding. If
     * unspecified, archiver default will be used.
     *               Archiver defaults generally represent sane
     * (modern) values.
     *               
     *             
     */
    private String encoding;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addExclude.
     * 
     * @param string a string object.
     */
    public void addExclude( String string )
    {
        getExcludes().add( string );
    } //-- void addExclude( String )

    /**
     * Method addInclude.
     * 
     * @param string a string object.
     */
    public void addInclude( String string )
    {
        getIncludes().add( string );
    } //-- void addInclude( String )

    /**
     * Method addNonFilteredFileExtension.
     * 
     * @param string a string object.
     */
    public void addNonFilteredFileExtension( String string )
    {
        getNonFilteredFileExtensions().add( string );
    } //-- void addNonFilteredFileExtension( String )

    /**
     * Get allows to specify the encoding to use when unpacking
     * archives, for unarchivers
     *               that support specifying encoding. If
     * unspecified, archiver default will be used.
     *               Archiver defaults generally represent sane
     * (modern) values.
     * 
     * @return String
     */
    public String getEncoding()
    {
        return this.encoding;
    } //-- String getEncoding()

    /**
     * Method getExcludes.
     * 
     * @return List
     */
    public java.util.List<String> getExcludes()
    {
        if ( this.excludes == null )
        {
            this.excludes = new java.util.ArrayList<String>();
        }

        return this.excludes;
    } //-- java.util.List<String> getExcludes()

    /**
     * Method getIncludes.
     * 
     * @return List
     */
    public java.util.List<String> getIncludes()
    {
        if ( this.includes == null )
        {
            this.includes = new java.util.ArrayList<String>();
        }

        return this.includes;
    } //-- java.util.List<String> getIncludes()

    /**
     * Get sets the line-endings of the files. (Since 2.2)
     *             Valid values:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     * 
     * @return String
     */
    public String getLineEnding()
    {
        return this.lineEnding;
    } //-- String getLineEnding()

    /**
     * Method getNonFilteredFileExtensions.
     * 
     * @return List
     */
    public java.util.List<String> getNonFilteredFileExtensions()
    {
        if ( this.nonFilteredFileExtensions == null )
        {
            this.nonFilteredFileExtensions = new java.util.ArrayList<String>();
        }

        return this.nonFilteredFileExtensions;
    } //-- java.util.List<String> getNonFilteredFileExtensions()

    /**
     * Get whether to filter symbols in the files as they are
     * unpacked from the archive, using
     *           properties from the build configuration. (Since
     * 2.2).
     * 
     * @return boolean
     */
    public boolean isFiltered()
    {
        return this.filtered;
    } //-- boolean isFiltered()

    /**
     * Get whether standard exclusion patterns, such as those
     * matching CVS and Subversion
     *             metadata files, should be used when calculating
     * the files affected by this set.
     *             For backward compatibility, the default value is
     * true. (Since 2.2).
     * 
     * @return boolean
     */
    public boolean isUseDefaultExcludes()
    {
        return this.useDefaultExcludes;
    } //-- boolean isUseDefaultExcludes()

    /**
     * Method removeExclude.
     * 
     * @param string a string object.
     */
    public void removeExclude( String string )
    {
        getExcludes().remove( string );
    } //-- void removeExclude( String )

    /**
     * Method removeInclude.
     * 
     * @param string a string object.
     */
    public void removeInclude( String string )
    {
        getIncludes().remove( string );
    } //-- void removeInclude( String )

    /**
     * Method removeNonFilteredFileExtension.
     * 
     * @param string a string object.
     */
    public void removeNonFilteredFileExtension( String string )
    {
        getNonFilteredFileExtensions().remove( string );
    } //-- void removeNonFilteredFileExtension( String )

    /**
     * Set allows to specify the encoding to use when unpacking
     * archives, for unarchivers
     *               that support specifying encoding. If
     * unspecified, archiver default will be used.
     *               Archiver defaults generally represent sane
     * (modern) values.
     * 
     * @param encoding a encoding object.
     */
    public void setEncoding( String encoding )
    {
        this.encoding = encoding;
    } //-- void setEncoding( String )

    /**
     * Set set of file and/or directory patterns for matching items
     * to be excluded from an archive as it is unpacked.
     *             Each item is specified as
     * &lt;exclude&gt;some/path&lt;/exclude&gt; (Since 2.2).
     * 
     * @param excludes a excludes object.
     */
    public void setExcludes( java.util.List<String> excludes )
    {
        this.excludes = excludes;
    } //-- void setExcludes( java.util.List )

    /**
     * Set whether to filter symbols in the files as they are
     * unpacked from the archive, using
     *           properties from the build configuration. (Since
     * 2.2).
     * 
     * @param filtered a filtered object.
     */
    public void setFiltered( boolean filtered )
    {
        this.filtered = filtered;
    } //-- void setFiltered( boolean )

    /**
     * Set set of file and/or directory patterns for matching items
     * to be included from an archive as it is unpacked.
     *             Each item is specified as
     * &lt;include&gt;some/path&lt;/include&gt; (Since 2.2).
     * 
     * @param includes a includes object.
     */
    public void setIncludes( java.util.List<String> includes )
    {
        this.includes = includes;
    } //-- void setIncludes( java.util.List )

    /**
     * Set sets the line-endings of the files. (Since 2.2)
     *             Valid values:
     *             <ul>
     *               <li><b>"keep"</b> - Preserve all line
     * endings</li>
     *               <li><b>"unix"</b> - Use Unix-style line
     * endings</li>
     *               <li><b>"lf"</b> - Use a single line-feed line
     * endings</li>
     *               <li><b>"dos"</b> - Use DOS-style line
     * endings</li>
     *               <li><b>"crlf"</b> - Use Carraige-return,
     * line-feed line endings</li>
     *             </ul>
     * 
     * @param lineEnding a lineEnding object.
     */
    public void setLineEnding( String lineEnding )
    {
        this.lineEnding = lineEnding;
    } //-- void setLineEnding( String )

    /**
     * Set additional file extensions to not apply filtering (Since
     * 3.2.0).
     * 
     * @param nonFilteredFileExtensions a nonFilteredFileExtensions
     * object.
     */
    public void setNonFilteredFileExtensions( java.util.List<String> nonFilteredFileExtensions )
    {
        this.nonFilteredFileExtensions = nonFilteredFileExtensions;
    } //-- void setNonFilteredFileExtensions( java.util.List )

    /**
     * Set whether standard exclusion patterns, such as those
     * matching CVS and Subversion
     *             metadata files, should be used when calculating
     * the files affected by this set.
     *             For backward compatibility, the default value is
     * true. (Since 2.2).
     * 
     * @param useDefaultExcludes a useDefaultExcludes object.
     */
    public void setUseDefaultExcludes( boolean useDefaultExcludes )
    {
        this.useDefaultExcludes = useDefaultExcludes;
    } //-- void setUseDefaultExcludes( boolean )

}
