/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.clean;

import java.io.File;
import java.util.Arrays;
import org.apache.maven.plugins.clean.Selector;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.SelectorUtils;

class GlobSelector
implements Selector {
    private final String[] includes;
    private final String[] excludes;
    private final String str;

    GlobSelector(String[] includes, String[] excludes) {
        this(includes, excludes, false);
    }

    GlobSelector(String[] includes, String[] excludes, boolean useDefaultExcludes) {
        this.str = "includes = " + GlobSelector.toString(includes) + ", excludes = " + GlobSelector.toString(excludes);
        this.includes = GlobSelector.normalizePatterns(includes);
        this.excludes = GlobSelector.normalizePatterns(GlobSelector.addDefaultExcludes(excludes, useDefaultExcludes));
    }

    private static String toString(String[] patterns) {
        return patterns == null ? "[]" : Arrays.asList(patterns).toString();
    }

    private static String[] addDefaultExcludes(String[] excludes, boolean useDefaultExcludes) {
        String[] defaults = DirectoryScanner.DEFAULTEXCLUDES;
        if (!useDefaultExcludes) {
            return excludes;
        }
        if (excludes == null || excludes.length <= 0) {
            return defaults;
        }
        String[] patterns = new String[excludes.length + defaults.length];
        System.arraycopy(excludes, 0, patterns, 0, excludes.length);
        System.arraycopy(defaults, 0, patterns, excludes.length, defaults.length);
        return patterns;
    }

    private static String[] normalizePatterns(String[] patterns) {
        String[] normalized;
        if (patterns != null) {
            normalized = new String[patterns.length];
            for (int i = patterns.length - 1; i >= 0; --i) {
                normalized[i] = GlobSelector.normalizePattern(patterns[i]);
            }
        } else {
            normalized = new String[]{};
        }
        return normalized;
    }

    private static String normalizePattern(String pattern) {
        if (pattern == null) {
            return "";
        }
        Object normalized = pattern.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar);
        if (((String)normalized).endsWith(File.separator)) {
            normalized = (String)normalized + "**";
        }
        return normalized;
    }

    @Override
    public boolean isSelected(String pathname) {
        return !(this.includes.length > 0 && !GlobSelector.isMatched(pathname, this.includes) || this.excludes.length > 0 && GlobSelector.isMatched(pathname, this.excludes));
    }

    private static boolean isMatched(String pathname, String[] patterns) {
        for (String pattern : patterns) {
            if (!SelectorUtils.matchPath((String)pattern, (String)pathname)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean couldHoldSelected(String pathname) {
        for (String include : this.includes) {
            if (!SelectorUtils.matchPatternStart((String)include, (String)pathname)) continue;
            return true;
        }
        return this.includes.length <= 0;
    }

    public String toString() {
        return this.str;
    }
}

