/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.tools.JavaFileObject;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.SourceFile;

final class PathFilter
extends SimpleFileVisitor<Path>
implements Predicate<Path> {
    private final boolean defaultInclude;
    private final String[] includes;
    private final String[] excludes;
    private final String[] incrementalExcludes;
    private final PathMatcher[] includeMatchers;
    private final PathMatcher[] excludeMatchers;
    private final PathMatcher[] incrementalExcludeMatchers;
    private final boolean needRelativize;
    private FileSystem fs;
    private List<SourceFile> sourceFiles;
    private SourceDirectory sourceRoot;

    PathFilter(Collection<String> includes, Collection<String> excludes, Collection<String> incrementalExcludes) {
        this.defaultInclude = includes.isEmpty();
        if (this.defaultInclude) {
            includes = List.of("**");
        }
        this.includes = (String[])includes.toArray(String[]::new);
        this.excludes = (String[])excludes.toArray(String[]::new);
        this.incrementalExcludes = (String[])incrementalExcludes.toArray(String[]::new);
        this.includeMatchers = new PathMatcher[this.includes.length];
        this.excludeMatchers = new PathMatcher[this.excludes.length];
        this.incrementalExcludeMatchers = new PathMatcher[this.incrementalExcludes.length];
        this.needRelativize = PathFilter.needRelativize(this.includes) || PathFilter.needRelativize(this.excludes);
    }

    private static boolean needRelativize(String[] patterns) {
        for (String pattern : patterns) {
            if (pattern.startsWith("**")) continue;
            return true;
        }
        return false;
    }

    private void updateDefaultInclude(JavaFileObject.Kind sourceFileKind) {
        String pattern;
        if (this.defaultInclude && !(pattern = "glob:**" + sourceFileKind.extension).equals(this.includes[0])) {
            this.includes[0] = pattern;
            if (this.fs != null) {
                PathFilter.createMatchers(this.includes, this.includeMatchers, this.fs);
            }
        }
    }

    private static void createMatchers(String[] patterns, PathMatcher[] target, FileSystem fs) {
        for (int i = 0; i < patterns.length; ++i) {
            Object pattern = patterns[i];
            if (((String)pattern).indexOf(58) < 0) {
                pattern = "glob:" + (String)pattern;
            }
            target[i] = fs.getPathMatcher((String)pattern);
        }
    }

    @Override
    public boolean test(Path path) {
        FileSystem pfs = path.getFileSystem();
        if (pfs != this.fs) {
            PathFilter.createMatchers(this.includes, this.includeMatchers, pfs);
            PathFilter.createMatchers(this.excludes, this.excludeMatchers, pfs);
            PathFilter.createMatchers(this.incrementalExcludes, this.incrementalExcludeMatchers, pfs);
            this.fs = pfs;
        }
        if (this.needRelativize) {
            path = this.sourceRoot.root.relativize(path);
        }
        for (PathMatcher include : this.includeMatchers) {
            if (!include.matches(path)) continue;
            for (PathMatcher exclude : this.excludeMatchers) {
                if (!exclude.matches(path)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean ignoreModification(Path path) {
        for (PathMatcher exclude : this.incrementalExcludeMatchers) {
            if (!exclude.matches(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (!PathFilter.isHidden(file, attrs) && this.test(file)) {
            this.sourceFiles.add(new SourceFile(this.sourceRoot, file, attrs, this.ignoreModification(file)));
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return PathFilter.isHidden(dir, attrs) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
    }

    private static boolean isHidden(Path file, BasicFileAttributes attrs) {
        if (attrs instanceof DosFileAttributes) {
            DosFileAttributes dos = (DosFileAttributes)attrs;
            return dos.isHidden();
        }
        return file.getFileName().toString().startsWith(".");
    }

    public List<SourceFile> walkSourceFiles(Iterable<SourceDirectory> rootDirectories) throws IOException {
        ArrayList<SourceFile> result = new ArrayList<SourceFile>();
        try {
            this.sourceFiles = result;
            Iterator<SourceDirectory> iterator = rootDirectories.iterator();
            while (iterator.hasNext()) {
                SourceDirectory directory;
                this.sourceRoot = directory = iterator.next();
                this.updateDefaultInclude(directory.fileKind);
                Files.walkFileTree(directory.root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, this);
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        finally {
            this.sourceRoot = null;
            this.sourceFiles = null;
        }
        return result;
    }
}

