/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="get", requiresProject=false, threadSafe=true)
public class GetMojo
extends AbstractMojo {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.*)::(.+)");
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="packaging", defaultValue="jar")
    private String packaging = "jar";
    @Parameter(property="remoteRepositories")
    private String remoteRepositories;
    @Parameter(property="artifact")
    private String artifact;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pomRemoteRepositories;
    @Parameter(property="transitive", defaultValue="true")
    private boolean transitive = true;
    @Parameter(property="mdep.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        if (this.artifactId == null && this.artifact == null) {
            throw new MojoFailureException("You must specify an artifact, e.g. -Dartifact=org.apache.maven.plugins:maven-downloader-plugin:1.0");
        }
        if (this.artifact != null) {
            String[] tokens = StringUtils.split((String)this.artifact, (String)":");
            if (tokens.length < 3 || tokens.length > 5) {
                throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version[:packaging[:classifier]] " + this.artifact);
            }
            this.groupId = tokens[0];
            this.artifactId = tokens[1];
            this.version = tokens[2];
            if (tokens.length >= 4) {
                this.packaging = tokens[3];
            }
            this.classifier = tokens.length == 5 ? tokens[4] : null;
        }
        Artifact toDownload = this.classifier == null ? this.artifactFactory.createBuildArtifact(this.groupId, this.artifactId, this.version, this.packaging) : this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        ArtifactRepositoryPolicy always = new ArtifactRepositoryPolicy(true, "always", "warn");
        ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>();
        if (this.pomRemoteRepositories != null) {
            repoList.addAll(this.pomRemoteRepositories);
        }
        if (this.remoteRepositories != null) {
            List<String> repos = Arrays.asList(StringUtils.split((String)this.remoteRepositories, (String)","));
            for (String repo : repos) {
                repoList.add(this.parseRepository(repo, always));
            }
        }
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setRemoteRepositories(repoList);
            if (this.transitive) {
                this.getLog().info((CharSequence)("Resolving " + toDownload + " with transitive dependencies"));
                this.artifactResolver.resolveTransitively((ProjectBuildingRequest)buildingRequest, toDownload);
            } else {
                this.getLog().info((CharSequence)("Resolving " + toDownload));
                this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, toDownload);
            }
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    ArtifactRepository parseRepository(String repo, ArtifactRepositoryPolicy policy) throws MojoFailureException {
        String id = "temp";
        ArtifactRepositoryLayout layout = this.getLayout("default");
        String url = repo;
        if (repo.contains("::")) {
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(repo);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)repo, "Invalid syntax for repository: " + repo, "Invalid syntax for repository. Use \"id::layout::url\" or \"URL\".");
            }
            id = matcher.group(1).trim();
            if (!StringUtils.isEmpty((String)matcher.group(2))) {
                layout = this.getLayout(matcher.group(2).trim());
            }
            url = matcher.group(3).trim();
        }
        return this.artifactRepositoryFactory.createArtifactRepository(id, url, layout, policy, policy);
    }

    private ArtifactRepositoryLayout getLayout(String id) throws MojoFailureException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoFailureException((Object)id, "Invalid repository layout", "Invalid repository layout: " + id);
        }
        return layout;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

