/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.fromConfiguration;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.dependency.AbstractDependencyMojo;
import org.apache.maven.plugin.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugin.dependency.fromConfiguration.ProcessArtifactItemsRequest;
import org.apache.maven.plugin.dependency.utils.DependencyUtil;
import org.apache.maven.plugin.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.repository.RepositoryManager;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractFromConfigurationMojo
extends AbstractDependencyMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/dependency")
    private File outputDirectory;
    @Parameter(property="mdep.overWriteReleases", defaultValue="false")
    private boolean overWriteReleases;
    @Parameter(property="mdep.overWriteSnapshots", defaultValue="false")
    private boolean overWriteSnapshots;
    @Parameter(property="mdep.overIfNewer", defaultValue="true")
    private boolean overWriteIfNewer;
    @Parameter
    private List<ArtifactItem> artifactItems;
    @Parameter
    private File localRepositoryDirectory;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private RepositoryManager repositoryManager;

    abstract ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem var1);

    protected void verifyRequirements() throws MojoFailureException {
        if (this.artifactItems == null || this.artifactItems.isEmpty()) {
            throw new MojoFailureException("Either artifact or artifactItems is required ");
        }
    }

    protected List<ArtifactItem> getProcessedArtifactItems(ProcessArtifactItemsRequest processArtifactItemsRequest) throws MojoExecutionException {
        boolean removeVersion = processArtifactItemsRequest.isRemoveVersion();
        boolean prependGroupId = processArtifactItemsRequest.isPrependGroupId();
        boolean useBaseVersion = processArtifactItemsRequest.isUseBaseVersion();
        boolean removeClassifier = processArtifactItemsRequest.isRemoveClassifier();
        if (this.artifactItems == null || this.artifactItems.size() < 1) {
            throw new MojoExecutionException("There are no artifactItems configured.");
        }
        for (ArtifactItem artifactItem : this.artifactItems) {
            this.getLog().info((CharSequence)("Configured Artifact: " + artifactItem.toString()));
            if (artifactItem.getOutputDirectory() == null) {
                artifactItem.setOutputDirectory(this.outputDirectory);
            }
            artifactItem.getOutputDirectory().mkdirs();
            if (StringUtils.isEmpty((String)artifactItem.getVersion())) {
                this.fillMissingArtifactVersion(artifactItem);
            }
            artifactItem.setArtifact(this.getArtifact(artifactItem));
            if (StringUtils.isEmpty((String)artifactItem.getDestFileName())) {
                artifactItem.setDestFileName(DependencyUtil.getFormattedFileName(artifactItem.getArtifact(), removeVersion, prependGroupId, useBaseVersion, removeClassifier));
            }
            try {
                artifactItem.setNeedsProcessing(this.checkIfProcessingNeeded(artifactItem));
            }
            catch (ArtifactFilterException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return this.artifactItems;
    }

    private boolean checkIfProcessingNeeded(ArtifactItem item) throws MojoExecutionException, ArtifactFilterException {
        return StringUtils.equalsIgnoreCase((String)item.getOverWrite(), (String)"true") || this.getMarkedArtifactFilter(item).isArtifactIncluded(item);
    }

    protected Artifact getArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        VersionRange vr;
        try {
            vr = VersionRange.createFromVersionSpec((String)artifactItem.getVersion());
        }
        catch (InvalidVersionSpecificationException e1) {
            e1.printStackTrace();
            vr = VersionRange.createFromVersion((String)artifactItem.getVersion());
        }
        Artifact artifact = StringUtils.isEmpty((String)artifactItem.getClassifier()) ? this.getFactory().createDependencyArtifact(artifactItem.getGroupId(), artifactItem.getArtifactId(), vr, artifactItem.getType(), null, "compile") : this.getFactory().createDependencyArtifact(artifactItem.getGroupId(), artifactItem.getArtifactId(), vr, artifactItem.getType(), artifactItem.getClassifier(), "compile");
        Artifact result = this.getArtifactFomReactor(artifact);
        if (result != null) {
            return result;
        }
        try {
            Object buildingRequest = this.localRepositoryDirectory != null ? this.repositoryManager.setLocalRepositoryBasedir(this.session.getProjectBuildingRequest(), this.localRepositoryDirectory) : new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setRemoteRepositories(this.getRemoteRepos());
            artifact = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, artifact);
        }
        catch (ArtifactResolverException e) {
            throw new MojoExecutionException("Unable to find/resolve artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    private Artifact getArtifactFomReactor(Artifact artifact) {
        for (Artifact a : this.getProject().getArtifacts()) {
            if (!AbstractFromConfigurationMojo.equals(artifact, a) || !AbstractFromConfigurationMojo.hasFile(a)) continue;
            return a;
        }
        for (MavenProject p : this.reactorProjects == null ? Collections.emptyList() : this.reactorProjects) {
            if (AbstractFromConfigurationMojo.equals(artifact, p.getArtifact()) && AbstractFromConfigurationMojo.hasFile(p.getArtifact())) {
                return p.getArtifact();
            }
            for (Artifact a : p.getAttachedArtifacts()) {
                if (!AbstractFromConfigurationMojo.equals(artifact, a) || !AbstractFromConfigurationMojo.hasFile(a)) continue;
                return a;
            }
        }
        return null;
    }

    private static boolean hasFile(Artifact artifact) {
        return artifact != null && artifact.getFile() != null && artifact.getFile().isFile();
    }

    private static boolean equals(Artifact a, Artifact b) {
        return a == b || a != null && b != null && StringUtils.equals((String)a.getGroupId(), (String)b.getGroupId()) && StringUtils.equals((String)a.getArtifactId(), (String)b.getArtifactId()) && StringUtils.equals((String)a.getVersion(), (String)b.getVersion()) && StringUtils.equals((String)a.getType(), (String)b.getType()) && StringUtils.equals((String)a.getClassifier(), (String)b.getClassifier());
    }

    private void fillMissingArtifactVersion(ArtifactItem artifact) throws MojoExecutionException {
        List depMngt;
        MavenProject project = this.getProject();
        List deps = project.getDependencies();
        List list = depMngt = project.getDependencyManagement() == null ? Collections.emptyList() : project.getDependencyManagement().getDependencies();
        if (!(this.findDependencyVersion(artifact, deps, false) || project.getDependencyManagement() != null && this.findDependencyVersion(artifact, depMngt, false) || this.findDependencyVersion(artifact, deps, true) || project.getDependencyManagement() != null && this.findDependencyVersion(artifact, depMngt, true))) {
            throw new MojoExecutionException("Unable to find artifact version of " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " in either dependency list or in project's dependency management.");
        }
    }

    private boolean findDependencyVersion(ArtifactItem artifact, List<Dependency> dependencies, boolean looseMatch) {
        for (Dependency dependency : dependencies) {
            if (!StringUtils.equals((String)dependency.getArtifactId(), (String)artifact.getArtifactId()) || !StringUtils.equals((String)dependency.getGroupId(), (String)artifact.getGroupId()) || !looseMatch && !StringUtils.equals((String)dependency.getClassifier(), (String)artifact.getClassifier()) || !looseMatch && !StringUtils.equals((String)dependency.getType(), (String)artifact.getType())) continue;
            artifact.setVersion(dependency.getVersion());
            return true;
        }
        return false;
    }

    public List<ArtifactItem> getArtifactItems() {
        return this.artifactItems;
    }

    public void setArtifactItems(List<ArtifactItem> theArtifactItems) {
        this.artifactItems = theArtifactItems;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File theOutputDirectory) {
        this.outputDirectory = theOutputDirectory;
    }

    public boolean isOverWriteIfNewer() {
        return this.overWriteIfNewer;
    }

    public void setOverWriteIfNewer(boolean theOverWriteIfNewer) {
        this.overWriteIfNewer = theOverWriteIfNewer;
    }

    public boolean isOverWriteReleases() {
        return this.overWriteReleases;
    }

    public void setOverWriteReleases(boolean theOverWriteReleases) {
        this.overWriteReleases = theOverWriteReleases;
    }

    public boolean isOverWriteSnapshots() {
        return this.overWriteSnapshots;
    }

    public void setOverWriteSnapshots(boolean theOverWriteSnapshots) {
        this.overWriteSnapshots = theOverWriteSnapshots;
    }

    public void setLocalRepositoryDirectory(File localRepositoryDirectory) {
        this.localRepositoryDirectory = localRepositoryDirectory;
    }

    public void setArtifact(String artifact) throws MojoFailureException {
        if (artifact != null) {
            String packaging = "jar";
            String[] tokens = StringUtils.split((String)artifact, (String)":");
            if (tokens.length < 3 || tokens.length > 5) {
                throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version[:packaging][:classifier] " + artifact);
            }
            String groupId = tokens[0];
            String artifactId = tokens[1];
            String version = tokens[2];
            if (tokens.length >= 4) {
                packaging = tokens[3];
            }
            String classifier = tokens.length == 5 ? tokens[4] : null;
            Artifact toUnpack = classifier == null ? this.getFactory().createBuildArtifact(groupId, artifactId, version, packaging) : this.getFactory().createArtifactWithClassifier(groupId, artifactId, version, packaging, classifier);
            this.setArtifactItems(Collections.singletonList(new ArtifactItem(toUnpack)));
        }
    }
}

