/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.resolvers;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.dependency.AbstractDependencyMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.collect.CollectorResult;
import org.apache.maven.shared.artifact.collect.DependencyCollector;
import org.apache.maven.shared.artifact.collect.DependencyCollectorException;

@Mojo(name="list-repositories", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class ListRepositoriesMojo
extends AbstractDependencyMojo {
    @Component(role=DependencyCollector.class)
    private DependencyCollector dependencyCollector;

    @Override
    protected void doExecute() throws MojoExecutionException {
        try {
            CollectorResult collectResult = this.dependencyCollector.collectDependencies(this.session.getProjectBuildingRequest(), this.getProject().getArtifact());
            this.getLog().info((CharSequence)"Repositories Used by this build:");
            for (ArtifactRepository repo : collectResult.getRemoteRepositories()) {
                this.getLog().info((CharSequence)repo.toString());
            }
        }
        catch (DependencyCollectorException e) {
            throw new MojoExecutionException("Unable to resolve artifacts", (Exception)((Object)e));
        }
    }
}

