/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.dependency.utils.StringUtils;

public final class DependencyUtil {
    public static String getFormattedFileName(Artifact artifact, boolean removeVersion) {
        return DependencyUtil.getFormattedFileName(artifact, removeVersion, false);
    }

    public static String getFormattedFileName(Artifact artifact, boolean removeVersion, boolean prependGroupId) {
        return DependencyUtil.getFormattedFileName(artifact, removeVersion, prependGroupId, false);
    }

    public static String getFormattedFileName(Artifact artifact, boolean removeVersion, boolean prependGroupId, boolean useBaseVersion) {
        return DependencyUtil.getFormattedFileName(artifact, removeVersion, prependGroupId, useBaseVersion, false);
    }

    public static String getFormattedFileName(Artifact artifact, boolean removeVersion, boolean prependGroupId, boolean useBaseVersion, boolean removeClassifier) {
        StringBuilder destFileName = new StringBuilder();
        if (prependGroupId) {
            destFileName.append(artifact.getGroupId()).append(".");
        }
        String versionString = "";
        if (!removeVersion) {
            versionString = useBaseVersion ? "-" + ArtifactUtils.toSnapshotVersion((String)artifact.getVersion()) : "-" + artifact.getVersion();
        }
        String classifierString = "";
        if (!removeClassifier && StringUtils.isNotEmpty(artifact.getClassifier())) {
            classifierString = "-" + artifact.getClassifier();
        }
        destFileName.append(artifact.getArtifactId()).append(versionString);
        destFileName.append(classifierString).append(".");
        destFileName.append(artifact.getArtifactHandler().getExtension());
        return destFileName.toString();
    }

    public static File getFormattedOutputDirectory(boolean useSubdirsPerScope, boolean useSubdirsPerType, boolean useSubdirPerArtifact, boolean useRepositoryLayout, boolean removeVersion, boolean removeType, File outputDirectory, Artifact artifact) {
        StringBuilder sb = new StringBuilder(128);
        if (useRepositoryLayout) {
            sb.append(artifact.getGroupId().replace('.', File.separatorChar)).append(File.separatorChar);
            sb.append(artifact.getArtifactId()).append(File.separatorChar);
            sb.append(artifact.getBaseVersion()).append(File.separatorChar);
        } else {
            if (useSubdirsPerScope) {
                sb.append(artifact.getScope()).append(File.separatorChar);
            }
            if (useSubdirsPerType) {
                sb.append(artifact.getType()).append("s").append(File.separatorChar);
            }
            if (useSubdirPerArtifact) {
                String artifactString = DependencyUtil.getDependencyId(artifact, removeVersion, removeType);
                sb.append(artifactString).append(File.separatorChar);
            }
        }
        return new File(outputDirectory, sb.toString());
    }

    private static String getDependencyId(Artifact artifact, boolean removeVersion, boolean removeType) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getArtifactId());
        if (!removeVersion) {
            sb.append("-");
            sb.append(artifact.getVersion());
        }
        if (StringUtils.isNotEmpty(artifact.getClassifier())) {
            sb.append("-");
            sb.append(artifact.getClassifier());
        }
        if (!removeType && !Objects.equals(artifact.getClassifier(), artifact.getType())) {
            sb.append("-");
            sb.append(artifact.getType());
        }
        return sb.toString();
    }

    @Deprecated
    public static synchronized void write(String string, File file, boolean append, Log log) throws IOException {
        DependencyUtil.write(string, file, append, "UTF-8");
    }

    public static synchronized void write(String string, File file, boolean append, String encoding) throws IOException {
        Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        StandardOpenOption appendOption = append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING;
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), Charset.forName(encoding), appendOption, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            writer.write(string);
        }
    }

    public static synchronized void log(String string, Log log) throws IOException {
        try (BufferedReader reader = new BufferedReader(new StringReader(string));){
            reader.lines().forEach(arg_0 -> ((Log)log).info(arg_0));
        }
    }

    public static String[] tokenizer(String str) {
        String s = DependencyUtil.cleanToBeTokenizedString(str);
        if (s.isEmpty()) {
            return new String[0];
        }
        return DependencyUtil.cleanToBeTokenizedString(str).split(",");
    }

    public static String cleanToBeTokenizedString(String str) {
        String ret = "";
        if (str != null && !str.isEmpty()) {
            ret = str.trim().replaceAll("\\s*,\\s*", ",");
        }
        return ret;
    }
}

