/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.EarPluginException;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public final class ApplicationXmlWriter {
    public static final String DOCTYPE_1_3 = "application PUBLIC\n\t\"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN\"\n\t\"http://java.sun.com/dtd/application_1_3.dtd\"";
    private static final String APPLICATION_ELEMENT = "application";
    private final String version;
    private final String encoding;

    public ApplicationXmlWriter(String version, String encoding) {
        this.version = version;
        this.encoding = encoding;
    }

    public void write(File destinationFile, List earModules, String displayName, String description) throws EarPluginException {
        FileWriter w;
        try {
            w = new FileWriter(destinationFile);
        }
        catch (IOException ex) {
            throw new EarPluginException("Exception while opening file[" + destinationFile.getAbsolutePath() + "]", ex);
        }
        XMLWriter writer = null;
        if ("1.3".equals(this.version)) {
            writer = this.initializeRootElementOneDotThree(w);
            this.writeDisplayName(displayName, writer);
            this.writeDescription(description, writer);
        } else if ("1.4".equals(this.version)) {
            writer = this.initializeRootElementOneDotFour(w);
            this.writeDescription(description, writer);
            this.writeDisplayName(displayName, writer);
        }
        Iterator i = earModules.iterator();
        while (i.hasNext()) {
            EarModule module = (EarModule)i.next();
            module.appendModule(writer, this.version);
        }
        writer.endElement();
        this.close(w);
    }

    private void writeDescription(String description, XMLWriter writer) {
        if (description != null) {
            writer.startElement("description");
            writer.writeText(description);
            writer.endElement();
        }
    }

    private void writeDisplayName(String displayName, XMLWriter writer) {
        if (displayName != null) {
            writer.startElement("display-name");
            writer.writeText(displayName);
            writer.endElement();
        }
    }

    private void close(Writer closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private XMLWriter initializeRootElementOneDotThree(FileWriter w) {
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, this.encoding, DOCTYPE_1_3);
        writer.startElement(APPLICATION_ELEMENT);
        return writer;
    }

    private XMLWriter initializeRootElementOneDotFour(FileWriter w) {
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, this.encoding, null);
        writer.startElement(APPLICATION_ELEMENT);
        writer.addAttribute("xmlns", "http://java.sun.com/xml/ns/j2ee");
        writer.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.addAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd");
        writer.addAttribute("version", "1.4");
        return writer;
    }
}

