/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.ear.EarModule;
import org.apache.maven.plugin.ear.Ejb3Module;
import org.apache.maven.plugin.ear.EjbClientModule;
import org.apache.maven.plugin.ear.EjbModule;
import org.apache.maven.plugin.ear.JavaModule;
import org.apache.maven.plugin.ear.ParModule;
import org.apache.maven.plugin.ear.RarModule;
import org.apache.maven.plugin.ear.SarModule;
import org.apache.maven.plugin.ear.WebModule;

public final class EarModuleFactory {
    public static final EarModule newEarModule(Artifact artifact, String defaultJavaBundleDir) {
        if ("jar".equals(artifact.getType())) {
            return new JavaModule(artifact, defaultJavaBundleDir);
        }
        if ("ejb".equals(artifact.getType())) {
            return new EjbModule(artifact);
        }
        if ("ejb3".equals(artifact.getType())) {
            return new Ejb3Module(artifact);
        }
        if ("par".equals(artifact.getType())) {
            return new ParModule(artifact);
        }
        if ("ejb-client".equals(artifact.getType())) {
            return new EjbClientModule(artifact);
        }
        if ("rar".equals(artifact.getType())) {
            return new RarModule(artifact);
        }
        if ("war".equals(artifact.getType())) {
            return new WebModule(artifact);
        }
        if ("sar".equals(artifact.getType())) {
            return new SarModule(artifact);
        }
        throw new IllegalStateException("Could not handle artifact type[" + artifact.getType() + "]");
    }
}

