/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.EclipseUtils;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class EclipseClasspathWriter {
    private Log log;

    public EclipseClasspathWriter(Log log) {
        this.log = log;
    }

    protected void write(File projectBaseDir, File basedir, MavenProject project, List referencedReactorArtifacts, EclipseSourceDir[] sourceDirs, List classpathContainers, ArtifactRepository localRepository, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, List remoteArtifactRepositories, boolean downloadSources, String outputDirectory) throws MojoExecutionException {
        FileWriter w;
        try {
            w = new FileWriter(new File(basedir, ".classpath"));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w);
        writer.startElement("classpath");
        for (int j = 0; j < sourceDirs.length; ++j) {
            EclipseSourceDir dir = sourceDirs[j];
            writer.startElement("classpathentry");
            writer.addAttribute("kind", "src");
            writer.addAttribute("path", dir.getPath());
            if (dir.getOutput() != null) {
                writer.addAttribute("output", dir.getOutput());
            }
            writer.endElement();
        }
        writer.startElement("classpathentry");
        writer.addAttribute("kind", "output");
        writer.addAttribute("path", EclipseUtils.toRelativeAndFixSeparator(projectBaseDir, outputDirectory, false));
        writer.endElement();
        writer.startElement("classpathentry");
        writer.addAttribute("kind", "var");
        writer.addAttribute("rootpath", "JRE_SRCROOT");
        writer.addAttribute("path", "JRE_LIB");
        writer.addAttribute("sourcepath", "JRE_SRC");
        writer.endElement();
        List artifacts = project.getTestArtifacts();
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            if (!artifact.getArtifactHandler().isAddedToClasspath()) continue;
            this.addDependency((XMLWriter)writer, artifact, referencedReactorArtifacts, localRepository, artifactResolver, artifactFactory, remoteArtifactRepositories, downloadSources);
        }
        it = classpathContainers.iterator();
        while (it.hasNext()) {
            writer.startElement("classpathentry");
            writer.addAttribute("kind", "con");
            writer.addAttribute("path", (String)it.next());
            writer.endElement();
        }
        writer.endElement();
        IOUtil.close((Writer)w);
    }

    private void addDependency(XMLWriter writer, Artifact artifact, List referencedReactorArtifacts, ArtifactRepository localRepository, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, List remoteArtifactRepositories, boolean downloadSources) throws MojoExecutionException {
        String kind;
        String path;
        String sourcepath = null;
        if (referencedReactorArtifacts.contains(artifact)) {
            path = "/" + artifact.getArtifactId();
            kind = "src";
        } else {
            File artifactPath = artifact.getFile();
            if (artifactPath == null) {
                this.log.error((CharSequence)Messages.getString("EclipsePlugin.artifactpathisnull", artifact.getId()));
                return;
            }
            String fullPath = artifactPath.getPath();
            File localRepositoryFile = new File(localRepository.getBasedir());
            path = "M2_REPO/" + EclipseUtils.toRelativeAndFixSeparator(localRepositoryFile, fullPath, false);
            if (downloadSources) {
                Artifact sourceArtifact = this.retrieveSourceArtifact(artifact, remoteArtifactRepositories, localRepository, artifactResolver, artifactFactory);
                if (!sourceArtifact.isResolved()) {
                    this.log.info((CharSequence)Messages.getString("EclipseClasspathWriter.sourcesnotavailable", sourceArtifact.getArtifactId()));
                } else {
                    this.log.debug((CharSequence)Messages.getString("EclipseClasspathWriter.sourcesavailable", new Object[]{sourceArtifact.getArtifactId(), sourceArtifact.getFile().getAbsolutePath()}));
                    sourcepath = "M2_REPO/" + EclipseUtils.toRelativeAndFixSeparator(localRepositoryFile, sourceArtifact.getFile().getAbsolutePath(), false);
                }
            }
            kind = "var";
        }
        writer.startElement("classpathentry");
        writer.addAttribute("kind", kind);
        writer.addAttribute("path", path);
        if (sourcepath != null) {
            writer.addAttribute("sourcepath", sourcepath);
        }
        writer.endElement();
    }

    private Artifact retrieveSourceArtifact(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository, ArtifactResolver artifactResolver, ArtifactFactory artifactFactory) throws MojoExecutionException {
        Artifact sourceArtifact = artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "java-source", "sources");
        try {
            this.log.debug((CharSequence)Messages.getString("EclipseClasspathWriter.lookingforsources", sourceArtifact.getArtifactId()));
            artifactResolver.resolve(sourceArtifact, remoteArtifactRepositories, localRepository);
        }
        catch (ArtifactNotFoundException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)"Cannot resolve source artifact", (Throwable)e);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error getting source artifact", (Exception)((Object)e));
        }
        return sourceArtifact;
    }
}

