/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.eclipse.EclipseClasspathWriter;
import org.apache.maven.plugin.eclipse.EclipseProjectWriter;
import org.apache.maven.plugin.eclipse.EclipseSettingsWriter;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.EclipseUtils;
import org.apache.maven.plugin.eclipse.EclipseWtpmodulesWriter;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.project.MavenProject;

public class EclipsePlugin
extends AbstractMojo {
    private MavenProject project;
    private MavenProject executedProject;
    private ArtifactRepository localRepository;
    private List reactorProjects;
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private List remoteArtifactRepositories;
    private List projectnatures;
    private List buildcommands;
    private List classpathContainers;
    private boolean downloadSources = false;
    private File outputDir;
    String outputDirectory;

    protected void setProject(MavenProject project) {
        this.project = project;
    }

    protected void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    protected void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    protected void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    protected void setRemoteArtifactRepositories(List remoteArtifactRepositories) {
        this.remoteArtifactRepositories = remoteArtifactRepositories;
    }

    protected void setBuildcommands(List buildcommands) {
        this.buildcommands = buildcommands;
    }

    protected void setClasspathContainers(List classpathContainers) {
        this.classpathContainers = classpathContainers;
    }

    protected void setProjectnatures(List projectnatures) {
        this.projectnatures = projectnatures;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.executedProject == null) {
            this.executedProject = this.project;
        }
        this.assertNotEmpty(this.executedProject.getGroupId(), "groupId");
        this.assertNotEmpty(this.executedProject.getArtifactId(), "artifactId");
        if (this.projectnatures == null) {
            this.projectnatures = new ArrayList();
            this.projectnatures.add("org.eclipse.jdt.core.javanature");
        }
        if (this.buildcommands == null) {
            this.buildcommands = new ArrayList();
            this.buildcommands.add("org.eclipse.jdt.core.javabuilder");
        }
        if (this.classpathContainers == null) {
            this.classpathContainers = new ArrayList();
        }
        if (this.executedProject.getFile() == null || !this.executedProject.getFile().exists()) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.missingpom"));
        }
        if ("pom".equals(this.executedProject.getPackaging()) && this.outputDir == null) {
            this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.pompackaging"));
            return;
        }
        if (this.outputDir == null) {
            this.outputDir = this.executedProject.getFile().getParentFile();
        } else if (!this.outputDir.equals(this.executedProject.getFile().getParentFile())) {
            if (!this.outputDir.isDirectory()) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.notadir", this.outputDir));
            }
            this.outputDir = new File(this.outputDir, this.executedProject.getArtifactId());
            if (!this.outputDir.isDirectory() && !this.outputDir.mkdir()) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.cantcreatedir", this.outputDir));
            }
        }
        this.write();
    }

    public void write() throws MojoExecutionException {
        File projectBaseDir = this.executedProject.getFile().getParentFile();
        List reactorArtifacts = EclipseUtils.resolveReactorArtifacts(this.project, this.reactorProjects);
        EclipseSourceDir[] sourceDirs = EclipseUtils.buildDirectoryList(this.executedProject, this.outputDir, this.getLog(), this.outputDirectory);
        new EclipseClasspathWriter(this.getLog()).write(projectBaseDir, this.outputDir, this.project, reactorArtifacts, sourceDirs, this.classpathContainers, this.localRepository, this.artifactResolver, this.artifactFactory, this.remoteArtifactRepositories, this.downloadSources, this.outputDirectory);
        new EclipseProjectWriter(this.getLog()).write(projectBaseDir, this.outputDir, this.project, this.executedProject, reactorArtifacts, this.projectnatures, this.buildcommands);
        new EclipseSettingsWriter(this.getLog()).write(projectBaseDir, this.outputDir, this.executedProject);
        new EclipseWtpmodulesWriter(this.getLog()).write(this.outputDir, this.executedProject, reactorArtifacts, sourceDirs, this.localRepository);
        this.getLog().info((CharSequence)Messages.getString("EclipsePlugin.wrote", new Object[]{this.project.getArtifactId(), this.outputDir.getAbsolutePath()}));
    }

    private void assertNotEmpty(String string, String elementName) throws MojoFailureException {
        if (string == null) {
            throw new MojoFailureException(Messages.getString("EclipsePlugin.missingelement", elementName));
        }
    }

    public void setDownloadSources(boolean downloadSources) {
        this.downloadSources = downloadSources;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

