/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseUtils;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class EclipseSettingsWriter {
    private Log log;

    public EclipseSettingsWriter(Log log) {
        this.log = log;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void write(File projectBaseDir, File outputDir, MavenProject project) throws MojoExecutionException {
        Properties coreSettings = new Properties();
        String source = EclipseUtils.getPluginSetting(project, "maven-compiler-plugin", "source", null);
        String target = EclipseUtils.getPluginSetting(project, "maven-compiler-plugin", "target", null);
        if (source != null && !"1.3".equals(source)) {
            ((Hashtable)coreSettings).put("org.eclipse.jdt.core.compiler.source", source);
            ((Hashtable)coreSettings).put("org.eclipse.jdt.core.compiler.compliance", source);
        }
        if (target != null && !"1.2".equals(target)) {
            ((Hashtable)coreSettings).put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", target);
        }
        if (!((Hashtable)coreSettings).isEmpty()) {
            File settingsDir = new File(outputDir, "/.settings");
            settingsDir.mkdirs();
            ((Hashtable)coreSettings).put("eclipse.preferences.version", "1");
            try {
                File coreSettingsFile = new File(settingsDir, "org.eclipse.jdt.core.prefs");
                if (coreSettingsFile.exists()) {
                    File oldCoreSettingsFile = coreSettingsFile;
                    Properties props = new Properties();
                    props.load(new FileInputStream(oldCoreSettingsFile));
                    if (((Hashtable)props).equals(coreSettings)) return;
                    coreSettings.store(new FileOutputStream(coreSettingsFile), null);
                    return;
                }
                coreSettings.store(new FileOutputStream(coreSettingsFile), null);
                this.log.info((CharSequence)Messages.getString("EclipseSettingsWriter.wrotesettings", coreSettingsFile.getAbsolutePath()));
                return;
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException(Messages.getString("EclipseSettingsWriter.cannotcreatesettings"), (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException(Messages.getString("EclipseSettingsWriter.errorwritingsettings"), (Exception)e);
            }
        } else {
            this.log.info((CharSequence)Messages.getString("EclipseSettingsWriter.usingdefaults"));
        }
    }
}

