/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin.exo;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.exoplatform.maven2.plugin.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoModule
extends AbstractMojo {
    private String serverLibDir;
    private String serverWebappDir;
    private String excludeProjects;
    private MavenProject project;
    private String deploy;

    public void execute() throws MojoExecutionException {
        try {
            if (this.deploy != null) {
                if (this.deploy.equals("all")) {
                    this.deployModule(this.serverLibDir, this.serverWebappDir, this.project, true);
                    return;
                }
                if (this.deploy.equals("nodep")) {
                    this.deployModule(this.serverLibDir, this.serverWebappDir, this.project, false);
                    return;
                }
                if (this.deploy.equals("resource")) {
                    if (this.deployResource()) {
                        return;
                    }
                } else if (!(this.deploy.equals("resource") || this.deploy.equals("all") || this.deploy.equals("nodep"))) {
                    this.getLog().info((CharSequence)("Invalid task 'exo:module'  The parameter -Ddeploy=" + this.deploy + " is invalid !\n" + "      Goal exo:module -Ddeploy=" + this.deploy + " does not exist in this project \n\n"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.printInfo();
    }

    public void deployModule(String libDir, String webappDir, MavenProject project, boolean deployAll) throws Exception {
        File directoryJar = new File(libDir);
        File directoryWar = new File(webappDir);
        HashSet<String> ignoreProjects = this.getIgnoreProjects();
        System.out.println("  ==========================================================================\n                    DEPLOY MODULE  " + project.getArtifactId() + "              \n " + " ==========================================================================\n");
        Utils.deployProject(directoryJar, directoryWar, project, deployAll, ignoreProjects);
    }

    private boolean deployResource() throws IOException {
        String packaging = this.project.getPackaging();
        if (!packaging.equals("jar") && (packaging.equals("war") || packaging.equals("exo-portal") || packaging.equals("exo-portlet"))) {
            File resourceDir = new File(this.serverWebappDir + "/" + this.project.getBuild().getFinalName());
            if (!resourceDir.exists()) {
                this.getLog().info((CharSequence)("The directory" + resourceDir + " is does not exists !"));
                return false;
            }
            File deployResourceDir = new File(this.project.getBasedir().toString() + "/src/webapp");
            if (deployResourceDir.exists()) {
                int counter = Utils.copyDirectoryStructure(deployResourceDir, resourceDir, Utils.getDefaultIgnoreFiles(), true);
                if (counter > 0) {
                    Utils.printMessage("copy", "copied " + counter + " file to directory " + resourceDir + ".");
                }
            } else {
                this.getLog().info((CharSequence)("The directory" + deployResourceDir.toString() + " is does not exists !"));
                return false;
            }
            if (packaging.equals("exo-portlet")) {
                int denum;
                File srcVelocityDir = new File(this.project.getBasedir() + "/src/java");
                File destVelocityDir = new File(resourceDir.getPath() + "/velocity");
                if (!srcVelocityDir.exists()) {
                    return true;
                }
                if (!destVelocityDir.exists()) {
                    destVelocityDir.mkdirs();
                }
                if ((denum = this.deployResourceFiles(srcVelocityDir, destVelocityDir, Utils.getDefaultIgnoreFiles(), this.copyFiles())) > 0) {
                    Utils.printMessage("copy", "copied " + denum + " file to directory " + destVelocityDir + ".");
                }
            }
            return true;
        }
        return true;
    }

    private int deployResourceFiles(File srcDir, File desDir, HashSet<String> ignoreFiles, HashSet<String> copyFiles) throws IOException {
        if (!srcDir.exists()) {
            throw new IOException("Source directory doesn't exists (" + srcDir.getAbsolutePath() + ").");
        }
        int counter = 0;
        File[] files = srcDir.listFiles();
        String sourcePath = srcDir.getAbsolutePath();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(desDir, dest);
            if (file.isFile()) {
                if (!copyFiles.contains(file.getName().substring(file.getName().lastIndexOf("."))) || ignoreFiles.contains(file.getName())) continue;
                if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                if (file.lastModified() <= destination.lastModified()) continue;
                destination = destination.getParentFile();
                Utils.copyFileToDirectory((File)file, (File)destination);
                ++counter;
                continue;
            }
            if (!file.isDirectory() || ignoreFiles.contains(file.getName())) continue;
            counter += this.deployResourceFiles(file, destination, ignoreFiles, copyFiles);
        }
        return counter;
    }

    private HashSet<String> copyFiles() {
        HashSet<String> copyFiles = new HashSet<String>();
        copyFiles.add(".vm");
        copyFiles.add(".gtmpl");
        return copyFiles;
    }

    protected HashSet<String> getIgnoreProjects() {
        HashSet<String> ignoreProjects = new HashSet<String>();
        if (this.excludeProjects != null) {
            String[] pro;
            for (String s : pro = this.excludeProjects.split(",")) {
                ignoreProjects.add(s.trim());
            }
        }
        return ignoreProjects;
    }

    private void printInfo() throws MojoExecutionException {
        String info = "The 'exo:module  maven2 plugin is used to deploy a single module to the working server.\nTo run the command successfully you need to run mvn install  before running the commandmvn exo:module -Dparam=value\n\nThe valid syntax are:\n*  mvn exo:module -Ddeploy=all'\n   This command  copies  your module  and the dependency modules to the working server\n*  mvn exo:module -Ddeploy=nodep'\n   This command  copies  only your module to the working server\n*  mvn exo:module -Ddeploy=resource'\n   This command  copies  only the static resources of  your  module to the running server.\n   It is useful  when  you modify a vm template  or css and want to depploy it to\n   the running server  without  restarting it";
        System.out.println(info);
        throw new MojoExecutionException("");
    }
}

