/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin.exo;

import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.exoplatform.maven2.plugin.Utils;
import org.exoplatform.maven2.plugin.exo.ExoPackaging;

public class ExoPortalPackaging
extends ExoPackaging {
    private String sharedDir;
    private File warSourceDirectory;
    private String warName;

    public void execute() throws MojoExecutionException {
        try {
            File webappDest = new File(this.outputDirectory + "/" + this.warName);
            if (this.sharedDir == null) {
                this.getLog().info((CharSequence)"You do not specify a shared webapp directory.........................");
            } else {
                File shareFile = new File(this.sharedDir);
                Utils.copyDirectoryStructure(shareFile, webappDest, Utils.getDefaultIgnoreFiles());
            }
            Utils.copyDirectoryStructure(this.warSourceDirectory, webappDest, Utils.getDefaultIgnoreFiles());
            Set artifacts = this.project.getDependencyArtifacts();
            for (Artifact artifact : artifacts) {
                if (!"bpar".equals(artifact.getType())) continue;
                File bpDest = new File(this.outputDirectory + "/" + this.warName + "/WEB-INF/conf/bp");
                if (!bpDest.exists()) {
                    bpDest.mkdir();
                }
                Utils.copyFileToDirectory((File)artifact.getFile(), (File)bpDest);
            }
            File warFile = new File(this.outputDirectory, this.warName + ".war");
            this.performPackaging(warFile, webappDest);
        }
        catch (Exception exe) {
            throw new MojoExecutionException("Coppy Share directory to " + this.project.getBuild().getFinalName() + " directory error :", exe);
        }
    }
}

