/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin.exo;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.exoplatform.maven2.plugin.Utils;
import org.exoplatform.maven2.plugin.exo.ExoPackaging;
import org.exoplatform.tools.xml.webapp.v23.ModifyWebXMLOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExoPortletPackaging
extends ExoPackaging {
    private File warSourceDirectory;
    private String warName;

    public void execute() throws MojoExecutionException {
        try {
            File webappDest = new File(this.outputDirectory + "/" + this.warName);
            Utils.copyDirectoryStructure(this.warSourceDirectory, webappDest, Utils.getDefaultIgnoreFiles());
            File classesSrc = new File(this.outputDirectory + "/classes");
            if (classesSrc.exists()) {
                File webappClassDest = new File(this.outputDirectory + "/" + this.warName + "/WEB-INF/classes");
                if (!webappClassDest.exists()) {
                    webappClassDest.mkdir();
                }
                FileUtils.copyDirectoryStructure((File)classesSrc, (File)webappClassDest);
            }
            String webxml = this.outputDirectory + "/" + this.warName + "/WEB-INF/web.xml";
            this.modifyWeb(webxml, webxml, this.warName);
            File warFile = new File(this.outputDirectory, this.warName + ".war");
            this.performPackaging(warFile, webappDest);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyWeb(String inputURL, String outputURL, String warName) throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ModifyWebXMLOperation.class.getClassLoader());
        ModifyWebXMLOperation op = new ModifyWebXMLOperation(warName);
        File inputFile = new File(inputURL);
        File outputFile = new File(outputURL);
        try {
            op.modifyWebXML(inputFile, outputFile);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void modifyWithDOM(InputStream is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setCoalescing(true);
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(is);
        String encoding = "UTF-8";
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("encoding", encoding);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        serializer.transform(new DOMSource(document), new StreamResult(bout));
        System.out.println(bout.toString(encoding));
    }

    private Node addExoPortletDeployer(Document pDoc) {
        Element listener = pDoc.createElement("listener");
        Element listenerClass = pDoc.createElement("listener-class");
        listenerClass.appendChild(pDoc.createTextNode("test"));
        listener.appendChild(listenerClass);
        return listener;
    }

    protected Node getWebAppNode(Document pDoc) throws Exception {
        Node result = pDoc.getElementsByTagName("web-app").item(0);
        return result;
    }
}

