/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin.exo;

import java.io.File;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.exoplatform.maven2.plugin.Utils;

public class ExoProcessPackaging
extends AbstractMojo {
    protected String outputDirectory;
    private JarArchiver jarArchiver = new JarArchiver();
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    protected MavenProject project;
    private String excludeProjects;
    private File processConfDirectory;
    private String pbarName;

    public void execute() throws MojoExecutionException {
        try {
            File pbarDest = new File(this.outputDirectory + "/" + this.pbarName);
            Utils.copyDirectoryStructure(this.processConfDirectory, pbarDest, Utils.getDefaultIgnoreFiles());
            File classesSrc = new File(this.outputDirectory + "/classes");
            if (classesSrc.exists()) {
                File pbarClassDest = new File(this.outputDirectory + "/" + this.pbarName + "/classes");
                if (!pbarClassDest.exists()) {
                    pbarClassDest.mkdir();
                }
                FileUtils.copyDirectoryStructure((File)classesSrc, (File)pbarClassDest);
            }
            File pbarFile = new File(this.outputDirectory, this.pbarName + ".pbar");
            this.performPackaging(pbarFile, pbarDest);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error", ex);
        }
    }

    protected void performPackaging(File pbarFile, File pbarDest) throws Exception {
        this.getLog().info((CharSequence)("Generating pbar " + pbarFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(pbarFile);
        this.jarArchiver.addDirectory(pbarDest);
        archiver.createArchive(this.project, this.archive);
        this.project.getArtifact().setFile(pbarFile);
    }
}

