/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.maven2.plugin.exo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.exoplatform.maven2.plugin.Utils;
import org.exoplatform.maven2.plugin.exo.ExoPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoRelease
extends ExoPlatform {
    private String workingDir;
    private String releaseDir;
    private String cleanTomcatDir;
    private String sharedResourcesDir;
    private String release;

    @Override
    public void execute() throws MojoExecutionException {
        if (!"exo-portal".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("You need to run this command in a exo-portal type project");
        }
        try {
            File releaseFile = new File(this.releaseDir);
            if (!releaseFile.exists()) {
                releaseFile.mkdirs();
            }
            if (this.release != null) {
                if (this.release.equals("tomcat")) {
                    this.execReleaseTomcat();
                } else if (this.release.equals("jonas")) {
                    this.execReleaseJonas();
                } else if (this.release.equals("jboss")) {
                    this.execReleaseJboss();
                }
            }
        }
        catch (Exception exe) {
            throw new MojoExecutionException("Error: ", exe);
        }
    }

    private void execReleaseTomcat() throws Exception {
        File deployTomcatDir = new File(this.workingDir + "/exo-tomcat");
        File cleanTomcatDirFile = new File(this.cleanTomcatDir);
        if (!deployTomcatDir.exists()) {
            Utils.copyDirectoryStructure((File)cleanTomcatDirFile, (File)deployTomcatDir);
        }
        String libDir = deployTomcatDir + "/common/lib";
        String webappDir = deployTomcatDir + "/webapps";
        File directoryJar = new File(libDir);
        File directoryWar = new File(webappDir);
        Utils.deployProject(directoryJar, directoryWar, this.project, true, this.getIgnoreProjects());
        Utils.patchConfig(new File(this.sharedResourcesDir + "/patch-tomcat"), deployTomcatDir);
        File output = new File(this.releaseDir + "/exo-tomcat.zip");
        this.addToArchive(deployTomcatDir, output);
        Utils.printMessage("archive", "  Created 1 file zip  to " + this.releaseDir);
        Utils.deleteDirectory((File)deployTomcatDir);
    }

    private void execReleaseJonas() throws Exception {
        File deployJonasDir = new File(this.workingDir + "/exo-jonas");
        File output = new File(this.releaseDir + "/exo-jonas.zip");
        this.addToArchive(deployJonasDir, output);
        Utils.printMessage("archive", "  Created 1  file zip to " + this.releaseDir);
    }

    private void execReleaseJboss() throws Exception {
        File deployJbossDir = new File(this.workingDir + "/exo-jboss/server/default/deploy/exoplatform.sar");
        if (!deployJbossDir.exists()) {
            deployJbossDir.mkdir();
        }
        this.deployJboss(deployJbossDir, this.getIgnoreProjects());
        Utils.patchConfig(new File(this.sharedResourcesDir + "/exoplatform.sar"), deployJbossDir);
        File output = new File(this.releaseDir + "/exoplatform.sar.zip");
        this.addToArchive(deployJbossDir, output);
        Utils.printMessage("archive", "  Created 1  file zip to " + this.releaseDir);
        Utils.deleteDirectory((File)deployJbossDir);
    }

    private void addToArchive(File input, File output) throws Exception {
        String path = input.getAbsolutePath();
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(output)));
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        BufferedInputStream origin = null;
        List<File> files = this.getFiles(input);
        if (files == null || files.size() < 1) {
            return;
        }
        int index = 0;
        for (File f : files) {
            int count;
            ++index;
            String filePath = f.getAbsolutePath();
            if (filePath.startsWith(path)) {
                filePath = filePath.substring(path.length());
            }
            FileInputStream fi = new FileInputStream(f);
            origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(filePath);
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
        }
        out.close();
    }

    private List<File> getFiles(File dir) {
        final LinkedList<File> files = new LinkedList<File>();
        dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                files.add(f);
                return true;
            }
        });
        dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                if (f.isFile()) {
                    return false;
                }
                files.addAll(ExoRelease.this.getFiles(f));
                return false;
            }
        });
        return files;
    }
}

