/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tools.xml.webapp.v23;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.exoplatform.tools.xml.ModificationTaskException;
import org.exoplatform.tools.xml.XMLModificationTask;
import org.exoplatform.tools.xml.XMLUtils;
import org.exoplatform.tools.xml.webapp.v23.WebAppDisplayNameModifyTask;
import org.exoplatform.tools.xml.webapp.v23.WebAppListenerClassModifyTask;
import org.exoplatform.tools.xml.webapp.v23.WebAppModifyTask;
import org.exoplatform.tools.xml.webapp.v23.WebAppServletMappingModifyTask;
import org.exoplatform.tools.xml.webapp.v23.WebAppServletModifyTask;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ModifyWebXMLOperation {
    private String mContextRoot = null;

    public ModifyWebXMLOperation(String pContextRoot) {
        this.mContextRoot = pContextRoot;
    }

    public void modifyWebXML(File pBefore, File pAfter) throws InterruptedException, SAXException, IOException, ModificationTaskException {
        FileInputStream fileStream = new FileInputStream(pBefore);
        Document doc = XMLUtils.loadDOMDocument(fileStream);
        XMLUtils.closeStream(fileStream);
        String encoding = XMLUtils.getEncoding(doc);
        XMLModificationTask[] tasks = this.getModificationTasks();
        int sizei = tasks.length;
        for (int i = 0; i < sizei; ++i) {
            tasks[i].modify(doc);
        }
        fileStream = new FileInputStream(pBefore);
        byte[] formatted = XMLUtils.getFormattedDoc(doc, encoding, fileStream);
        XMLUtils.closeStream(fileStream);
        FileOutputStream outputStream = new FileOutputStream(pAfter);
        outputStream.write(formatted);
        XMLUtils.closeStream(outputStream);
    }

    public XMLModificationTask[] getModificationTasks() {
        ArrayList<WebAppModifyTask> list = new ArrayList<WebAppModifyTask>();
        if (this.mContextRoot != null) {
            list.add(new WebAppDisplayNameModifyTask(this.mContextRoot));
        }
        list.add(new WebAppListenerClassModifyTask("org.exoplatform.services.portletcontainer.impl.servlet.PortletApplicationListener"));
        list.add(new WebAppServletModifyTask("PortletWrapper", "org.exoplatform.services.portletcontainer.impl.servlet.ServletWrapper"));
        list.add(new WebAppServletMappingModifyTask("PortletWrapper", "/PortletWrapper"));
        XMLModificationTask[] tasks = new XMLModificationTask[list.size()];
        return list.toArray(tasks);
    }
}

