/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tools.xml.webapp.v23;

import org.exoplatform.tools.xml.webapp.v23.WebAppModifyTask;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WebAppServletModifyTask
extends WebAppModifyTask {
    public static final String CLASS_VERSION = "$Id: WebAppServletModifyTask.java,v 1.1 2004/04/19 03:45:49 hatimk Exp $";
    private String mServletName;
    private String mServletClassName;
    private XPath mServletNameXPath;
    private XPath mServletClassXPath;

    public WebAppServletModifyTask(String pServletName, String pServletClassName) {
        this.mServletName = pServletName;
        this.mServletClassName = pServletClassName;
    }

    protected int detect(Document pDoc) throws JaxenException {
        Node servletNode;
        if (this.mServletNameXPath == null) {
            this.mServletNameXPath = new DOMXPath("/web-app/servlet[servlet-name=\"" + this.mServletName + "\"]");
        }
        if (this.mServletClassXPath == null) {
            this.mServletClassXPath = new DOMXPath("servlet-class=\"" + this.mServletClassName + "\"");
        }
        if ((servletNode = (Node)this.mServletNameXPath.selectSingleNode((Object)pDoc)) != null) {
            if (this.mServletClassXPath.booleanValueOf((Object)servletNode)) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    protected void insert(Document pDoc) throws JaxenException {
        Node parent = this.getWebAppNode(pDoc);
        this.insertElement(parent, this.createServletElement(pDoc), WEBAPP_CHILD_ELEMENTS);
    }

    protected void replace(Document pDoc) throws JaxenException {
        DOMXPath servletClassXPath = new DOMXPath("servlet-class");
        Node parent = (Node)this.mServletNameXPath.selectSingleNode((Object)pDoc);
        Node servletClassNode = (Node)servletClassXPath.selectSingleNode((Object)parent);
        if (servletClassNode == null) {
            this.insertElement(parent, this.createServletClassElement(pDoc), SERVLET_CHILD_ELEMENTS);
        } else {
            parent.replaceChild(this.createServletClassElement(pDoc), servletClassNode);
        }
    }

    private Node createServletElement(Document pDoc) {
        Node servletClass = this.createServletClassElement(pDoc);
        Text servletNameText = pDoc.createTextNode(this.mServletName);
        Element servletName = pDoc.createElement("servlet-name");
        Element servlet = pDoc.createElement("servlet");
        servletName.appendChild(servletNameText);
        servlet.appendChild(servletName);
        servlet.appendChild(servletClass);
        return servlet;
    }

    private Node createServletClassElement(Document pDoc) {
        Text servletClassText = pDoc.createTextNode(this.mServletClassName);
        Element servletClass = pDoc.createElement("servlet-class");
        servletClass.appendChild(servletClassText);
        return servletClass;
    }
}

