/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.tools.xml.webapp.v23;

import org.exoplatform.tools.xml.webapp.v23.WebAppModifyTask;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WebAppDisplayNameModifyTask
extends WebAppModifyTask {
    public static final String CLASS_VERSION = "$Id: WebAppDisplayNameModifyTask.java,v 1.1 2004/04/19 03:45:49 hatimk Exp $";
    private XPath mDisplayNameXPath;
    private String mContextRootName;

    public WebAppDisplayNameModifyTask(String pContextRootName) {
        this.mContextRootName = pContextRootName;
    }

    protected int detect(Document pDoc) throws JaxenException {
        Node displayNameNode = this.getDisplayNameNode(pDoc);
        if (displayNameNode == null) {
            return 2;
        }
        String displayNameValue = WebAppDisplayNameModifyTask.getTextContent(displayNameNode);
        if (displayNameValue != null && displayNameValue.equals(this.mContextRootName)) {
            return 0;
        }
        return 1;
    }

    protected void insert(Document pDoc) throws JaxenException {
        Node parent = this.getWebAppNode(pDoc);
        this.insertElement(parent, this.createDisplayNameNode(pDoc), WEBAPP_CHILD_ELEMENTS);
    }

    protected void replace(Document pDoc) throws JaxenException {
        Node displayNameNode = this.getDisplayNameNode(pDoc);
        Node parent = displayNameNode.getParentNode();
        parent.replaceChild(this.createDisplayNameNode(pDoc), displayNameNode);
    }

    private Node getDisplayNameNode(Document pDoc) throws JaxenException {
        Node result = null;
        if (this.mDisplayNameXPath == null) {
            this.mDisplayNameXPath = new DOMXPath("/web-app/display-name");
        }
        result = (Node)this.mDisplayNameXPath.selectSingleNode((Object)pDoc);
        return result;
    }

    private Node createDisplayNameNode(Document pDoc) {
        Element displayName = pDoc.createElement("display-name");
        Text displayNameValue = pDoc.createTextNode(this.mContextRootName);
        displayName.appendChild(displayNameValue);
        return displayName;
    }
}

